/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.assetowner.builders.FileSystemBuilder;
import org.odpi.openmetadata.accessservices.assetowner.converters.FileSystemConverter;
import org.odpi.openmetadata.accessservices.assetowner.properties.FileSystem;
import org.odpi.openmetadata.accessservices.assetowner.properties.Folder;
import org.odpi.openmetadata.adapters.connectors.datastore.avrofile.AvroFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.AssetBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileSystemHandler {
    private String serviceName;
    private String serverName;
    private List<String> supportedZones;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetHandler assetHandler;
    private SchemaTypeHandler schemaTypeHandler;
    private static final String folderDivider = "/";
    private static final String fileSystemDivider = "://";
    private static final String fileTypeDivider = "\\.";
    private static final String defaultAvroFileType = "avro";
    private static final String defaultCSVFileType = "csv";

    public FileSystemHandler(String serviceName, String serverName, List<String> supportedZones, AssetHandler assetHandler, SchemaTypeHandler schemaTypeHandler, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.assetHandler = assetHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    private String getFileSystemName(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileSystemDivider)).length > 1) {
            result = tokens[0] + fileSystemDivider;
        }
        return result;
    }

    private List<String> getFolderNames(String pathName) {
        String[] tokens;
        ArrayList<String> result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(folderDivider)).length > 1) {
            int startingToken = 0;
            if (this.getFileSystemName(pathName) != null) {
                startingToken = 2;
            }
            int endingToken = tokens.length;
            if (this.getFileName(pathName) != null) {
                --endingToken;
            }
            if (startingToken != endingToken) {
                result = new ArrayList<String>();
                result.addAll(Arrays.asList(tokens).subList(startingToken, endingToken));
            }
        }
        return result;
    }

    private String getFileName(String pathName) {
        String result = null;
        if (pathName != null && !pathName.isEmpty()) {
            String[] tokens = pathName.split(folderDivider);
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileType(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileTypeDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public String createFileSystemInCatalog(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileSystemBuilder builder = new FileSystemBuilder(uniqueName, displayName, description, type, version, patchLevel, source, format, encryption, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        String fileSystemGUID = this.repositoryHandler.createEntity(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", builder.getInstanceProperties(methodName), methodName);
        if (fileSystemGUID != null) {
            this.repositoryHandler.classifyEntity(userId, fileSystemGUID, "cab5ba1d-cfd3-4fca-857d-c07711fc4157", "FileSystem", builder.getClassificationInstanceProperties(methodName), methodName);
        }
        return fileSystemGUID;
    }

    private String createFolder(String userId, String pathName, String displayName, String description, String typeName, Connection connection, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset asset = this.assetHandler.createEmptyAsset(typeName, methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(pathName);
        return this.assetHandler.addAsset(userId, asset, connection, methodName);
    }

    private String createFileAsset(String userId, String fileType, String pathName, String displayName, String description, String typeName, Connection connection, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset asset = this.assetHandler.createEmptyAsset(typeName, methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(pathName);
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("fileType", fileType);
        asset.setExtendedProperties(extendedProperties);
        return this.assetHandler.addAsset(userId, asset, connection, methodName);
    }

    private String createFolderInCatalog(String userId, String anchorGUID, String pathName, String folderName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorGUID";
        String folderGUID = this.createFolder(userId, pathName, folderName, null, "FileFolder", null, methodName);
        if (anchorGUID != null) {
            if (this.repositoryHandler.isEntityATypeOf(userId, anchorGUID, "anchorGUID", "SoftwareServerCapability", methodName)) {
                this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", anchorGUID, folderGUID, null, methodName);
            } else {
                this.repositoryHandler.createRelationship(userId, "48ac9028-45dd-495d-b3e1-622685b54a01", anchorGUID, folderGUID, null, methodName);
            }
        }
        return folderGUID;
    }

    private List<String> createFolderStructureInCatalog(String userId, String anchorGUID, String fileSystemName, List<String> folderNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> folderGUIDs = new ArrayList<String>();
        if (folderNames != null && !folderNames.isEmpty()) {
            String pathName = null;
            String folderName = null;
            String nextAnchorGUID = anchorGUID;
            for (String folderFragment : folderNames) {
                pathName = pathName == null ? (fileSystemName != null ? fileSystemName + folderFragment : folderFragment) : pathName + folderDivider + folderFragment;
                folderName = folderName != null ? folderName + folderDivider + folderFragment : folderFragment;
                Folder currentFolder = this.getFolderByPathName(userId, pathName, methodName);
                if (currentFolder == null) {
                    String folderGUID = this.createFolderInCatalog(userId, nextAnchorGUID, pathName, folderName, methodName);
                    folderGUIDs.add(folderGUID);
                    nextAnchorGUID = folderGUID;
                    continue;
                }
                folderGUIDs.add(currentFolder.getGUID());
                nextAnchorGUID = currentFolder.getGUID();
            }
        }
        if (folderGUIDs.isEmpty()) {
            return null;
        }
        return folderGUIDs;
    }

    public List<String> createFolderStructureInCatalog(String userId, String anchorGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, anchorGUID, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public List<String> createFolderStructureInCatalog(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, null, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public void attachFolderToFileSystem(String userId, String fileSystemGUID, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileSystem fileSystem = this.getFileSystemByGUID(userId, fileSystemGUID, methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        if (fileSystem != null && folder != null) {
            this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", fileSystemGUID, folderGUID, null, methodName);
        } else if (fileSystem == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileSystemGUID, "SoftwareServerCapability", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void detachFolderFromFileSystem(String userId, String fileSystemGUID, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileSystem fileSystem = this.getFileSystemByGUID(userId, fileSystemGUID, methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        if (fileSystem != null && folder != null) {
            this.repositoryHandler.removeRelationshipBetweenEntities(userId, "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", fileSystemGUID, "SoftwareServerCapability", folderGUID, methodName);
        } else if (fileSystem == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileSystemGUID, "SoftwareServerCapability", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void attachDataFileAssetToFolder(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFile = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        if (dataFile != null && folder != null) {
            this.repositoryHandler.createRelationship(userId, "970a3405-fde1-4039-8249-9aa5f56d5151", folderGUID, fileGUID, null, methodName);
        } else if (dataFile == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileGUID, "DataFile", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void detachDataFileAssetFromFolder(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFile = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        if (dataFile != null && folder != null) {
            this.repositoryHandler.removeRelationshipBetweenEntities(userId, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", folderGUID, "FileFolder", folderGUID, methodName);
        } else if (dataFile == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileGUID, "SoftwareServerCapability", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void moveDataFileInCatalog(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset file = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void moveDataFolderInCatalog(String userId, String folderGUID, String dataFolderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUIDParameterName = "folderGUID";
        String dataFolderGUIDParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "pathName", methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFolder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, dataFolderGUID, this.serviceName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    private List<String> addFileAssetPath(String userId, String fileAssetGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileSystemName = this.getFileSystemName(pathName);
        String fileSystemGUID = null;
        ArrayList<String> assetGUIDList = new ArrayList<String>();
        if (fileSystemName != null) {
            FileSystem fileSystem = this.getFileSystemByUniqueName(userId, fileSystemName, methodName);
            fileSystemGUID = fileSystem == null ? this.createFileSystemInCatalog(userId, fileSystemName, fileSystemName, null, null, null, null, null, null, null, null, null) : fileSystem.getGUID();
        }
        List<String> folderNames = this.getFolderNames(pathName);
        List<String> folderGUIDs = null;
        String fileAnchorGUID = folderNames == null ? fileSystemGUID : ((folderGUIDs = this.createFolderStructureInCatalog(userId, fileSystemGUID, fileSystemName, folderNames, methodName)) != null && !folderGUIDs.isEmpty() ? folderGUIDs.get(folderGUIDs.size() - 1) : fileSystemGUID);
        if (fileAssetGUID != null && fileAnchorGUID != null) {
            if (folderNames != null) {
                this.repositoryHandler.createRelationship(userId, "4cb88900-1446-4eb6-acea-29cd9da45e63", fileAnchorGUID, fileAssetGUID, null, methodName);
            } else {
                this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", fileAnchorGUID, fileAssetGUID, null, methodName);
            }
        }
        if (fileSystemGUID != null) {
            assetGUIDList.add(fileSystemGUID);
        }
        if (folderGUIDs != null) {
            assetGUIDList.addAll(folderGUIDs);
        }
        if (fileAssetGUID != null) {
            assetGUIDList.add(fileAssetGUID);
        }
        if (assetGUIDList.isEmpty()) {
            return null;
        }
        return assetGUIDList;
    }

    public List<String> addDataFileAssetToCatalog(String userId, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileType = this.getFileType(pathName);
        String fileAssetGUID = this.createFileAsset(userId, fileType, pathName, displayName, description, "DataFile", this.getDataFileConnection(pathName), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, pathName, methodName);
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileAssetGUID = this.createFolder(userId, pathName, displayName, description, "DataFolder", this.getDataFolderConnection(pathName), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, pathName, methodName);
    }

    public List<String> addAvroFileToCatalog(String userId, String displayName, String description, String fullPath, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultAvroFileType;
        }
        String fileAssetGUID = this.createFileAsset(userId, fileType, fullPath, displayName, description, "AvroFile", this.getAvroFileConnection(fullPath), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, fullPath, methodName);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultCSVFileType;
        }
        Asset asset = this.assetHandler.createEmptyAsset("CSVFile", methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(fullPath);
        SchemaType schemaType = null;
        List<SchemaAttribute> schemaAttributes = null;
        if (columnHeaders != null) {
            schemaType = this.getTabularSchemaType(this.schemaTypeHandler, asset.getQualifiedName(), asset.getDisplayName(), userId, "CSVFile", columnHeaders);
            schemaAttributes = this.getTabularSchemaColumns(this.schemaTypeHandler, schemaType.getQualifiedName(), columnHeaders);
        }
        if (delimiterCharacter == null) {
            delimiterCharacter = Character.valueOf(',');
        }
        if (quoteCharacter == null) {
            quoteCharacter = Character.valueOf('\"');
        }
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("delimiterCharacter", delimiterCharacter.toString());
        extendedProperties.put("quoteCharacter", quoteCharacter.toString());
        extendedProperties.put("fileType", fileType);
        asset.setExtendedProperties(extendedProperties);
        String fileAssetGUID = this.assetHandler.addAsset(userId, asset, schemaType, schemaAttributes, this.getCSVFileConnection(fullPath, columnHeaders, delimiterCharacter, quoteCharacter), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, fullPath, methodName);
    }

    private SchemaType getTabularSchemaType(SchemaTypeHandler schemaTypeHandler, String anchorQualifiedName, String anchorDisplayName, String author, String encodingStandard, List<String> columnHeaders) {
        ComplexSchemaType tableSchemaType = schemaTypeHandler.getEmptyComplexSchemaType("248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType");
        if (columnHeaders != null) {
            tableSchemaType.setAttributeCount(columnHeaders.size());
        }
        tableSchemaType.setQualifiedName(anchorQualifiedName + ":TabularSchema");
        tableSchemaType.setDisplayName(anchorDisplayName + " Tabular Schema");
        tableSchemaType.setAuthor(author);
        tableSchemaType.setVersionNumber("1.0");
        tableSchemaType.setEncodingStandard(encodingStandard);
        return tableSchemaType;
    }

    private List<SchemaAttribute> getTabularSchemaColumns(SchemaTypeHandler schemaTypeHandler, String parentSchemaQualifiedName, List<String> columnHeaders) {
        ArrayList<SchemaAttribute> tableColumns = new ArrayList<SchemaAttribute>();
        if (columnHeaders != null) {
            int positionCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                SchemaAttribute schemaAttribute = schemaTypeHandler.getEmptySchemaAttribute();
                schemaAttribute.setQualifiedName(parentSchemaQualifiedName + ":Column:" + columnName);
                schemaAttribute.setAttributeName(columnName);
                schemaAttribute.setMinCardinality(1);
                schemaAttribute.setMaxCardinality(1);
                schemaAttribute.setElementPosition(positionCount);
                tableColumns.add(schemaAttribute);
                ++positionCount;
            }
        }
        if (tableColumns.isEmpty()) {
            return null;
        }
        return tableColumns;
    }

    private Connection getDataFileConnection(String fileName) {
        BasicFileStoreProvider provider = new BasicFileStoreProvider();
        String endpointName = "FileStore.Endpoint." + fileName;
        String connectionDescription = "FileStore connection.";
        String connectionName = fileName + " File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("FileStore connection." + fileName);
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(provider.getConnectorType());
        return connection;
    }

    private Connection getCSVFileConnection(String fileName, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) {
        CSVFileStoreProvider provider = new CSVFileStoreProvider();
        String endpointName = "CSVFileStore.Endpoint." + fileName;
        String connectionDescription = "CSVFileStore connection.";
        String connectionName = fileName + " CSV File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("CSVFileStore connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(provider.getConnectorType());
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        if (delimiterCharacter != null) {
            configurationProperties.put("delimiterCharacter", delimiterCharacter);
        }
        if (quoteCharacter != null) {
            configurationProperties.put("quoteCharacter", quoteCharacter);
        }
        if (columnHeaders != null) {
            configurationProperties.put("columnNames", columnHeaders);
        }
        if (!configurationProperties.isEmpty()) {
            connection.setConfigurationProperties(configurationProperties);
        }
        return connection;
    }

    private Connection getAvroFileConnection(String fileName) {
        AvroFileStoreProvider provider = new AvroFileStoreProvider();
        String endpointName = "AvroFileStore.Endpoint." + fileName;
        String connectionDescription = "AvroFileStore connection.";
        String connectionName = fileName + " Avro File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("AvroFileStore connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(provider.getConnectorType());
        return connection;
    }

    private Connection getDataFolderConnection(String folderName) {
        DataFolderProvider provider = new DataFolderProvider();
        String endpointName = "DataFolder.Endpoint." + folderName;
        String connectionDescription = "DataFolder connection.";
        String connectionName = folderName + " Data Folder Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("DataFolder connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, folderName));
        connection.setConnectorType(provider.getConnectorType());
        return connection;
    }

    private Endpoint getEndpoint(String endpointName, String fileName) {
        String endpointDescription = "Access information to connect to the actual asset: ";
        Endpoint endpoint = new Endpoint();
        endpoint.setType(Endpoint.getEndpointType());
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("Access information to connect to the actual asset: " + fileName);
        endpoint.setAddress(fileName);
        return endpoint;
    }

    public FileSystem getFileSystemByGUID(String userId, String fileSystemGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "fileSystemGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, fileSystemGUID, "fileSystemGUID", "SoftwareServerCapability", methodName);
        if (entity != null) {
            FileSystemConverter converter = new FileSystemConverter(entity, this.repositoryHelper, this.serviceName);
            return converter.getFileSystemBean();
        }
        return null;
    }

    public FileSystem getFileSystemByUniqueName(String userId, String uniqueName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        FileSystemBuilder builder = new FileSystemBuilder(uniqueName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, uniqueName, "uniqueName", builder.getQualifiedNameInstanceProperties(methodName), "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", methodName);
        if (entity != null) {
            FileSystemConverter converter = new FileSystemConverter(entity, this.repositoryHelper, this.serviceName);
            return converter.getFileSystemBean();
        }
        return null;
    }

    public List<String> getFileSystems(String userId, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForType(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<String> guids = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                guids.add(entity.getGUID());
            }
            if (!guids.isEmpty()) {
                return guids;
            }
        }
        return null;
    }

    public Folder getFolderByGUID(String userId, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, folderGUID, "folderGUID", "FileFolder", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return new Folder(converter.getAssetBean());
        }
        return null;
    }

    public Folder getFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        AssetBuilder builder = new AssetBuilder(pathName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, pathName, "pathName", builder.getQualifiedNameInstanceProperties(methodName), "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return new Folder(converter.getAssetBean());
        }
        return null;
    }

    public List<String> getNestedFolders(String userId, String anchorGUID, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List relatedAssets = this.repositoryHandler.isEntityATypeOf(userId, anchorGUID, "anchorGUID", "SoftwareServerCapability", methodName) ? this.assetHandler.getRelatedAssets(userId, this.supportedZones, anchorGUID, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", startingFrom, queryPageSize, this.serviceName, methodName) : this.assetHandler.getRelatedAssets(userId, this.supportedZones, anchorGUID, "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", startingFrom, queryPageSize, this.serviceName, methodName);
        return this.getRelatedAssetGUIDs(relatedAssets);
    }

    private List<String> getRelatedAssetGUIDs(List<RelatedAsset> relatedAssets) {
        if (relatedAssets != null) {
            ArrayList<String> relatedAssetGUIDs = new ArrayList<String>();
            for (RelatedAsset relatedAsset : relatedAssets) {
                Asset asset;
                if (relatedAsset == null || (asset = relatedAsset.getRelatedAsset()) == null || asset.getGUID() == null) continue;
                relatedAssetGUIDs.add(asset.getGUID());
            }
            if (!relatedAssetGUIDs.isEmpty()) {
                return relatedAssetGUIDs;
            }
        }
        return null;
    }

    public List<String> getFolderFiles(String userId, String folderGUID, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        ArrayList<RelatedAsset> files = new ArrayList<RelatedAsset>();
        boolean moreFilesToCome = true;
        int requestPointer = startingFrom;
        while (files.size() < queryPageSize && moreFilesToCome) {
            List relatedAssets = this.assetHandler.getRelatedAssets(userId, this.supportedZones, folderGUID, requestPointer, queryPageSize, this.serviceName, methodName);
            if (relatedAssets == null) {
                moreFilesToCome = false;
                continue;
            }
            if (relatedAssets.size() < maxPageSize) {
                moreFilesToCome = false;
            } else {
                requestPointer += relatedAssets.size();
            }
            for (RelatedAsset relatedAsset : relatedAssets) {
                if (relatedAsset == null || !"NestedFile".equals(relatedAsset.getTypeName()) && !"LinkedFile".equals(relatedAsset.getTypeName())) continue;
                files.add(relatedAsset);
            }
        }
        return this.getRelatedAssetGUIDs(files);
    }
}

