/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import org.odpi.openmetadata.accessservices.assetowner.properties.FileSystem;
import org.odpi.openmetadata.accessservices.assetowner.properties.Folder;
import org.odpi.openmetadata.accessservices.assetowner.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.FolderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(FileSystemRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, NewFileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        log.debug("Calling method: createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, requestBody.getUniqueName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFileSystemType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), null, "createFileSystemInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFileSystemInCatalog", auditLog);
        }
        log.debug("Returning from method: createFileSystemInCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String anchorGUID, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        log.debug("Calling method: createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, anchorGUID, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        log.debug("Returning from method: createFolderStructureInCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        log.debug("Calling method: createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        log.debug("Returning from method: createFolderStructureInCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse attachFolderToFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String methodName = "attachFolderToFileSystem";
        log.debug("Calling method: attachFolderToFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachFolderToFileSystem");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachFolderToFileSystem");
            handler.attachFolderToFileSystem(userId, fileSystemGUID, folderGUID, "attachFolderToFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachFolderToFileSystem", auditLog);
        }
        log.debug("Returning from method: attachFolderToFileSystem with response: " + response.toString());
        return response;
    }

    public VoidResponse detachFolderFromFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String methodName = "detachFolderFromFileSystem";
        log.debug("Calling method: detachFolderFromFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachFolderFromFileSystem");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachFolderFromFileSystem");
            handler.detachFolderFromFileSystem(userId, fileSystemGUID, folderGUID, "detachFolderFromFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachFolderFromFileSystem", auditLog);
        }
        log.debug("Returning from method: detachFolderFromFileSystem with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addDataFileAssetToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addDataFileAssetToCatalog";
        log.debug("Calling method: addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFileAssetToCatalog(userId, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        log.debug("Returning from method: addDataFileAssetToCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderAssetToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addDataFileAssetToCatalog";
        log.debug("Calling method: addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFolderAssetToCatalog(userId, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        log.debug("Returning from method: addDataFileAssetToCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse attachDataFileAssetToFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "attachDataFileAssetToFolder";
        log.debug("Calling method: attachDataFileAssetToFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachDataFileAssetToFolder");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachDataFileAssetToFolder");
            handler.attachDataFileAssetToFolder(userId, folderGUID, fileGUID, "attachDataFileAssetToFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachDataFileAssetToFolder", auditLog);
        }
        log.debug("Returning from method: attachDataFileAssetToFolder with response: " + response.toString());
        return response;
    }

    public VoidResponse detachDataFileAssetFromFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "detachDataFileAssetFromFolder";
        log.debug("Calling method: detachDataFileAssetFromFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataFileAssetFromFolder");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachDataFileAssetFromFolder");
            handler.detachDataFileAssetFromFolder(userId, folderGUID, fileGUID, "detachDataFileAssetFromFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachDataFileAssetFromFolder", auditLog);
        }
        log.debug("Returning from method: detachDataFileAssetFromFolder with response: " + response.toString());
        return response;
    }

    public VoidResponse moveDataFileInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        log.debug("Calling method: moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFileInCatalog(userId, folderGUID, fileGUID, "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        log.debug("Returning from method: moveDataFileInCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse moveDataFolderInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        log.debug("Calling method: moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFolderInCatalog(userId, folderGUID, fileGUID, "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        log.debug("Returning from method: moveDataFileInCatalog with response: " + response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByGUID(String serverName, String userId, String fileSystemGUID) {
        String methodName = "getFileSystemByGUID";
        log.debug("Calling method: getFileSystemByGUID");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByGUID");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystemByGUID");
            response.setFileSystem(new FileSystem(handler.getSoftwareServerCapabilityByGUID(userId, fileSystemGUID, "getFileSystemByGUID")));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByGUID", auditLog);
        }
        log.debug("Returning from method: getFileSystemByGUID with response: " + response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByUniqueName(String serverName, String userId, String uniqueName) {
        String methodName = "getFileSystemByUniqueName";
        log.debug("Calling method: getFileSystemByUniqueName");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByUniqueName");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystemByUniqueName");
            response.setFileSystem(new FileSystem(handler.getSoftwareServerCapabilityByUniqueName(userId, uniqueName, "getFileSystemByUniqueName")));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByUniqueName", auditLog);
        }
        log.debug("Returning from method: getFileSystemByUniqueName with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getFileSystems(String serverName, String userId, int startingFrom, int maxPageSize) {
        String methodName = "getFileSystems";
        log.debug("Calling method: getFileSystems");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystems");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystems");
            response.setGUIDs(handler.getSoftwareServerCapabilityGUIDsByClassification(userId, "FileSystem", startingFrom, maxPageSize, "getFileSystems"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystems", auditLog);
        }
        log.debug("Returning from method: getFileSystems with response: " + response.toString());
        return response;
    }

    public FolderResponse getFolderByGUID(String serverName, String userId, String folderGUID) {
        String methodName = "getFolderByGUID";
        log.debug("Calling method: getFolderByGUID");
        FolderResponse response = new FolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByGUID");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByGUID");
            response.setFolder(new Folder(handler.getFolderByGUID(userId, folderGUID, "getFolderByGUID")));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByGUID", auditLog);
        }
        log.debug("Returning from method: getFolderByGUID with response: " + response.toString());
        return response;
    }

    public FolderResponse getFolderByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getFolderByPathName";
        log.debug("Calling method: getFolderByPathName");
        FolderResponse response = new FolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByPathName");
                response.setFolder(new Folder(handler.getFolderByPathName(userId, requestBody.getFullPath(), "getFolderByPathName")));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByPathName", auditLog);
        }
        log.debug("Returning from method: getFolderByPathName with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getNestedFolders(String serverName, String userId, String anchorGUID, int startingFrom, int maxPageSize) {
        String methodName = "getNestedFolders";
        log.debug("Calling method: getNestedFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedFolders");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getNestedFolders");
            response.setGUIDs(handler.getNestedFolders(userId, anchorGUID, startingFrom, maxPageSize, "getNestedFolders"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getNestedFolders", auditLog);
        }
        log.debug("Returning from method: getNestedFolders with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getFolderFiles(String serverName, String userId, String folderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getFolderFiles";
        log.debug("Calling method: getFolderFiles");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderFiles");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderFiles");
            response.setGUIDs(handler.getFolderFiles(userId, folderGUID, startingFrom, maxPageSize, "getFolderFiles"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderFiles", auditLog);
        }
        log.debug("Returning from method: getFolderFiles with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addAvroFileToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addAvroFileToCatalog";
        log.debug("Calling method: addAvroFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAvroFileToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addAvroFileToCatalog");
                response.setGUIDs(handler.addAvroFileToCatalog(userId, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), "addAvroFileToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addAvroFileToCatalog", auditLog);
        }
        log.debug("Returning from method: addAvroFileToCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addCSVFileToCatalog(String serverName, String userId, NewCSVFileAssetRequestBody requestBody) {
        String methodName = "addCSVFileToCatalog";
        log.debug("Calling method: addCSVFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCSVFileToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addCSVFileToCatalog");
                response.setGUIDs(handler.addCSVFileToCatalog(userId, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), requestBody.getColumnHeaders(), requestBody.getDelimiterCharacter(), requestBody.getQuoteCharacter(), "addCSVFileToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addCSVFileToCatalog", auditLog);
        }
        log.debug("Returning from method: addCSVFileToCatalog with response: " + response.toString());
        return response;
    }
}

