/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ValidValuesHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValuesResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValueSet(String serverName, String userId, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueSet");
                response.setGUID(handler.createValidValueSet(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueSet", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createValidValueDefinition(String serverName, String userId, String setGUID, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueDefinition");
                response.setGUID(handler.createValidValueDefinition(userId, setGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueDefinition", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, ValidValuesRequestBody requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "updateValidValue");
                handler.updateValidValue(userId, validValueGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "updateValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteValidValue(String serverName, String userId, String validValueGUID, String qualifiedName) {
        String methodName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteValidValue");
            if (qualifiedName != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "deleteValidValue");
                handler.deleteValidValue(userId, validValueGUID, qualifiedName, "deleteValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachValidValueToSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "attachValidValueToSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachValidValueToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachValidValueToSet");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "attachValidValueToSet");
            handler.attachValidValueToSet(userId, setGUID, validValueGUID, "attachValidValueToSet");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachValidValueToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachValidValueFromSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "detachValidValueFromSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachValidValueFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachValidValueFromSet");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "detachValidValueFromSet");
            handler.detachValidValueFromSet(userId, setGUID, validValueGUID, "detachValidValueFromSet");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachValidValueFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String validValueGUID) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByGUID");
            response.setValidValue(handler.getValidValueByGUID(userId, validValueGUID, "getValidValueByGUID"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueByName(String serverName, String userId, String validValueName) {
        String methodName = "getValidValueByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByName");
            if (validValueName != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByName");
                response.setValidValues(handler.getValidValueByName(userId, validValueName, "getValidValueByName"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (searchString != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValues");
                response.setValidValues(handler.findValidValues(userId, searchString, startFrom, pageSize, "findValidValues"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String methodName = "getValidValueSetMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetMembers");
            response.setValidValues(handler.getValidValueSetMembers(userId, validValueSetGUID, startFrom, pageSize, "getValidValueSetMembers"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getSetsForValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getSetsForValidValue");
            response.setValidValues(handler.getSetsForValidValue(userId, validValueGUID, startFrom, pageSize, "getSetsForValidValue"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

