/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import org.odpi.openmetadata.accessservices.assetowner.converters.AssetOwnerOMASConverter;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.FileSystemProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileSystemConverter<B>
extends AssetOwnerOMASConverter<B> {
    public FileSystemConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof FileSystemElement) {
                FileSystemElement bean = (FileSystemElement)returnBean;
                FileSystemProperties fileSystemProperties = new FileSystemProperties();
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    fileSystemProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    fileSystemProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    fileSystemProperties.setDisplayName(this.removeName(instanceProperties));
                    fileSystemProperties.setDescription(this.removeDescription(instanceProperties));
                    fileSystemProperties.setTypeDescription(this.removeCapabilityType(instanceProperties));
                    fileSystemProperties.setVersion(this.removeVersion(instanceProperties));
                    fileSystemProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    fileSystemProperties.setSource(this.removeSource(instanceProperties));
                    fileSystemProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    fileSystemProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("FileSystem", entity);
                    fileSystemProperties.setFormat(this.getFormat(instanceProperties));
                    fileSystemProperties.setEncryption(this.getEncryption(instanceProperties));
                    bean.setFileSystemProperties(fileSystemProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

