/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FileElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FolderElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.FolderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class FileSystemRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(FileSystemRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, NewFileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, null, null, requestBody.getUniqueName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFileSystemType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), null, "createFileSystemInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFileSystemInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String anchorGUID, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, null, null, anchorGUID, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, null, null, null, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachFolderToFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String methodName = "attachFolderToFileSystem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachFolderToFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachFolderToFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachFolderToFileSystem");
            handler.attachFolderToFileSystem(userId, null, null, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", "attachFolderToFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachFolderToFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachFolderFromFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String methodName = "detachFolderFromFileSystem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachFolderFromFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachFolderFromFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachFolderFromFileSystem");
            handler.detachFolderFromFileSystem(userId, null, null, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", "detachFolderFromFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachFolderFromFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFileAssetToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addDataFileAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFileAssetToCatalog(userId, null, null, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderAssetToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addDataFileAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFolderAssetToCatalog(userId, null, null, requestBody.getFullPath(), requestBody.getDisplayName(), requestBody.getDescription(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachDataFileAssetToFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        String methodName = "attachDataFileAssetToFolder";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachDataFileAssetToFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachDataFileAssetToFolder");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachDataFileAssetToFolder");
            handler.attachDataFileAssetToFolder(userId, null, null, folderGUID, "folderGUID", fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachDataFileAssetToFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachDataFileAssetFromFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        String methodName = "detachDataFileAssetFromFolder";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachDataFileAssetFromFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataFileAssetFromFolder");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachDataFileAssetFromFolder");
            handler.detachDataFileAssetFromFolder(userId, null, null, folderGUID, "folderGUID", fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachDataFileAssetFromFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFileInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        String methodName = "moveDataFileInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFileInCatalog(userId, null, null, folderGUID, "folderGUID", fileGUID, "fileGUID", "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFolderInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        String methodName = "moveDataFileInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFolderInCatalog(userId, null, null, folderGUID, "folderGUID", fileGUID, "fileGUID", "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByGUID(String serverName, String userId, String fileSystemGUID) {
        String guidParameterName = "fileSystemGUID";
        String methodName = "getFileSystemByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByGUID");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByGUID");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByGUID");
            FileSystemElement fileSystemElement = (FileSystemElement)handler.getFileSystemByGUID(userId, fileSystemGUID, "fileSystemGUID", "getFileSystemByGUID");
            response.setFileSystem(fileSystemElement);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByUniqueName(String serverName, String userId, String uniqueName) {
        String uniqueNameParameterName = "uniqueName";
        String methodName = "getFileSystemByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByUniqueName");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByUniqueName");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByUniqueName");
            response.setFileSystem(new FileSystemElement((FileSystemElement)handler.getFileSystemByUniqueName(userId, uniqueName, "uniqueName", "getFileSystemByUniqueName")));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getFileSystems(String serverName, String userId, int startingFrom, int maxPageSize) {
        String methodName = "getFileSystems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystems");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystems");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystems");
            response.setGUIDs(handler.getFileSystems(userId, startingFrom, maxPageSize, "getFileSystems"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystems", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FolderResponse getFolderByGUID(String serverName, String userId, String folderGUID) {
        String methodName = "getFolderByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByGUID");
        FolderResponse response = new FolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByGUID");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByGUID");
            response.setFolder(new FolderElement((FolderElement)handler.getFolderByGUID(userId, folderGUID, "getFolderByGUID")));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FolderResponse getFolderByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getFolderByPathName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByPathName");
        FolderResponse response = new FolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByPathName");
                response.setFolder(new FolderElement((FolderElement)handler.getFolderByPathName(userId, requestBody.getFullPath(), "getFolderByPathName")));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getNestedFolders(String serverName, String userId, String parentGUID, int startingFrom, int maxPageSize) {
        String parentGUIDParameterName = "parentGUID";
        String methodName = "getNestedFolders";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedFolders");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getNestedFolders");
            response.setGUIDs(handler.getNestedFolders(userId, parentGUID, "parentGUID", startingFrom, maxPageSize, "getNestedFolders"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getNestedFolders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getFolderFiles(String serverName, String userId, String folderGUID, int startingFrom, int maxPageSize) {
        String folderGUIDParameterName = "folderGUID";
        String methodName = "getFolderFiles";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderFiles");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderFiles");
            FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderFiles");
            response.setGUIDs(handler.getFolderFiles(userId, folderGUID, "folderGUID", startingFrom, maxPageSize, "getFolderFiles"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderFiles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addAvroFileToCatalog(String serverName, String userId, NewFileAssetRequestBody requestBody) {
        String methodName = "addAvroFileToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAvroFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAvroFileToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addAvroFileToCatalog");
                response.setGUIDs(handler.addAvroFileToCatalog(userId, null, null, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), "addAvroFileToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addAvroFileToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addCSVFileToCatalog(String serverName, String userId, NewCSVFileAssetRequestBody requestBody) {
        String methodName = "addCSVFileToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCSVFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCSVFileToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FolderElement, FileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addCSVFileToCatalog");
                response.setGUIDs(handler.addCSVFileToCatalog(userId, null, null, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFullPath(), requestBody.getColumnHeaders(), requestBody.getDelimiterCharacter(), requestBody.getQuoteCharacter(), "addCSVFileToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addCSVFileToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

