/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ValidValuesResponse;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValueSet(String serverName, String userId, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueSet");
                response.setGUID(handler.createValidValueSet(userId, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueSet", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createValidValueDefinition(String serverName, String userId, String setGUID, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueDefinition");
                response.setGUID(handler.createValidValueDefinition(userId, null, null, setGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueDefinition", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, ValidValuesRequestBody requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "updateValidValue");
                handler.updateValidValue(userId, null, null, validValueGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "updateValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteValidValue(String serverName, String userId, String validValueGUID, String qualifiedName) {
        String methodName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteValidValue");
            if (qualifiedName != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "deleteValidValue");
                handler.deleteValidValue(userId, null, null, validValueGUID, qualifiedName, "deleteValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachValidValueToSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "attachValidValueToSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachValidValueToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachValidValueToSet");
            ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "attachValidValueToSet");
            handler.attachValidValueToSet(userId, null, null, setGUID, validValueGUID, "attachValidValueToSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "attachValidValueToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachValidValueFromSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "detachValidValueFromSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachValidValueFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachValidValueFromSet");
            ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "detachValidValueFromSet");
            handler.detachValidValueFromSet(userId, null, null, setGUID, validValueGUID, "detachValidValueFromSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "detachValidValueFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String validValueGUID) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByGUID");
            response.setElement((ValidValueElement)handler.getValidValueByGUID(userId, validValueGUID, "getValidValueByGUID"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueByName(String serverName, String userId, String validValueName, int startFrom, int pageSize) {
        String nameParameterName = "validValueName";
        String methodName = "getValidValueByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByName");
            if (validValueName != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByName");
                response.setElementList(handler.getValidValueByName(userId, validValueName, "validValueName", startFrom, pageSize, "getValidValueByName"));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String searchStringParameterName = "searchString";
        String methodName = "findValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (searchString != null) {
                ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValues");
                response.setElementList(handler.findValidValues(userId, searchString, "searchString", startFrom, pageSize, "findValidValues"));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueSetGUID";
        String methodName = "getValidValueSetMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetMembers");
            response.setElementList(handler.getValidValueSetMembers(userId, validValueSetGUID, "validValueSetGUID", startFrom, pageSize, "getValidValueSetMembers"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getSetsForValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            ValidValuesHandler<ValidValueElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getSetsForValidValue");
            response.setElementList(handler.getSetsForValidValue(userId, validValueGUID, "validValueGUID", startFrom, pageSize, "getSetsForValidValue"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

