/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ConnectionRESTServices {
    private static AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ConnectionRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createConnection(String serverName, String userId, ConnectionProperties requestBody) {
        String methodName = "createConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnection");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnection");
                response.setGUID(handler.createConnection(userId, null, null, null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, null, null, "createConnection"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectionFromTemplate(String serverName, String userId, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectionFromTemplate");
            if (templateProperties != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnectionFromTemplate");
                response.setGUID(handler.createConnectionFromTemplate(userId, null, null, templateGUID, "templateGUID", templateProperties.getQualifiedName(), "qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), "createConnectionFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createConnectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnection(String serverName, String userId, String connectionGUID, boolean isMergeUpdate, ConnectionProperties requestBody) {
        String methodName = "updateConnection";
        String guidParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnection");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "updateConnection");
                handler.updateConnection(userId, null, null, connectionGUID, "connectionGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, "updateConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, NullRequestBody requestBody) {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupConnectorType");
            if (requestBody != null) {
                handler.addConnectionConnectorType(userId, null, null, connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, NullRequestBody requestBody) {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearConnectorType");
            if (requestBody != null) {
                handler.removeConnectionConnectorType(userId, null, null, connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEndpoint");
            if (requestBody != null) {
                handler.addConnectionEndpoint(userId, null, null, connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", "setupEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEndpoint");
            if (requestBody != null) {
                handler.removeConnectionEndpoint(userId, null, null, connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", "clearEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionRequestBody requestBody) {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEmbeddedConnection");
            if (requestBody != null) {
                handler.addEmbeddedConnection(userId, null, null, connectionGUID, "connectionGUID", requestBody.getPosition(), requestBody.getDisplayName(), requestBody.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, NullRequestBody requestBody) {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEmbeddedConnection");
            if (requestBody != null) {
                handler.removeEmbeddedConnection(userId, null, null, connectionGUID, "connectionGUID", embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, StringRequestBody requestBody) {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupAssetConnection");
            if (requestBody != null) {
                handler.addConnectionToAsset(userId, null, null, connectionGUID, "connectionGUID", assetGUID, "assetGUID", requestBody.getString(), "setupAssetConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, NullRequestBody requestBody) {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearAssetConnection");
            if (requestBody != null) {
                handler.removeConnectionToAsset(userId, null, null, connectionGUID, "connectionGUID", assetGUID, "assetGUID", "clearAssetConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnection(String serverName, String userId, String connectionGUID, NullRequestBody requestBody) {
        String methodName = "removeConnection";
        String guidParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "removeConnection");
            handler.removeConnection(userId, null, null, connectionGUID, "connectionGUID", "removeConnection");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse findConnections(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnections";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnections");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "findConnections");
                List connections = handler.findConnections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, "findConnections");
                response.setElementList(connections);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectionsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsByName");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsByName");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionsByName");
                List connections = handler.getConnectionsByName(userId, requestBody.getName(), "name", startFrom, pageSize, "getConnectionsByName");
                response.setElementList(connections);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getConnectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String connectionGUID) {
        String methodName = "getConnectionByGUID";
        String connectionGUIDParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            ConnectionElement connection = (ConnectionElement)handler.getConnectionByGUID(userId, connectionGUID, "connectionGUID", "getConnectionByGUID");
            response.setElement(connection);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpoint(String serverName, String userId, EndpointProperties endpointProperties) {
        String methodName = "createEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            if (endpointProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpoint");
                String endpointGUID = handler.createEndpoint(userId, null, null, null, endpointProperties.getQualifiedName(), endpointProperties.getTechnicalName(), endpointProperties.getTechnicalDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), "createEndpoint");
                handler.maintainSupplementaryProperties(userId, endpointGUID, endpointProperties.getQualifiedName(), endpointProperties.getDisplayName(), endpointProperties.getSummary(), endpointProperties.getDescription(), endpointProperties.getAbbreviation(), endpointProperties.getUsage(), false, "createEndpoint");
                response.setGUID(endpointGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String networkAddress, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createEndpointFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            if (templateProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpointFromTemplate");
                response.setGUID(handler.createEndpointFromTemplate(userId, null, null, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), networkAddress, "createEndpointFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, EndpointProperties endpointProperties) {
        String methodName = "updateEndpoint";
        String guidParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            if (endpointProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "updateEndpoint");
                handler.updateEndpoint(userId, null, null, endpointGUID, "endpointGUID", endpointProperties.getQualifiedName(), endpointProperties.getTechnicalName(), endpointProperties.getTechnicalDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), isMergeUpdate, "updateEndpoint");
                handler.maintainSupplementaryProperties(userId, endpointGUID, endpointProperties.getQualifiedName(), endpointProperties.getDisplayName(), endpointProperties.getSummary(), endpointProperties.getDescription(), endpointProperties.getAbbreviation(), endpointProperties.getUsage(), isMergeUpdate, "updateEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "removeEndpoint";
        String guidParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "removeEndpoint");
            handler.removeEndpoint(userId, null, null, endpointGUID, "endpointGUID", "removeEndpoint");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "findEndpoints");
                List endpoints = handler.findEndpoints(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, "findEndpoints");
                response.setElementList(endpoints);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEndpointsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByName");
                List endpoints = handler.getEndpointsByName(userId, requestBody.getName(), "name", startFrom, pageSize, "getEndpointsByName");
                response.setElementList(endpoints);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String endpointGUID) {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointByGUID");
            EndpointElement endpoint = (EndpointElement)handler.getEndpointByGUID(userId, endpointGUID, "endpointGUID", "getEndpointByGUID");
            response.setElement(endpoint);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse findConnectorTypes(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnectorTypes";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnectorTypes");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnectorTypes");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "findConnectorTypes");
                List connectorTypes = handler.findConnectorTypes(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, "findConnectorTypes");
                response.setElementList(connectorTypes);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findConnectorTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectorTypesByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesByName");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesByName");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypesByName");
                List connectorTypes = handler.getConnectorTypesByName(userId, requestBody.getName(), "name", startFrom, pageSize, "getConnectorTypesByName");
                response.setElementList(connectorTypes);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getConnectorTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorTypeByGUID(String serverName, String userId, String connectorTypeGUID) {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypeByGUID");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeElement connectorType = (ConnectorTypeElement)handler.getConnectorTypeByGUID(userId, connectorTypeGUID, "connectorTypeGUID", "getConnectorTypeByGUID");
            response.setElement(connectorType);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getConnectorTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

