/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetowner.converters.AssetOwnerOMASConverter;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FileElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.FileProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFileConverter<B>
extends AssetOwnerOMASConverter<B> {
    public DataFileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof FileElement) {
                FileElement bean = (FileElement)returnBean;
                FileProperties fileProperties = new FileProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    fileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    fileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    fileProperties.setDisplayName(this.removeName(instanceProperties));
                    fileProperties.setDescription(this.removeDescription(instanceProperties));
                    fileProperties.setPathName(this.removePathName(instanceProperties));
                    fileProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    fileProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    fileProperties.setOwner(this.removeOwner(instanceProperties));
                    fileProperties.setOwnerType(this.removeOwnerTypeFromProperties(instanceProperties));
                    fileProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
                    fileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    fileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                    fileProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                    fileProperties.setOwner(this.getOwner(instanceProperties));
                    fileProperties.setOwnerType(this.getOwnerTypeFromProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                    fileProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
                    fileProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
                    fileProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
                    instanceProperties = super.getClassificationProperties("DataStoreEncoding", entity);
                    fileProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    fileProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    fileProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    fileProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setFileProperties(fileProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

