/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.properties.OwnerType;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

abstract class AssetOwnerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    AssetOwnerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    OwnerType removeOwnerTypeFromProperties(InstanceProperties properties) {
        OwnerType ownerType = this.getOwnerTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerType;
    }

    OwnerType getOwnerTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        OwnerType ownerType = OwnerType.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    ownerType = OwnerType.USER_ID;
                    break;
                }
                case 1: {
                    ownerType = OwnerType.PROFILE_ID;
                    break;
                }
                case 99: {
                    ownerType = OwnerType.OTHER;
                }
            }
        }
        return ownerType;
    }
}

