/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.ODFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFieldConverter<B>
extends ODFConverter<B> {
    public DataFieldConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DataField) {
                DataField bean = (DataField)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                InstanceProperties instanceProperties = null;
                if (primaryEntity != null) {
                    instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                }
                bean.setDataFieldName(this.removeDataFieldName(instanceProperties));
                bean.setDataFieldType(this.removeDataFieldType(instanceProperties));
                bean.setDataFieldDescription(this.removeDataFieldDescription(instanceProperties));
                bean.setDataFieldAliases(this.removeDataFieldAliases(instanceProperties));
                bean.setDataFieldSortOrder(this.removeSortOrder(instanceProperties));
                bean.setDefaultValue(this.removeDefaultValue(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                if (relationships != null && !relationships.isEmpty()) {
                    int nestedDataFields = 0;
                    for (Relationship relationship : relationships) {
                        EntityProxy endOne;
                        if (relationship == null || relationship.getType() == null || relationship.getType().getTypeDefName() == null) continue;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveredDataField")) {
                            bean.setDataFieldPosition(this.repositoryHelper.getIntProperty(this.serviceName, "dataFieldPosition", relationship.getProperties(), methodName));
                            continue;
                        }
                        if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveredDataField") || (endOne = relationship.getEntityOneProxy()) == null || endOne.getGUID() == null || !endOne.getGUID().equals(primaryEntity.getGUID())) continue;
                        ++nestedDataFields;
                    }
                    bean.setNestedDataFields(nestedDataFields);
                }
                bean.setTypeName(bean.getElementHeader().getType().getTypeName());
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

