/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.assetowner.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SimpleSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.OriginRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.OwnerRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaAttributesRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class AssetOwnerRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetOwnerRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public NameListResponse getTypesOfAsset(String serverName, String userId) {
        String methodName = "getTypesOfAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAsset");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getTypesOfAsset");
            response.setNames(handler.getTypesOfAssetList());
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypesOfAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getTypesOfAssetDescriptions(String serverName, String userId) {
        String methodName = "getTypesOfAssetDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAssetDescription");
        StringMapResponse response = new StringMapResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAssetDescription");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getTypesOfAssetDescription");
            response.setStringMap(handler.getTypesOfAssetDescriptions());
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypesOfAssetDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAssetToCatalog(String serverName, String userId, String typeName, AssetProperties requestBody) {
        String methodName = "addAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetToCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalog");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalog");
                String assetTypeName = "Asset";
                if (typeName != null) {
                    assetTypeName = typeName;
                }
                String assetTypeGUID = this.invalidParameterHandler.validateTypeName(assetTypeName, "Asset", instanceHandler.getServiceName(), "addAssetToCatalog", instanceHandler.getRepositoryHelper(userId, serverName, "addAssetToCatalog"));
                int ownerTypeOrdinal = 0;
                if (requestBody.getOwnerType() != null) {
                    ownerTypeOrdinal = requestBody.getOwnerType().getOpenTypeOrdinal();
                }
                response.setGUID(handler.createAssetInRepository(userId, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getZoneMembership(), requestBody.getOwner(), ownerTypeOrdinal, requestBody.getOriginOrganizationGUID(), requestBody.getOriginBusinessCapabilityGUID(), requestBody.getOtherOriginValues(), requestBody.getAdditionalProperties(), assetTypeGUID, assetTypeName, requestBody.getExtendedProperties(), null, null, InstanceStatus.ACTIVE, new Date(), "addAssetToCatalog"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalog", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAssetToCatalogUsingTemplate(String serverName, String userId, String templateGUID, TemplateProperties requestBody) {
        String methodName = "addAssetToCatalogUsingTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetToCatalogUsingTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalogUsingTemplate");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalogUsingTemplate");
                response.setGUID(handler.addAssetFromTemplate(userId, null, null, templateGUID, "templateGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getNetworkAddress(), false, false, new Date(), "addAssetToCatalogUsingTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalogUsingTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addAssetToCatalogUsingTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCombinedSchemaToAsset(String serverName, String userId, String assetGUID, CombinedSchemaRequestBody requestBody) {
        String methodName = "addCombinedSchemaToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCombinedSchemaToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getSchemaType() != null) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "addCombinedSchemaToAsset");
                    response.setGUID(this.addAssociatedSchemaType(userId, serverName, assetGUID, requestBody.getSchemaType(), "addCombinedSchemaToAsset"));
                    if (requestBody.getSchemaAttributes() != null) {
                        for (SchemaAttributeProperties schemaAttributeProperties : requestBody.getSchemaAttributes()) {
                            this.addAssociatedSchemaAttribute(userId, serverName, assetGUID, response.getGUID(), schemaAttributeProperties, "addCombinedSchemaToAsset");
                        }
                    }
                } else {
                    String parameterName = "requestBody.getSchemaType()";
                    restExceptionHandler.handleMissingValue("requestBody.getSchemaType()", "addCombinedSchemaToAsset");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCombinedSchemaToAsset", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCombinedSchemaToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addSchemaTypeToAsset(String serverName, String userId, String assetGUID, SchemaTypeProperties requestBody) {
        String methodName = "addSchemaTypeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaTypeToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaTypeToAsset");
            if (requestBody != null) {
                response.setGUID(this.addAssociatedSchemaType(userId, serverName, assetGUID, requestBody, "addSchemaTypeToAsset"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaTypeToAsset", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSchemaTypeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    @Deprecated
    public GUIDResponse addSchemaTypeToAsset(String serverName, String userId, String assetGUID, SchemaTypeRequestBody requestBody) {
        String methodName = "addSchemaTypeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaTypeToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaTypeToAsset");
            if (requestBody != null) {
                if (requestBody.getSchemaTypeProperties() != null) {
                    response.setGUID(this.addAssociatedSchemaType(userId, serverName, assetGUID, requestBody.getSchemaTypeProperties(), "addSchemaTypeToAsset"));
                } else {
                    String parameterName = "requestBody.getSchemaTypeProperties()";
                    restExceptionHandler.handleMissingValue("requestBody.getSchemaTypeProperties()", "addSchemaTypeToAsset");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaTypeToAsset", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSchemaTypeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String addAssociatedSchemaType(String userId, String serverName, String assetGUID, SchemaTypeProperties schemaType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID;
        String assetGUIDParameterName = "assetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, methodName);
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType, handler.getRepositoryHelper(), handler.getServiceName(), serverName, methodName);
        if (assetGUID != null) {
            schemaTypeBuilder.setAnchors(userId, assetGUID, methodName);
        }
        if ((schemaTypeGUID = handler.addSchemaType(userId, null, null, schemaTypeBuilder, null, null, false, false, new Date(), methodName)) != null) {
            handler.linkElementToElement(userId, null, null, assetGUID, "assetGUID", "Asset", schemaTypeGUID, "schemaTypeGUID", "SchemaType", false, false, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", (InstanceProperties)null, null, null, new Date(), methodName);
        }
        return schemaTypeGUID;
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaTypeProperties schemaType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String typeName = "SchemaType";
        if (schemaType.getTypeName() != null) {
            typeName = schemaType.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", serviceName, methodName, repositoryHelper);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.getIsDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), typeGUID, typeName, schemaType.getExtendedProperties(), repositoryHelper, serviceName, serverName);
        if (schemaType instanceof LiteralSchemaTypeProperties) {
            LiteralSchemaTypeProperties literalSchemaTypeProperties = (LiteralSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(literalSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setFixedValue(literalSchemaTypeProperties.getFixedValue());
        } else if (schemaType instanceof SimpleSchemaTypeProperties) {
            SimpleSchemaTypeProperties simpleSchemaTypeProperties = (SimpleSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(simpleSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setDefaultValue(simpleSchemaTypeProperties.getDefaultValue());
            if (schemaType instanceof EnumSchemaTypeProperties) {
                EnumSchemaTypeProperties enumSchemaTypeProperties = (EnumSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setValidValuesSetGUID(enumSchemaTypeProperties.getValidValueSetGUID());
            } else if (schemaType instanceof ExternalSchemaTypeProperties) {
                ExternalSchemaTypeProperties externalSchemaTypeProperties = (ExternalSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setExternalSchemaTypeGUID(externalSchemaTypeProperties.getExternalSchemaTypeGUID());
            }
        } else if (schemaType instanceof SchemaTypeChoiceProperties) {
            SchemaTypeChoiceProperties schemaTypeChoiceProperties = (SchemaTypeChoiceProperties)schemaType;
            if (schemaTypeChoiceProperties.getSchemaOptions() != null) {
                ArrayList<SchemaTypeBuilder> schemaOptionBuilders = new ArrayList<SchemaTypeBuilder>();
                for (SchemaTypeProperties schemaOption : schemaTypeChoiceProperties.getSchemaOptions()) {
                    if (schemaOption == null) continue;
                    schemaOptionBuilders.add(this.getSchemaTypeBuilder(schemaOption, repositoryHelper, serviceName, serverName, methodName));
                }
                if (!schemaOptionBuilders.isEmpty()) {
                    schemaTypeBuilder.setSchemaOptions(schemaOptionBuilders);
                }
            }
        } else if (schemaType instanceof MapSchemaTypeProperties) {
            MapSchemaTypeProperties mapSchemaTypeProperties = (MapSchemaTypeProperties)schemaType;
            SchemaTypeBuilder mapFromBuilder = null;
            SchemaTypeBuilder mapToBuilder = null;
            if (mapSchemaTypeProperties.getMapFromElement() != null) {
                mapFromBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapFromElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            if (mapSchemaTypeProperties.getMapToElement() != null) {
                mapToBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapToElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            schemaTypeBuilder.setMapTypes(mapFromBuilder, mapToBuilder);
        }
        return schemaTypeBuilder;
    }

    private String addAssociatedSchemaAttribute(String userId, String serverName, String assetGUID, String schemaTypeGUID, SchemaAttributeProperties schemaAttribute, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, methodName);
        String schemaAttributeGUID = null;
        if (schemaAttribute != null) {
            int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
            if (schemaAttribute.getSortOrder() != null) {
                sortOrder = schemaAttribute.getSortOrder().getOpenTypeOrdinal();
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(schemaAttribute.getQualifiedName(), schemaAttribute.getDisplayName(), schemaAttribute.getDescription(), schemaAttribute.getElementPosition(), schemaAttribute.getMinCardinality(), schemaAttribute.getMaxCardinality(), schemaAttribute.getIsDeprecated(), schemaAttribute.getDefaultValueOverride(), schemaAttribute.getAllowsDuplicateValues(), schemaAttribute.getOrderedValues(), sortOrder, schemaAttribute.getMinimumLength(), schemaAttribute.getLength(), schemaAttribute.getPrecision(), schemaAttribute.getIsNullable(), schemaAttribute.getNativeJavaClass(), schemaAttribute.getAliases(), schemaAttribute.getAdditionalProperties(), null, schemaAttribute.getTypeName(), schemaAttribute.getExtendedProperties(), handler.getRepositoryHelper(), handler.getServiceName(), serverName);
            if (assetGUID != null) {
                schemaAttributeBuilder.setAnchors(userId, assetGUID, methodName);
            }
            if (schemaAttribute.getAttributeType() != null) {
                SchemaTypeProperties schemaTypeProperties = schemaAttribute.getAttributeType();
                SchemaTypeBuilder attributeSchemaTypeBuilder = new SchemaTypeBuilder(schemaTypeProperties.getQualifiedName(), schemaTypeProperties.getDisplayName(), schemaTypeProperties.getDescription(), schemaTypeProperties.getVersionNumber(), schemaTypeProperties.getIsDeprecated(), schemaTypeProperties.getAuthor(), schemaTypeProperties.getUsage(), schemaTypeProperties.getEncodingStandard(), schemaTypeProperties.getNamespace(), schemaTypeProperties.getAdditionalProperties(), null, schemaTypeProperties.getTypeName(), schemaTypeProperties.getExtendedProperties(), handler.getRepositoryHelper(), handler.getServiceName(), serverName);
                attributeSchemaTypeBuilder.setAnchors(userId, assetGUID, methodName);
                schemaAttributeBuilder.setSchemaType(userId, attributeSchemaTypeBuilder, methodName);
                String schemaTypeGUIDParameterName = "schemaTypeGUID";
                String qualifiedNameParameterName = "schemaAttribute.getQualifiedName()";
                schemaAttributeGUID = handler.createNestedSchemaAttribute(userId, null, null, schemaTypeGUID, "schemaTypeGUID", "SchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", schemaAttribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", schemaAttributeBuilder, null, null, false, false, new Date(), methodName);
            } else {
                String parameterName = "attribute schema type";
                restExceptionHandler.handleMissingValue("attribute schema type", methodName);
            }
        }
        return schemaAttributeGUID;
    }

    public VoidResponse attachSchemaTypeToAsset(String serverName, String userId, String assetGUID, String schemaTypeGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String methodName = "attachSchemaTypeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachSchemaTypeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachSchemaTypeToAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "attachSchemaTypeToAsset");
            handler.attachSchemaTypeToAsset(userId, null, null, assetGUID, "assetGUID", schemaTypeGUID, "schemaTypeGUID", null, null, false, false, new Date(), "attachSchemaTypeToAsset");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachSchemaTypeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse detachSchemaTypeFromAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "detachSchemaTypeFromAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachSchemaTypeFromAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachSchemaTypeFromAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "detachSchemaTypeFromAsset");
            response.setGUID(handler.detachSchemaTypeFromAsset(userId, null, null, assetGUID, "assetGUID", false, false, new Date(), "detachSchemaTypeFromAsset"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachSchemaTypeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAssetSchemaType(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "deleteAssetSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAssetSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAssetSchemaType");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAssetSchemaType");
            handler.removeAssociatedSchemaType(userId, null, null, assetGUID, "assetGUID", false, false, new Date(), "deleteAssetSchemaType");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteAssetSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSchemaAttributes(String serverName, String userId, String assetGUID, String parentGUID, SchemaAttributesRequestBody requestBody) {
        String methodName = "addSchemaAttributes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttributes");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getSchemaAttributeProperties() != null && !requestBody.getSchemaAttributeProperties().isEmpty()) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttributes");
                for (SchemaAttributeProperties schemaAttributeProperties : requestBody.getSchemaAttributeProperties()) {
                    this.addAssociatedSchemaAttribute(userId, serverName, assetGUID, parentGUID, schemaAttributeProperties, "addSchemaAttributes");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttributes", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSchemaAttributes(String serverName, String userId, String assetGUID, String parentGUID, List<SchemaAttributeProperties> requestBody) {
        String methodName = "addSchemaAttributes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttributes");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && !requestBody.isEmpty()) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttributes");
                for (SchemaAttributeProperties schemaAttributeProperties : requestBody) {
                    this.addAssociatedSchemaAttribute(userId, serverName, assetGUID, parentGUID, schemaAttributeProperties, "addSchemaAttributes");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttributes", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addSchemaAttribute(String serverName, String userId, String assetGUID, String parentGUID, SchemaAttributeProperties requestBody) {
        String methodName = "addSchemaAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttribute");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttribute");
                response.setGUID(this.addAssociatedSchemaAttribute(userId, serverName, assetGUID, parentGUID, requestBody, "addSchemaAttribute"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addConnectionToAsset(String serverName, String userId, String assetGUID, ConnectionRequestBody requestBody) {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addConnectionToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addConnectionToAsset");
            if (requestBody != null) {
                String assetSummary = requestBody.getShortDescription();
                Connection connection = requestBody.getConnection();
                if (connection != null) {
                    ConnectionHandler<ConnectionElement> connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "addConnectionToAsset");
                    connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", "Asset", connection, assetSummary, false, false, new Date(), "addConnectionToAsset");
                } else {
                    String connectionParameterName = "requestBody.getConnection()";
                    restExceptionHandler.handleMissingValue("requestBody.getConnection()", "addConnectionToAsset");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addConnectionToAsset", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addConnectionToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", null, null, false, false, new Date(), "addSemanticAssignment");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String assetElementGUIDParameterName = "assetElementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, null, null, assetElementGUID, "assetElementGUID", glossaryTermGUID, "glossaryTermGUID", null, null, false, false, new Date(), "addSemanticAssignment");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        String assetGUIDParameterName = "assetGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", false, false, new Date(), "removeSemanticAssignment");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        String assetElementGUIDParameterName = "assetElementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, null, null, assetElementGUID, "assetElementGUID", glossaryTermGUID, "glossaryTermGUID", false, false, new Date(), "removeSemanticAssignment");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addAssetOrigin(String serverName, String userId, String assetGUID, OriginRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String organizationGUIDParameterName = "organizationGUID";
        String businessCapabilityGUIDParameterName = "businessCapabilityGUID";
        String methodName = "addAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetOrigin");
                handler.addAssetOrigin(userId, assetGUID, "assetGUID", requestBody.getOrganizationGUID(), "organizationGUID", requestBody.getBusinessCapabilityGUID(), "businessCapabilityGUID", requestBody.getOtherOriginValues(), null, null, true, false, false, new Date(), "addAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAssetOrigin(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "removeAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetOrigin");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeAssetOrigin");
                handler.removeAssetOrigin(userId, assetGUID, "assetGUID", false, false, new Date(), "removeAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeAssetOrigin", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "publishAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "publishAsset");
            handler.publishAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "publishAsset");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "withdrawAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "withdrawAsset");
            handler.withdrawAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "withdrawAsset");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetZones(String serverName, String userId, String assetGUID, List<String> assetZones) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "updateAssetZones";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetZones");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetZones");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetZones");
            handler.updateAssetZones(userId, assetGUID, "assetGUID", assetZones, true, false, false, new Date(), "updateAssetZones");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAssetZones", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetOwner(String serverName, String userId, String assetGUID, OwnerRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "updateAssetOwner";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetOwner");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetOwner");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetOwner");
                String ownerTypeName = requestBody.getOwnerTypeName();
                if (ownerTypeName == null && requestBody.getOwnerType() != null) {
                    if (requestBody.getOwnerType() == OwnerType.USER_ID) {
                        ownerTypeName = "UserIdentity";
                    } else if (requestBody.getOwnerType() == OwnerType.PROFILE_ID) {
                        ownerTypeName = "ActorProfile";
                    }
                }
                handler.addOwner(userId, assetGUID, "assetGUID", "Asset", requestBody.getOwnerId(), ownerTypeName, requestBody.getOwnerPropertyName(), false, false, new Date(), "updateAssetOwner");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateAssetOwner", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAssetOwner", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, SecurityTagsRequestBody requestBody) {
        String methodName = "addSecurityTags";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetGUID, "assetGUID", "Asset", requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), false, false, new Date(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, SecurityTagsRequestBody requestBody) {
        String assetElementGUIDParameterName = "assetElementGUID";
        String assetElementTypeName = "Referenceable";
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetElementGUID, "assetElementGUID", "Referenceable", requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), false, false, new Date(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetGUID, "assetGUID", "Asset", false, false, new Date(), "removeSecurityTags");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        String assetElementGUIDParameterName = "assetElementGUID";
        String assetElementTypeName = "Referenceable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetElementGUID, "assetElementGUID", "Referenceable", false, false, new Date(), "removeSecurityTags");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTemplateClassification(String serverName, String userId, String assetGUID, TemplateClassificationRequestBody requestBody) {
        String methodName = "addTemplateClassification";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTemplateClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTemplateClassification");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addTemplateClassification");
            if (requestBody != null) {
                handler.addTemplateClassification(userId, assetGUID, "assetGUID", "Asset", requestBody.getName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), false, false, new Date(), "addTemplateClassification");
            } else {
                handler.addTemplateClassification(userId, assetGUID, "assetGUID", "Asset", null, null, null, false, false, new Date(), "addTemplateClassification");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTemplateClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTemplateClassification(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "removeTemplateClassification";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTemplateClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTemplateClassification");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeTemplateClassification");
            handler.removeTemplateClassification(userId, assetGUID, "assetGUID", "Asset", false, false, new Date(), "removeTemplateClassification");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTemplateClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String nameParameterName = "name";
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setAssets(handler.getAssetsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, false, false, new Date(), "getAssetsByName"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String searchStringParameter = "searchString";
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setAssets(handler.findAssets(userId, searchString, "searchString", startFrom, pageSize, false, false, new Date(), "findAssets"));
            response.setStartingFromElement(startFrom);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementResponse getAssetSummary(String serverName, String userId, String assetGUID) {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetSummary");
        AssetElementResponse response = new AssetElementResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetSummary");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetSummary");
            response.setAsset((AssetElement)handler.getBeanFromRepository(userId, assetGUID, "assetGUID", "Asset", false, false, new Date(), "getAssetSummary"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetSummary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryAnalysisReportListResponse getDiscoveryAnalysisReports(String serverName, String userId, String assetGUID, int startingFrom, int maxPageSize) {
        String methodName = "getDiscoveryAnalysisReports";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryAnalysisReports");
        DiscoveryAnalysisReportListResponse response = new DiscoveryAnalysisReportListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReports");
            DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReports");
            response.setDiscoveryAnalysisReports(handler.getDiscoveryAnalysisReports(userId, assetGUID, startingFrom, maxPageSize, false, false, new Date(), "getDiscoveryAnalysisReports"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDiscoveryAnalysisReports", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
                AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getDiscoveryReportAnnotations");
                int annotationStatus = AnnotationStatus.UNKNOWN_STATUS.getOpenTypeOrdinal();
                if (requestBody.getAnnotationStatus() != null) {
                    annotationStatus = requestBody.getAnnotationStatus().getOpenTypeOrdinal();
                }
                response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, annotationStatus, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDiscoveryReportAnnotations", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        AuditLog auditLog = null;
        AnnotationStatus annotationStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (requestBody != null) {
            annotationStatus = requestBody.getAnnotationStatus();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, annotationStatus.getOpenTypeOrdinal(), startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "deleteAsset";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAsset");
            handler.deleteBeanInRepository(userId, null, null, assetGUID, "assetGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", null, null, false, false, new Date(), "deleteAsset");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsPeerDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "linkElementsAsPeerDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsPeerDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsPeerDuplicates");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "linkElementsAsPeerDuplicates");
            handler.linkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", true, 1, null, null, null, null, null, instanceHandler.getSupportedZones(userId, serverName, "linkElementsAsPeerDuplicates"), "linkElementsAsPeerDuplicates");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementsAsPeerDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementsAsPeerDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementsAsPeerDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementsAsPeerDuplicates");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "unlinkElementsAsPeerDuplicates");
            handler.unlinkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", instanceHandler.getSupportedZones(userId, serverName, "unlinkElementsAsPeerDuplicates"), "unlinkElementsAsPeerDuplicates");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkElementsAsPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

