/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ODFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportConverter<B>
extends ODFConverter<B> {
    public DiscoveryAnalysisReportConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DiscoveryAnalysisReport) {
                DiscoveryAnalysisReport bean = (DiscoveryAnalysisReport)returnBean;
                bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setDisplayName(this.removeDisplayName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setCreationDate(this.removeExecutionDate(instanceProperties));
                bean.setAnalysisParameters(this.removeAnalysisParameters(instanceProperties));
                bean.setAnalysisStep(this.removeAnalysisStep(instanceProperties));
                bean.setDiscoveryRequestStatus(this.removeRequestStatusFromProperties(instanceProperties));
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        EntityProxy endOne;
                        if (relationship == null || relationship.getType() == null || relationship.getType().getTypeDefName() == null) continue;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AssetDiscoveryReport")) {
                            endOne = relationship.getEntityOneProxy();
                            if (endOne == null) continue;
                            bean.setAssetGUID(endOne.getGUID());
                            continue;
                        }
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveryEngineReport")) {
                            endOne = relationship.getEntityOneProxy();
                            if (endOne == null) continue;
                            bean.setDiscoveryEngineGUID(endOne.getGUID());
                            continue;
                        }
                        if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "DiscoveryInvocationReport") || (endOne = relationship.getEntityOneProxy()) == null) continue;
                        bean.setDiscoveryServiceGUID(endOne.getGUID());
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private DiscoveryRequestStatus removeRequestStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        DiscoveryRequestStatus requestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("discoveryServiceStatus")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = DiscoveryRequestStatus.WAITING;
                    break;
                }
                case 1: {
                    requestStatus = DiscoveryRequestStatus.ACTIVATING;
                    break;
                }
                case 2: {
                    requestStatus = DiscoveryRequestStatus.IN_PROGRESS;
                    break;
                }
                case 3: {
                    requestStatus = DiscoveryRequestStatus.FAILED;
                    break;
                }
                case 4: {
                    requestStatus = DiscoveryRequestStatus.COMPLETED;
                    break;
                }
                case 5: {
                    requestStatus = DiscoveryRequestStatus.OTHER;
                    break;
                }
                default: {
                    requestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS;
                }
            }
            instancePropertiesMap.remove("discoveryServiceStatus");
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return requestStatus;
    }
}

