/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class RelatedElementRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RelatedElementRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setupMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupMoreInformation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupMoreInformation");
                } else {
                    handler.addMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", null, null, false, false, new Date(), "setupMoreInformation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupMoreInformation", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearMoreInformation");
            if (requestBody != null) {
                handler.removeMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            } else {
                handler.removeMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getMoreInformation(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getMoreInformation");
            response.setElementList(handler.getMoreInformation(userId, elementGUID, "elementGUID", "Referenceable", "Referenceable", startFrom, pageSize, false, false, new Date(), "getMoreInformation"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getDescriptiveElements(String serverName, String userId, String detailGUID, int startFrom, int pageSize) {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDescriptiveElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDescriptiveElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getDescriptiveElements");
            response.setElementList(handler.getDescriptiveElements(userId, detailGUID, "detailGUID", "Referenceable", "Referenceable", startFrom, pageSize, false, false, new Date(), "getDescriptiveElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDescriptiveElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupStakeholder");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof StakeholderProperties) {
                    StakeholderProperties properties = (StakeholderProperties)requestBody.getProperties();
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", properties.getStakeholderRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupStakeholder");
                } else if (requestBody.getProperties() == null) {
                    handler.addStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", null, null, null, false, false, new Date(), "setupStakeholder");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StakeholderProperties.class.getName(), "setupStakeholder");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupStakeholder", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearStakeholder");
            if (requestBody != null) {
                handler.removeStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            } else {
                handler.removeStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholders(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholders");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholders");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholders");
            response.setElementList(handler.getStakeholders(userId, elementGUID, "elementGUID", "Referenceable", "Referenceable", startFrom, pageSize, false, false, new Date(), "getStakeholders"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholderCommissionedElements(String serverName, String userId, String stakeholderGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholderCommissionedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholderCommissionedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholderCommissionedElements");
            response.setElementList(handler.getCommissionedByStakeholder(userId, stakeholderGUID, "stakeholderGUID", "Referenceable", "Referenceable", startFrom, pageSize, false, false, new Date(), "getStakeholderCommissionedElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholderCommissionedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String userId, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)requestBody.getProperties();
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", properties.getResourceUse(), properties.getWatchResource(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", null, false, null, null, false, false, new Date(), "setupResource");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String userId, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.removeResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            } else {
                handler.removeResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getResourceList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResourceList");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getResourceList");
            response.setElementList(handler.getResourceList(userId, elementGUID, "elementGUID", "Referenceable", startFrom, pageSize, false, false, new Date(), "getResourceList"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getSupportedByResource(String serverName, String userId, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByResource");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByResource");
            response.setElementList(handler.getSupportedByResource(userId, resourceGUID, "resourceGUID", "Referenceable", startFrom, pageSize, false, false, new Date(), "getSupportedByResource"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

