/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.outtopic;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.events.AssetOwnerEventType;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.outtopic.AssetOwnerOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetOwnerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(AssetOwnerOMRSTopicListener.class);
    private final AssetOwnerOutTopicPublisher eventPublisher;
    private final AssetHandler<AssetElement> assetHandler;
    private final String localServerUserId;
    private final List<String> supportedZones;
    private final OMRSRepositoryHelper repositoryHelper;

    public AssetOwnerOMRSTopicListener(String serviceName, String localServerUserId, AssetOwnerOutTopicPublisher eventPublisher, AssetHandler<AssetElement> assetHandler, List<String> supportedZones, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.assetHandler = assetHandler;
        this.repositoryHelper = assetHandler.getRepositoryHelper();
        this.supportedZones = supportedZones;
        this.localServerUserId = localServerUserId;
        this.eventPublisher = eventPublisher;
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Received new Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing new Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.NEW_ELEMENT_CREATED);
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        log.debug("Received updated Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, newEntity, null);
        if (eventEntity != null) {
            log.debug("Publishing updated Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_UPDATED, eventEntity, oldEntity, null, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification classification) {
        log.debug("Processing classified EntityProxy event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, classification);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        log.debug("Received classified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing classified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_CLASSIFIED, eventEntity, null, classification, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Received classified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing classified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_CLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, originalClassification);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, originalClassification);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification, Classification classification) {
        log.debug("Processing reclassified EntityProxy event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, classification, originalClassification);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        log.debug("Receiving reclassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, classification, originalClassification);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving reclassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetOwnerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving deleted Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing deleted Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.ELEMENT_DELETED);
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing delete-purge entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing delete-purge entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.ELEMENT_DELETED);
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving restored Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing restored Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.ELEMENT_RESTORED);
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        log.debug("Processing re-identified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing re-identified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.ELEMENT_GUID_CHANGED);
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        log.debug("Processing re-typed Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing re-typed Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.ELEMENT_TYPE_CHANGED);
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving refresh Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing refresh Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetOwnerEventType.REFRESH_ELEMENT_EVENT);
        }
    }

    private EntityDetail entityOfInterest(String userId, EntityDetail entity, EntityProxy entityProxy) {
        String methodName = "entityOfInterest";
        String guidParameterName = "entity.getGUID()";
        try {
            EntityDetail fullEntity = null;
            Date effectiveTime = new Date();
            if (entity != null) {
                if (this.isTypeOfInterest((InstanceHeader)entity)) {
                    fullEntity = entity;
                    this.assetHandler.validateAnchorEntity(userId, fullEntity.getGUID(), "Asset", fullEntity, "entity.getGUID()", false, true, false, this.supportedZones, effectiveTime, "entityOfInterest");
                }
            } else if (entityProxy != null && this.isTypeOfInterest((InstanceHeader)entityProxy)) {
                fullEntity = this.assetHandler.getEntityFromRepository(userId, entityProxy.getGUID(), "entity.getGUID()", entityProxy.getType().getTypeDefName(), null, null, false, false, this.supportedZones, effectiveTime, "entityOfInterest");
            }
            if (fullEntity != null) {
                return fullEntity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isTypeOfInterest(InstanceHeader entityHeader) {
        return this.repositoryHelper.isTypeOf(this.serviceName, entityHeader.getType().getTypeDefName(), "Asset");
    }
}

