/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.OwnerType;
import org.odpi.openmetadata.accessservices.assetowner.properties.RelationshipProperties;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

abstract class AssetOwnerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    AssetOwnerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    OwnerType removeOwnerTypeFromProperties(InstanceProperties properties) {
        OwnerType ownerType = this.getOwnerTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerType;
    }

    OwnerType getOwnerTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        OwnerType ownerType = OwnerType.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    ownerType = OwnerType.USER_ID;
                    break;
                }
                case 1: {
                    ownerType = OwnerType.PROFILE_ID;
                    break;
                }
                case 99: {
                    ownerType = OwnerType.OTHER;
                }
            }
        }
        return ownerType;
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entity != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entity, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, Relationship relationship, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entityProxy != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entityProxy, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }
}

