/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetowner.converters.AssetOwnerOMASConverter;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.ValidValueProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueConverter<B>
extends AssetOwnerOMASConverter<B> {
    public ValidValueConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ValidValueElement) {
                ValidValueElement bean = (ValidValueElement)returnBean;
                this.updateSimpleMetadataElement(beanClass, bean, entity, methodName);
                if (relationship != null && this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName)) {
                    bean.setSetGUID(relationship.getEntityOneProxy().getGUID());
                    bean.setIsDefaultValue(this.removeIsDefaultValue(relationship.getProperties()));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ValidValueElement) {
                this.updateSimpleMetadataElement(beanClass, (ValidValueElement)returnBean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(Class<B> beanClass, ValidValueElement bean, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
            ValidValueProperties validValueProperties = new ValidValueProperties();
            InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
            validValueProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
            validValueProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
            validValueProperties.setDisplayName(this.removeName(instanceProperties));
            validValueProperties.setDescription(this.removeDescription(instanceProperties));
            validValueProperties.setCategory(this.removeCategory(instanceProperties));
            validValueProperties.setUsage(this.removeUsage(instanceProperties));
            validValueProperties.setScope(this.removeScope(instanceProperties));
            validValueProperties.setPreferredValue(this.removePreferredValue(instanceProperties));
            validValueProperties.setDataType(this.removeDataType(instanceProperties));
            validValueProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
            validValueProperties.setIsCaseSensitive(this.removeIsCaseSensitive(instanceProperties));
            validValueProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
            validValueProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            bean.setValidValueProperties(validValueProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }
}

