/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.LicenseProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.LicenseTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.LicenseTypeListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.LicenseTypeResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.LicenseHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class LicenseRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(LicenseRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public LicenseTypeResponse getLicenseTypeByGUID(String serverName, String userId, String licenseTypeGUID) {
        String methodName = "getLicenseTypeByGUID";
        String guidParameterName = "licenseTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicenseTypeByGUID");
        LicenseTypeResponse response = new LicenseTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenseTypeByGUID");
            LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "getLicenseTypeByGUID");
            response.setElement((LicenseTypeElement)handler.getGovernanceDefinitionByGUID(userId, licenseTypeGUID, "licenseTypeGUID", false, false, new Date(), "getLicenseTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicenseTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LicenseTypeResponse getLicenseTypeByDocId(String serverName, String userId, String documentIdentifier) {
        String methodName = "getLicenseTypeByDocId";
        String documentIdParameterName = "documentId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicenseTypeByDocId");
        LicenseTypeResponse response = new LicenseTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenseTypeByDocId");
            LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "getLicenseTypeByDocId");
            List licenseTypeElements = handler.getGovernanceDefinitionsByName(userId, "LicenseType", documentIdentifier, "documentId", 0, 0, false, false, new Date(), "getLicenseTypeByDocId");
            if (licenseTypeElements != null && !licenseTypeElements.isEmpty()) {
                response.setElement((LicenseTypeElement)licenseTypeElements.get(0));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicenseTypeByDocId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LicenseTypeListResponse getLicenseTypesByTitle(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "getLicenseTypesByTitle";
        String titleParameterName = "title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicenseTypesByTitle");
        LicenseTypeListResponse response = new LicenseTypeListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenseTypesByTitle");
                LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "getLicenseTypesByTitle");
                response.setElements(handler.findGovernanceDefinitions(userId, "LicenseType", requestBody.getSearchString(), "title", startFrom, pageSize, false, false, new Date(), "getLicenseTypesByTitle"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getLicenseTypesByTitle", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicenseTypesByTitle", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LicenseTypeListResponse getLicenseTypeByDomainId(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getLicenseTypeByDomainId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicenseTypeByDomainId");
        LicenseTypeListResponse response = new LicenseTypeListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenseTypeByDomainId");
            LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "getLicenseTypeByDomainId");
            response.setElements(handler.getGovernanceDefinitionsByDomain(userId, "LicenseType", domainIdentifier, startFrom, pageSize, false, false, new Date(), "getLicenseTypeByDomainId"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicenseTypeByDomainId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse licenseElement(String serverName, String userId, String elementGUID, String licenseTypeGUID, RelationshipRequestBody requestBody) {
        String methodName = "licenseElement";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "licenseElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof LicenseProperties) {
                    LicenseProperties properties = (LicenseProperties)relationshipProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "licenseElement");
                    LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "licenseElement");
                    response.setGUID(handler.licenseElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, licenseTypeGUID, "licenseTypeGUID", "LicenseType", properties.getLicenseId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getLicensedBy(), properties.getLicensedByTypeName(), properties.getLicensedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getLicensee(), properties.getLicenseeTypeName(), properties.getLicenseePropertyName(), properties.getNotes(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "licenseElement"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(LicenseTypeProperties.class.getName(), "licenseElement");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "licenseElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "licenseElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateLicense(String serverName, String userId, String licenseGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateLicense";
        String licenseGUIDParameterName = "licenseGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateLicense");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof LicenseProperties) {
                    LicenseProperties properties = (LicenseProperties)relationshipProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateLicense");
                    LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "updateLicense");
                    handler.updateLicense(userId, null, null, licenseGUID, "licenseGUID", properties.getLicenseId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getLicensedBy(), properties.getLicensedByTypeName(), properties.getLicensedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getLicensee(), properties.getLicenseeTypeName(), properties.getLicenseePropertyName(), properties.getNotes(), isMergeUpdate, null, null, false, false, new Date(), "updateLicense");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(LicenseProperties.class.getName(), "updateLicense");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateLicense", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateLicense", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlicenseElement(String serverName, String userId, String licenseGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlicenseElement";
        String licenseGUIDParameterName = "licenseGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlicenseElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlicenseElement");
            LicenseHandler<LicenseTypeElement> handler = instanceHandler.getLicenseTypeHandler(userId, serverName, "unlicenseElement");
            handler.unlicenseElement(userId, null, null, licenseGUID, "licenseGUID", false, false, new Date(), "unlicenseElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlicenseElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getLicensedElements(String serverName, String userId, String licenseTypeGUID, int startFrom, int pageSize) {
        String methodName = "getLicensedElements";
        String guidParameter = "licenseTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicensedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicensedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getLicensedElements");
            response.setElementList(handler.getAttachedElements(userId, licenseTypeGUID, "licenseTypeGUID", "LicenseType", "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, false, false, startFrom, pageSize, new Date(), "getLicensedElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicensedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getLicenses(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicences");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicences");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getLicences");
            response.setElementList(handler.getAttachedElements(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", "LicenseType", null, null, 2, false, false, startFrom, pageSize, new Date(), "getLicences"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

