/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class RelatedElementRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RelatedElementRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setupMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupMoreInformation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.addMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupMoreInformation");
                } else {
                    handler.addMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", null, null, false, false, new Date(), "setupMoreInformation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupMoreInformation", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearMoreInformation(String serverName, String userId, String elementGUID, String detailGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearMoreInformation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearMoreInformation");
            if (requestBody != null) {
                handler.removeMoreInformation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            } else {
                handler.removeMoreInformation(userId, null, null, elementGUID, "elementGUID", detailGUID, "detailGUID", false, false, new Date(), "clearMoreInformation");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getMoreInformation(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getMoreInformation");
            response.setElementList(handler.getMoreInformation(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getMoreInformation"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getDescriptiveElements(String serverName, String userId, String detailGUID, int startFrom, int pageSize) {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDescriptiveElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDescriptiveElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getDescriptiveElements");
            response.setElementList(handler.getDescriptiveElements(userId, detailGUID, "detailGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getDescriptiveElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDescriptiveElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupStakeholder");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof StakeholderProperties) {
                    StakeholderProperties properties = (StakeholderProperties)relationshipProperties;
                    handler.addStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", properties.getStakeholderRole(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupStakeholder");
                } else if (requestBody.getProperties() == null) {
                    handler.addStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", null, null, null, false, false, new Date(), "setupStakeholder");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StakeholderProperties.class.getName(), "setupStakeholder");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupStakeholder", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStakeholder(String serverName, String userId, String elementGUID, String stakeholderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearStakeholder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearStakeholder");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearStakeholder");
            if (requestBody != null) {
                handler.removeStakeholder(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            } else {
                handler.removeStakeholder(userId, null, null, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", false, false, new Date(), "clearStakeholder");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearStakeholder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholders(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholders");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholders");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholders");
            response.setElementList(handler.getStakeholders(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholders"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getStakeholderCommissionedElements(String serverName, String userId, String stakeholderGUID, int startFrom, int pageSize) {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStakeholderCommissionedElements");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStakeholderCommissionedElements");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getStakeholderCommissionedElements");
            response.setElementList(handler.getCommissionedByStakeholder(userId, stakeholderGUID, "stakeholderGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getStakeholderCommissionedElements"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getStakeholderCommissionedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupResource(String serverName, String userId, String elementGUID, String resourceGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)relationshipProperties;
                    handler.saveResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", properties.getResourceUse(), properties.getResourceUseDescription(), properties.getResourceUseProperties(), properties.getWatchResource(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", null, null, null, false, null, null, false, false, new Date(), "setupResource");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearResource(String serverName, String userId, String elementGUID, String resourceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearResource");
            if (requestBody != null) {
                handler.removeResourceListMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            } else {
                handler.removeResourceListMember(userId, null, null, elementGUID, "elementGUID", resourceGUID, "resourceGUID", false, false, new Date(), "clearResource");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getResourceList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getResourceList");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceList");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getResourceList");
            response.setElementList(handler.getResourceList(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getResourceList"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getResourceList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getSupportedByResource(String serverName, String userId, String resourceGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByResource");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByResource");
            response.setElementList(handler.getSupportedByResource(userId, resourceGUID, "resourceGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getSupportedByResource"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSupportedByResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCatalogTemplate(String serverName, String userId, String elementGUID, String templateGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String templateGUIDParameterName = "templateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupResource");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupResource");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "setupResource");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ResourceListProperties) {
                    ResourceListProperties properties = (ResourceListProperties)relationshipProperties;
                    handler.saveCatalogTemplate(userId, null, null, elementGUID, "elementGUID", templateGUID, "templateGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupResource");
                } else if (requestBody.getProperties() == null) {
                    handler.saveCatalogTemplate(userId, null, null, elementGUID, "elementGUID", templateGUID, "templateGUID", null, null, false, false, new Date(), "setupResource");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ResourceListProperties.class.getName(), "setupResource");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupResource", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupResource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCatalogTemplate(String serverName, String userId, String elementGUID, String templateGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearCatalogTemplate";
        String elementGUIDParameterName = "elementGUID";
        String templateGUIDParameterName = "templateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCatalogTemplate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCatalogTemplate");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "clearCatalogTemplate");
            if (requestBody != null) {
                handler.removeCatalogTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), elementGUID, "elementGUID", templateGUID, "templateGUID", false, false, new Date(), "clearCatalogTemplate");
            } else {
                handler.removeCatalogTemplate(userId, null, null, elementGUID, "elementGUID", templateGUID, "templateGUID", false, false, new Date(), "clearCatalogTemplate");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearCatalogTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getCatalogTemplateList(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getCatalogTemplateList";
        String guidPropertyName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTemplateList");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTemplateList");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getCatalogTemplateList");
            response.setElementList(handler.getCatalogTemplateList(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getCatalogTemplateList"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTemplateList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getSupportedByTemplate(String serverName, String userId, String templateGUID, int startFrom, int pageSize) {
        String methodName = "getSupportedByTemplate";
        String guidPropertyName = "templateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSupportedByTemplate");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedByTemplate");
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSupportedByTemplate");
            response.setElementList(handler.getSupportedByTemplate(userId, templateGUID, "templateGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, false, false, new Date(), "getSupportedByTemplate"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSupportedByTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

