/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValueSet(String serverName, String userId, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueSet");
                response.setGUID(handler.createValidValueSet(userId, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCategory(), requestBody.getUsage(), requestBody.getScope(), false, false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, "createValidValueSet"), null, null, new Date(), "createValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueSet", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createValidValueDefinition(String serverName, String userId, String setGUID, boolean isDefaultValue, ValidValuesRequestBody requestBody) {
        String methodName = "createValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueDefinition");
                response.setGUID(handler.createValidValueDefinition(userId, null, null, setGUID, isDefaultValue, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCategory(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getDataType(), false, false, requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, "createValidValueDefinition"), null, null, false, false, new Date(), "createValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueDefinition", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, ValidValuesRequestBody requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "updateValidValue");
                handler.updateValidValue(userId, null, null, validValueGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCategory(), requestBody.getUsage(), requestBody.getScope(), false, false, requestBody.getPreferredValue(), requestBody.getDataType(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, "updateValidValue"), null, null, true, false, false, new Date(), "updateValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteValidValue(String serverName, String userId, String validValueGUID, String qualifiedName) {
        String methodName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteValidValue");
            if (qualifiedName != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "deleteValidValue");
                handler.deleteValidValue(userId, null, null, validValueGUID, qualifiedName, false, false, new Date(), "deleteValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachValidValueToSet(String serverName, String userId, String setGUID, String validValueGUID, boolean isDefaultValue, NullRequestBody requestBody) {
        String methodName = "attachValidValueToSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachValidValueToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachValidValueToSet");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "attachValidValueToSet");
            handler.attachValidValueToSet(userId, null, null, setGUID, validValueGUID, isDefaultValue, null, null, instanceHandler.getSupportedZones(userId, serverName, "attachValidValueToSet"), false, false, new Date(), "attachValidValueToSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachValidValueToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachValidValueFromSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "detachValidValueFromSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachValidValueFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachValidValueFromSet");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "detachValidValueFromSet");
            handler.detachValidValueFromSet(userId, null, null, setGUID, validValueGUID, false, false, new Date(), "detachValidValueFromSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachValidValueFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String validValueGUID) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByGUID");
            response.setElement((ValidValueElement)handler.getValidValueByGUID(userId, validValueGUID, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueByGUID"), new Date(), "getValidValueByGUID"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueByName(String serverName, String userId, String validValueName, int startFrom, int pageSize) {
        String nameParameterName = "validValueName";
        String methodName = "getValidValueByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByName");
            if (validValueName != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByName");
                response.setElements(handler.getValidValueByName(userId, validValueName, "validValueName", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueByName"), new Date(), "getValidValueByName"));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValueByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String searchStringParameterName = "searchString";
        String methodName = "findValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValues");
                response.setElements(handler.findValidValues(userId, requestBody.getFilter(), "searchString", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "findValidValues"), requestBody.getEffectiveTime(), "findValidValues"));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueSetGUID";
        String methodName = "getValidValueSetMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetMembers");
            response.setElements(handler.getValidValueSetMembers(userId, validValueSetGUID, "validValueSetGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueSetMembers"), new Date(), "getValidValueSetMembers"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getSetsForValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getSetsForValidValue");
            response.setElements(handler.getSetsForValidValue(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getSetsForValidValue"), new Date(), "getSetsForValidValue"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

