/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.AnnotationStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.AnnotationsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeaderResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SurveyReportsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ElementHeaderConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SurveyReportHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.enums.AnnotationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelationshipElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.SupplementaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataSetContentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SurveyReport;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class AssetOwnerRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetOwnerRESTServices.class), instanceHandler.getServiceName());
    private static final String schemaTypeGUIDParameterName = "schemaTypeGUID";
    private static final String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public RegisteredOMAGServiceResponse getServiceDescription(String serverName, String userId) {
        String methodName = "getServiceDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServiceDescription");
        RegisteredOMAGServiceResponse response = new RegisteredOMAGServiceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServiceDescription");
            response.setService(instanceHandler.getRegisteredOMAGService(userId, serverName, AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceCode(), "getServiceDescription"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServiceDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTypesOfAsset(String serverName, String userId) {
        String methodName = "getTypesOfAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAsset");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getTypesOfAsset");
            response.setNames(handler.getTypesOfAssetList());
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTypesOfAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getTypesOfAssetDescriptions(String serverName, String userId) {
        String methodName = "getTypesOfAssetDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAssetDescription");
        StringMapResponse response = new StringMapResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAssetDescription");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getTypesOfAssetDescription");
            response.setStringMap(handler.getTypesOfAssetDescriptions());
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTypesOfAssetDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAssetToCatalog(String serverName, String userId, String typeName, AssetProperties requestBody) {
        String methodName = "addAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetToCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalog");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalog");
                String assetTypeName = OpenMetadataType.ASSET.typeName;
                if (typeName != null) {
                    assetTypeName = typeName;
                }
                Date effectiveTime = new Date();
                String assetGUID = handler.createAssetInRepository(userId, null, null, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), assetTypeName, requestBody.getExtendedProperties(), InstanceStatus.ACTIVE, null, null, effectiveTime, "addAssetToCatalog");
                if (assetGUID != null) {
                    String assetGUIDParameterName = "assetGUID";
                    this.maintainSupplementaryProperties(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET.typeName, requestBody.getQualifiedName(), (SupplementaryProperties)requestBody, true, effectiveTime, handler, "addAssetToCatalog");
                }
                response.setGUID(assetGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalog", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAssetToCatalogUsingTemplate(String serverName, String userId, String templateGUID, TemplateProperties requestBody) {
        String methodName = "addAssetToCatalogUsingTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetToCatalogUsingTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetToCatalogUsingTemplate");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetToCatalogUsingTemplate");
                response.setGUID(handler.addAssetFromTemplate(userId, null, null, templateGUID, "templateGUID", OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, requestBody.getPathName(), requestBody.getNetworkAddress(), false, false, new Date(), "addAssetToCatalogUsingTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetToCatalogUsingTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addAssetToCatalogUsingTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAsset(String serverName, String userId, String assetGUID, boolean isMergeUpdate, AssetProperties requestBody) {
        String methodName = "updateAsset";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAsset");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAsset");
                Date effectiveTime = new Date();
                handler.updateAsset(userId, null, null, assetGUID, "assetGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, effectiveTime, "updateAsset");
                this.maintainSupplementaryProperties(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET.typeName, requestBody.getQualifiedName(), (SupplementaryProperties)requestBody, isMergeUpdate, effectiveTime, handler, "updateAsset");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupRelatedAsset(String serverName, String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupRelatedDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupRelatedDataAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupRelatedDataAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "setupRelatedDataAsset");
            String fromAssetGUIDParameterName = "fromAssetGUID";
            String toAssetGUIDParameterName = "toAssetGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "setupRelatedDataAsset");
            this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "setupRelatedDataAsset");
            this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "setupRelatedDataAsset");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupRelatedDataAsset");
            String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, handler.getServiceName(), "setupRelatedDataAsset", handler.getRepositoryHelper());
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof DataSetContentProperties) {
                    DataSetContentProperties dataSetContentProperties = (DataSetContentProperties)relationshipProperties;
                    InstanceProperties instanceProperties = handler.getRepositoryHelper().addStringPropertyToInstance(handler.getServiceName(), null, OpenMetadataProperty.QUERY_ID.name, dataSetContentProperties.getQueryId(), "setupRelatedDataAsset");
                    instanceProperties = handler.getRepositoryHelper().addStringPropertyToInstance(handler.getServiceName(), instanceProperties, OpenMetadataProperty.QUERY.name, dataSetContentProperties.getQuery(), "setupRelatedDataAsset");
                    response.setGUID(handler.linkElementToElement(userId, null, null, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, toAssetGUID, "toAssetGUID", OpenMetadataType.ASSET.typeName, false, false, handler.getSupportedZones(), relationshipTypeGUID, relationshipTypeName, instanceProperties, null, null, requestBody.getEffectiveTime(), "setupRelatedDataAsset"));
                } else {
                    response.setGUID(handler.linkElementToElement(userId, null, null, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, toAssetGUID, "toAssetGUID", OpenMetadataType.ASSET.typeName, false, false, handler.getSupportedZones(), relationshipTypeGUID, relationshipTypeName, null, null, null, requestBody.getEffectiveTime(), "setupRelatedDataAsset"));
                }
            } else {
                response.setGUID(handler.linkElementToElement(userId, null, null, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, toAssetGUID, "toAssetGUID", OpenMetadataType.ASSET.typeName, false, false, handler.getSupportedZones(), relationshipTypeGUID, relationshipTypeName, null, null, null, null, "setupRelatedDataAsset"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupRelatedDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementResponse getAssetRelationship(String serverName, String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetRelationship");
        RelationshipElementResponse response = new RelationshipElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetRelationship");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetRelationship");
            String fromAssetGUIDParameterName = "fromAssetGUID";
            String toAssetGUIDParameterName = "toAssetGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "getAssetRelationship");
            this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getAssetRelationship");
            this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getAssetRelationship");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getAssetRelationship");
            String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, instanceHandler.getServiceName(), "getAssetRelationship", handler.getRepositoryHelper());
            Relationship relationship = requestBody != null ? handler.getUniqueAttachmentLink(userId, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, toAssetGUID, OpenMetadataType.ASSET.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, requestBody.getEffectiveTime(), "getAssetRelationship") : handler.getUniqueAttachmentLink(userId, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, toAssetGUID, OpenMetadataType.ASSET.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, null, "getAssetRelationship");
            response.setElement(this.getRelationshipElement(relationship, handler.getRepositoryHelper(), serverName, "getAssetRelationship"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetRelationship(String serverName, String userId, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetRelationship");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetRelationship");
            String relationshipGUIDParameterName = "relationshipGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "updateAssetRelationship");
            this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateAssetRelationship");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "updateAssetRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties;
                InstanceProperties instanceProperties = null;
                if (requestBody.getProperties() != null && (relationshipProperties = requestBody.getProperties()) instanceof DataSetContentProperties) {
                    DataSetContentProperties dataSetContentProperties = (DataSetContentProperties)relationshipProperties;
                    instanceProperties = handler.getRepositoryHelper().addStringPropertyToInstance(handler.getServiceName(), null, OpenMetadataProperty.QUERY_ID.name, dataSetContentProperties.getQueryId(), "updateAssetRelationship");
                    instanceProperties = handler.getRepositoryHelper().addStringPropertyToInstance(handler.getServiceName(), instanceProperties, OpenMetadataProperty.QUERY.name, dataSetContentProperties.getQuery(), "updateAssetRelationship");
                }
                handler.updateElementToElementLink(userId, null, null, relationshipGUID, "relationshipGUID", relationshipTypeName, false, false, handler.getSupportedZones(), isMergeUpdate, instanceProperties, requestBody.getEffectiveTime(), "updateAssetRelationship");
            } else {
                handler.updateElementToElementLink(userId, null, null, relationshipGUID, "relationshipGUID", relationshipTypeName, false, false, handler.getSupportedZones(), isMergeUpdate, null, null, "updateAssetRelationship");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetRelationship(String serverName, String userId, String relationshipTypeName, String relationshipGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetRelationship");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "clearAssetRelationship");
            String relationshipGUIDParameterName = "relationshipGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "clearAssetRelationship");
            this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "clearAssetRelationship");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearAssetRelationship");
            if (requestBody != null) {
                handler.deleteRelationship(userId, null, null, relationshipGUID, "relationshipGUID", relationshipTypeName, false, false, handler.getSupportedZones(), requestBody.getEffectiveTime(), "clearAssetRelationship");
            } else {
                handler.deleteRelationship(userId, null, null, relationshipGUID, "relationshipGUID", relationshipTypeName, false, false, handler.getSupportedZones(), null, "clearAssetRelationship");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementsResponse getRelatedAssetsAtEnd2(String serverName, String userId, String relationshipTypeName, String fromAssetGUID, int startFrom, int pageSize, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getRelatedAssetsAtEnd2";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssetsAtEnd2");
        RelationshipElementsResponse response = new RelationshipElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssetsAtEnd2");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getRelatedAssetsAtEnd2");
            String fromAssetGUIDParameterName = "fromAssetGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd2");
            this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getRelatedAssetsAtEnd2");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd2");
            String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, instanceHandler.getServiceName(), "getRelatedAssetsAtEnd2", handler.getRepositoryHelper());
            List relationships = requestBody != null ? handler.getAttachmentLinks(userId, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, null, OpenMetadataType.ASSET.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getRelatedAssetsAtEnd2") : handler.getAttachmentLinks(userId, fromAssetGUID, "fromAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, null, OpenMetadataType.ASSET.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, null, "getRelatedAssetsAtEnd2");
            if (relationships != null) {
                ArrayList<RelationshipElement> relationshipElements = new ArrayList<RelationshipElement>();
                for (Relationship relationship : relationships) {
                    relationshipElements.add(this.getRelationshipElement(relationship, handler.getRepositoryHelper(), serverName, "getRelatedAssetsAtEnd2"));
                }
                response.setElements(relationshipElements);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedAssetsAtEnd2", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementsResponse getRelatedAssetsAtEnd1(String serverName, String userId, String relationshipTypeName, String toAssetGUID, int startFrom, int pageSize, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getRelatedAssetsAtEnd1";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssetsAtEnd1");
        RelationshipElementsResponse response = new RelationshipElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssetsAtEnd1");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getRelatedAssetsAtEnd1");
            String toAssetGUIDParameterName = "toAssetGUID";
            String typeNameParameterName = "relationshipTypeName";
            this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd1");
            this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getRelatedAssetsAtEnd1");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd1");
            String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, instanceHandler.getServiceName(), "getRelatedAssetsAtEnd1", handler.getRepositoryHelper());
            List relationships = requestBody != null ? handler.getAttachmentLinks(userId, toAssetGUID, "toAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, null, OpenMetadataType.ASSET.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getRelatedAssetsAtEnd1") : handler.getAttachmentLinks(userId, toAssetGUID, "toAssetGUID", OpenMetadataType.ASSET.typeName, relationshipTypeGUID, relationshipTypeName, null, OpenMetadataType.ASSET.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, null, "getRelatedAssetsAtEnd1");
            if (relationships != null) {
                ArrayList<RelationshipElement> relationshipElements = new ArrayList<RelationshipElement>();
                for (Relationship relationship : relationships) {
                    relationshipElements.add(this.getRelationshipElement(relationship, handler.getRepositoryHelper(), serverName, "getRelatedAssetsAtEnd1"));
                }
                response.setElements(relationshipElements);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedAssetsAtEnd1", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private RelationshipElement getRelationshipElement(Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serverName, String methodName) throws PropertyServerException {
        RelationshipElement relationshipElement = null;
        if (relationship != null) {
            ElementHeaderConverter elementHeaderConverter = new ElementHeaderConverter(repositoryHelper, instanceHandler.getServiceName(), serverName);
            relationshipElement = new RelationshipElement();
            relationshipElement.setRelationshipHeader((ElementHeader)elementHeaderConverter.getNewBean(ElementHeader.class, relationship, methodName));
            relationshipElement.setEnd1(elementHeaderConverter.getElementStub(ElementHeader.class, relationship.getEntityOneProxy(), methodName));
            relationshipElement.setEnd2(elementHeaderConverter.getElementStub(ElementHeader.class, relationship.getEntityTwoProxy(), methodName));
            if (relationship.getProperties() != null) {
                if (OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName.equals(relationship.getType().getTypeDefName())) {
                    DataSetContentProperties properties = new DataSetContentProperties();
                    properties.setQueryId(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.QUERY_ID.name, relationship.getProperties(), methodName));
                    properties.setQuery(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.QUERY.name, relationship.getProperties(), methodName));
                    properties.setQueryType(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.QUERY_TYPE.name, relationship.getProperties(), methodName));
                    properties.setISCQualifiedName(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.ISC_QUALIFIED_NAME.name, relationship.getProperties(), methodName));
                    properties.setEffectiveFrom(relationship.getProperties().getEffectiveFromTime());
                    properties.setEffectiveTo(relationship.getProperties().getEffectiveFromTime());
                    relationshipElement.setRelationshipProperties((RelationshipProperties)properties);
                } else {
                    RelationshipProperties properties = new RelationshipProperties();
                    properties.setEffectiveFrom(relationship.getProperties().getEffectiveFromTime());
                    properties.setEffectiveTo(relationship.getProperties().getEffectiveFromTime());
                    relationshipElement.setRelationshipProperties(properties);
                }
            }
        }
        return relationshipElement;
    }

    public GUIDResponse addCombinedSchemaToAsset(String serverName, String userId, String assetGUID, CombinedSchemaRequestBody requestBody) {
        String methodName = "addCombinedSchemaToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCombinedSchemaToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                if (requestBody.getSchemaType() != null) {
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "addCombinedSchemaToAsset");
                    response.setGUID(this.addAssociatedSchemaType(userId, serverName, assetGUID, requestBody.getSchemaType(), "addCombinedSchemaToAsset"));
                    if (requestBody.getSchemaAttributes() != null) {
                        for (SchemaAttributeProperties schemaAttributeProperties : requestBody.getSchemaAttributes()) {
                            this.addAssociatedSchemaAttribute(userId, serverName, assetGUID, response.getGUID(), schemaAttributeProperties, "addCombinedSchemaToAsset");
                        }
                    }
                } else {
                    String parameterName = "requestBody.getSchemaType()";
                    restExceptionHandler.handleMissingValue("requestBody.getSchemaType()", "addCombinedSchemaToAsset");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCombinedSchemaToAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addCombinedSchemaToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addSchemaTypeToAsset(String serverName, String userId, String assetGUID, SchemaTypeProperties requestBody) {
        String methodName = "addSchemaTypeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaTypeToAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaTypeToAsset");
            if (requestBody != null) {
                response.setGUID(this.addAssociatedSchemaType(userId, serverName, assetGUID, requestBody, "addSchemaTypeToAsset"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaTypeToAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSchemaTypeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String addAssociatedSchemaType(String userId, String serverName, String assetGUID, SchemaTypeProperties schemaType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID;
        String assetGUIDParameterName = "assetGUID";
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, methodName);
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType, handler.getRepositoryHelper(), handler.getServiceName(), serverName, methodName);
        if (assetGUID != null) {
            handler.setUpAnchorsClassificationFromAnchor(userId, assetGUID, "assetGUID", null, (OpenMetadataAPIGenericBuilder)schemaTypeBuilder, false, false, null, methodName);
        }
        if ((schemaTypeGUID = handler.addSchemaType(userId, null, null, schemaTypeBuilder, null, null, false, false, new Date(), methodName)) != null) {
            handler.uncheckedLinkElementToElement(userId, null, null, assetGUID, "assetGUID", schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, null, methodName);
        }
        return schemaTypeGUID;
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaTypeProperties schemaType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String typeName = OpenMetadataType.SCHEMA_TYPE.typeName;
        if (schemaType.getTypeName() != null) {
            typeName = schemaType.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE.typeName, serviceName, methodName, repositoryHelper);
        return new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.getIsDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), typeGUID, typeName, schemaType.getExtendedProperties(), repositoryHelper, serviceName, serverName);
    }

    private String addAssociatedSchemaAttribute(String userId, String serverName, String assetGUID, String schemaTypeGUID, SchemaAttributeProperties schemaAttribute, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, methodName);
        String schemaAttributeGUID = null;
        if (schemaAttribute != null) {
            int sortOrder = DataItemSortOrder.UNSORTED.getOrdinal();
            if (schemaAttribute.getSortOrder() != null) {
                sortOrder = schemaAttribute.getSortOrder().getOrdinal();
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(schemaAttribute.getQualifiedName(), schemaAttribute.getDisplayName(), schemaAttribute.getDescription(), schemaAttribute.getElementPosition(), schemaAttribute.getMinCardinality(), schemaAttribute.getMaxCardinality(), schemaAttribute.getIsDeprecated(), schemaAttribute.getDefaultValueOverride(), schemaAttribute.getAllowsDuplicateValues(), schemaAttribute.getOrderedValues(), sortOrder, schemaAttribute.getMinimumLength(), schemaAttribute.getLength(), schemaAttribute.getPrecision(), schemaAttribute.getIsNullable(), schemaAttribute.getNativeJavaClass(), schemaAttribute.getAliases(), schemaAttribute.getAdditionalProperties(), null, schemaAttribute.getTypeName(), schemaAttribute.getExtendedProperties(), handler.getRepositoryHelper(), handler.getServiceName(), serverName);
            if (schemaAttribute.getSchemaType() != null) {
                SchemaTypeProperties schemaTypeProperties = schemaAttribute.getSchemaType();
                SchemaTypeBuilder attributeSchemaTypeBuilder = new SchemaTypeBuilder(schemaTypeProperties.getQualifiedName(), schemaTypeProperties.getDisplayName(), schemaTypeProperties.getDescription(), schemaTypeProperties.getVersionNumber(), schemaTypeProperties.getIsDeprecated(), schemaTypeProperties.getAuthor(), schemaTypeProperties.getUsage(), schemaTypeProperties.getEncodingStandard(), schemaTypeProperties.getNamespace(), schemaTypeProperties.getAdditionalProperties(), null, schemaTypeProperties.getTypeName(), schemaTypeProperties.getExtendedProperties(), handler.getRepositoryHelper(), handler.getServiceName(), serverName);
                schemaAttributeBuilder.setSchemaType(userId, attributeSchemaTypeBuilder, methodName);
                if (assetGUID != null) {
                    handler.setUpAnchorsClassificationFromAnchor(userId, assetGUID, "assetGUID", null, (OpenMetadataAPIGenericBuilder)schemaAttributeBuilder, false, false, null, methodName);
                }
                String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
                String qualifiedNameParameterName = "schemaAttribute.getQualifiedName()";
                schemaAttributeGUID = handler.createNestedSchemaAttribute(userId, null, null, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeName, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, schemaAttribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", schemaAttributeBuilder, null, null, false, false, new Date(), methodName);
            } else {
                String parameterName = "attribute schema type";
                restExceptionHandler.handleMissingValue("attribute schema type", methodName);
            }
        }
        return schemaAttributeGUID;
    }

    public VoidResponse attachSchemaTypeToAsset(String serverName, String userId, String assetGUID, String schemaTypeGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        String methodName = "attachSchemaTypeToAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachSchemaTypeToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachSchemaTypeToAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "attachSchemaTypeToAsset");
            handler.attachSchemaTypeToAsset(userId, null, null, assetGUID, "assetGUID", schemaTypeGUID, schemaTypeGUIDParameterName, null, null, false, false, new Date(), "attachSchemaTypeToAsset");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "attachSchemaTypeToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse detachSchemaTypeFromAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "detachSchemaTypeFromAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachSchemaTypeFromAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachSchemaTypeFromAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "detachSchemaTypeFromAsset");
            response.setGUID(handler.detachSchemaTypeFromAsset(userId, null, null, assetGUID, "assetGUID", false, false, new Date(), "detachSchemaTypeFromAsset"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachSchemaTypeFromAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAssetSchemaType(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "deleteAssetSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAssetSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAssetSchemaType");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAssetSchemaType");
            handler.removeAssociatedSchemaType(userId, null, null, assetGUID, "assetGUID", false, false, new Date(), "deleteAssetSchemaType");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteAssetSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaType(String serverName, String userId, String anchorGUID, SchemaTypeProperties requestBody) {
        String methodName = "createSchemaType";
        String anchorGUIDParameterName = "anchorGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaType");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaType");
                String propertiesParameterName = "schemaTypeProperties";
                String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
                this.invalidParameterHandler.validateUserId(userId, "createSchemaType");
                this.invalidParameterHandler.validateObject((Object)requestBody, "schemaTypeProperties", "createSchemaType");
                this.invalidParameterHandler.validateName(requestBody.getQualifiedName(), "schemaTypeProperties.qualifiedName", "createSchemaType");
                SchemaTypeBuilder builder = this.getSchemaTypeBuilder(requestBody, instanceHandler.getRepositoryHelper(userId, serverName, "createSchemaType"), instanceHandler.getServiceName(), serverName, "createSchemaType");
                builder.setEffectivityDates(requestBody.getEffectiveFrom(), requestBody.getEffectiveTo());
                if (anchorGUID != null) {
                    handler.setUpAnchorsClassificationFromAnchor(userId, anchorGUID, "anchorGUID", null, (OpenMetadataAPIGenericBuilder)builder, false, false, null, "createSchemaType");
                }
                response.setGUID(handler.addSchemaType(userId, null, null, builder, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "createSchemaType"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeFromTemplate");
            if (requestBody != null) {
                String templateGUIDParameterName = "templateGUID";
                String propertiesParameterName = "templateProperties";
                String qualifiedNameParameterName = "templateProperties.qualifiedName";
                this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeFromTemplate");
                this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaTypeFromTemplate");
                this.invalidParameterHandler.validateObject((Object)requestBody.getElementProperties(), "templateProperties", "createSchemaTypeFromTemplate");
                this.invalidParameterHandler.validateName(requestBody.getElementProperties().getQualifiedName(), "templateProperties.qualifiedName", "createSchemaTypeFromTemplate");
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaTypeFromTemplate");
                response.setGUID(handler.createSchemaTypeFromTemplate(userId, null, null, templateGUID, requestBody.getElementProperties().getQualifiedName(), requestBody.getElementProperties().getDisplayName(), requestBody.getElementProperties().getDescription(), "createSchemaTypeFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaType(String serverName, String userId, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties requestBody) {
        String methodName = "updateSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaType");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "updateSchemaType");
                String propertiesParameterName = "schemaTypeProperties";
                String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
                this.invalidParameterHandler.validateUserId(userId, "updateSchemaType");
                this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, "updateSchemaType");
                this.invalidParameterHandler.validateObject((Object)requestBody, "schemaTypeProperties", "updateSchemaType");
                if (!isMergeUpdate) {
                    this.invalidParameterHandler.validateName(requestBody.getQualifiedName(), "schemaTypeProperties.qualifiedName", "updateSchemaType");
                }
                SchemaTypeBuilder builder = this.getSchemaTypeBuilder(requestBody, instanceHandler.getRepositoryHelper(userId, serverName, "updateSchemaType"), instanceHandler.getServiceName(), serverName, "updateSchemaType");
                handler.updateSchemaType(userId, null, null, schemaTypeGUID, schemaTypeGUIDParameterName, builder, isMergeUpdate, false, false, null, "updateSchemaType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaTypeParent(String serverName, String userId, String parentElementGUID, String parentElementTypeName, String schemaTypeGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaTypeParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaTypeParent");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "setupSchemaTypeParent");
                if (requestBody.getProperties() != null) {
                    handler.setupSchemaTypeParent(userId, null, null, schemaTypeGUID, parentElementGUID, parentElementTypeName, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, null, "setupSchemaTypeParent");
                } else {
                    handler.setupSchemaTypeParent(userId, null, null, schemaTypeGUID, parentElementGUID, parentElementTypeName, null, null, false, false, null, "setupSchemaTypeParent");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupSchemaTypeParent", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaTypeParent(String serverName, String userId, String parentElementGUID, String parentElementTypeName, String schemaTypeGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaTypeParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaTypeParent");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "clearSchemaTypeParent");
                handler.clearSchemaTypeParent(userId, null, null, schemaTypeGUID, parentElementGUID, parentElementTypeName, false, false, null, "clearSchemaTypeParent");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearSchemaTypeParent", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaElementRelationship(String serverName, String userId, String endOneGUID, String relationshipTypeName, String endTwoGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupSchemaElementRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaElementRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaElementRelationship");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "setupSchemaElementRelationship");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupSchemaElementRelationship(userId, null, null, endOneGUID, endTwoGUID, relationshipTypeName, requestBody.getProperties().getExtendedProperties(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, requestBody.getEffectiveTime(), "setupSchemaElementRelationship");
                } else {
                    handler.setupSchemaElementRelationship(userId, null, null, endOneGUID, endTwoGUID, relationshipTypeName, null, null, null, false, false, requestBody.getEffectiveTime(), "setupSchemaElementRelationship");
                }
            } else {
                handler.setupSchemaElementRelationship(userId, null, null, endOneGUID, endTwoGUID, relationshipTypeName, null, null, null, false, false, null, "setupSchemaElementRelationship");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupSchemaElementRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaElementRelationship(String serverName, String userId, String endOneGUID, String relationshipTypeName, String endTwoGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearSchemaElementRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaElementRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaElementRelationship");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "clearSchemaElementRelationship");
            if (requestBody != null) {
                handler.clearSchemaElementRelationship(userId, null, null, endTwoGUID, endOneGUID, relationshipTypeName, false, false, requestBody.getEffectiveTime(), "clearSchemaElementRelationship");
            } else {
                handler.clearSchemaElementRelationship(userId, null, null, endTwoGUID, endOneGUID, relationshipTypeName, false, false, null, "clearSchemaElementRelationship");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSchemaElementRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaType(String serverName, String userId, String schemaTypeGUID, UpdateRequestBody requestBody) {
        String methodName = "removeSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "removeSchemaType");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, null, null, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, null, null, false, false, requestBody.getEffectiveTime(), "removeSchemaType");
            } else {
                handler.deleteBeanInRepository(userId, null, null, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, null, null, false, false, null, "removeSchemaType");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementsResponse findSchemaType(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypeElementsResponse response = new SchemaTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "findSchemaType");
                response.setElements(handler.findSchemaTypes(userId, null, requestBody.getSearchString(), startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "findSchemaType"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementResponse getSchemaTypeForElement(String serverName, String userId, String parentElementGUID, String parentElementTypeName, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSchemaTypeForElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeForElement");
        SchemaTypeElementResponse response = new SchemaTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeForElement");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeForElement");
                response.setElement((SchemaTypeElement)handler.getSchemaTypeForElement(userId, parentElementGUID, parentElementTypeName, false, false, null, "getSchemaTypeForElement"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeForElement", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementsResponse getSchemaTypeByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getSchemaTypeByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByName");
        SchemaTypeElementsResponse response = new SchemaTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByName");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByName");
                response.setElements(handler.getSchemaTypeByName(userId, null, requestBody.getName(), startFrom, pageSize, false, false, null, "getSchemaTypeByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementResponse getSchemaTypeByGUID(String serverName, String userId, String schemaTypeGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = schemaTypeGUIDParameterName;
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        SchemaTypeElementResponse response = new SchemaTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByGUID");
            if (requestBody != null) {
                response.setElement((SchemaTypeElement)handler.getSchemaType(userId, schemaTypeGUID, schemaTypeGUIDParameterName, false, false, requestBody.getEffectiveTime(), "getSchemaTypeByGUID"));
            } else {
                response.setElement((SchemaTypeElement)handler.getSchemaType(userId, schemaTypeGUID, schemaTypeGUIDParameterName, false, false, null, "getSchemaTypeByGUID"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementHeaderResponse getSchemaTypeParent(String serverName, String userId, String schemaTypeGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeParent");
        ElementHeaderResponse response = new ElementHeaderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeParent");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeParent");
                String guidParameterName = schemaTypeGUIDParameterName;
                this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeParent");
                this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, "getSchemaTypeParent");
                OMRSRepositoryHelper repositoryHelper = handler.getRepositoryHelper();
                RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(handler.getRepositoryHandler(), this.invalidParameterHandler, userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), requestBody.getEffectiveTime(), "getSchemaTypeParent");
                while (iterator.moreToReceive()) {
                    Relationship relationship = iterator.getNext();
                    if (relationship == null || relationship.getType() == null || !repositoryHelper.isTypeOf(handler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName) && !repositoryHelper.isTypeOf(handler.getServiceName(), relationship.getType().getTypeDefName(), OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName)) continue;
                    String parentGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
                    EntityDetail parentEntity = handler.getEntityFromRepository(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.REFERENCEABLE.typeName, null, null, false, false, requestBody.getEffectiveTime(), "getSchemaTypeParent");
                    ElementHeaderConverter headerConverter = new ElementHeaderConverter(repositoryHelper, handler.getServiceName(), serverName);
                    response.setElement((ElementHeader)headerConverter.getNewBean(ElementHeader.class, parentEntity, "getSchemaTypeParent"));
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeParent", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSchemaAttributes(String serverName, String userId, String assetGUID, String parentGUID, List<SchemaAttributeProperties> requestBody) {
        String methodName = "addSchemaAttributes";
        String anchorGUIDParameterName = "assetGUID";
        String schemaElementGUIDParameterName = "parentGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttributes");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && !requestBody.isEmpty()) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttributes");
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "addSchemaAttributes");
                for (SchemaAttributeProperties schemaAttributeProperties : requestBody) {
                    SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, schemaAttributeProperties, handler.getRepositoryHelper(), handler.getServerName(), "addSchemaAttributes");
                    if (assetGUID != null) {
                        handler.setUpAnchorsClassificationFromAnchor(userId, assetGUID, "assetGUID", null, (OpenMetadataAPIGenericBuilder)schemaAttributeBuilder, false, false, null, "addSchemaAttributes");
                    }
                    handler.createNestedSchemaAttribute(userId, null, null, parentGUID, "parentGUID", schemaAttributeProperties.getQualifiedName(), "qualifiedName", schemaAttributeBuilder, schemaAttributeProperties.getEffectiveFrom(), schemaAttributeProperties.getEffectiveTo(), false, false, null, "addSchemaAttributes");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttributes", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addSchemaAttribute(String serverName, String userId, String assetGUID, String parentGUID, SchemaAttributeProperties requestBody) {
        String methodName = "addSchemaAttribute";
        String anchorGUIDParameterName = "assetGUID";
        String schemaElementGUIDParameterName = "parentGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSchemaAttribute");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSchemaAttribute");
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "addSchemaAttribute");
                SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, requestBody, handler.getRepositoryHelper(), handler.getServerName(), "addSchemaAttribute");
                if (assetGUID != null) {
                    handler.setUpAnchorsClassificationFromAnchor(userId, assetGUID, "assetGUID", null, (OpenMetadataAPIGenericBuilder)schemaAttributeBuilder, false, false, null, "addSchemaAttribute");
                }
                response.setGUID(handler.createNestedSchemaAttribute(userId, null, null, parentGUID, "parentGUID", requestBody.getQualifiedName(), "qualifiedName", schemaAttributeBuilder, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "addSchemaAttribute"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttributeFromTemplate(String serverName, String userId, String schemaElementGUID, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaAttributeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttributeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttributeFromTemplate");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "createSchemaAttributeFromTemplate");
                String schemaElementGUIDParameterName = "schemaElementGUID";
                String templateGUIDParameterName = "templateGUID";
                String propertiesParameterName = "templateProperties";
                String qualifiedNameParameterName = "templateProperties.qualifiedName";
                this.invalidParameterHandler.validateUserId(userId, "createSchemaAttributeFromTemplate");
                this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttributeFromTemplate");
                this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaAttributeFromTemplate");
                this.invalidParameterHandler.validateObject((Object)requestBody.getElementProperties(), "templateProperties", "createSchemaAttributeFromTemplate");
                this.invalidParameterHandler.validateName(requestBody.getElementProperties().getQualifiedName(), "templateProperties.qualifiedName", "createSchemaAttributeFromTemplate");
                response.setGUID(handler.createSchemaAttributeFromTemplate(userId, null, null, schemaElementGUID, "schemaElementGUID", templateGUID, requestBody.getElementProperties().getQualifiedName(), requestBody.getElementProperties().getDisplayName(), requestBody.getElementProperties().getDescription(), false, false, null, "createSchemaAttributeFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttributeFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaAttributeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties requestBody) {
        String methodName = "updateSchemaAttribute";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        String propertiesParameterName = "schemaAttributeProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaAttribute");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "updateSchemaAttribute");
                this.invalidParameterHandler.validateUserId(userId, "updateSchemaAttribute");
                this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, "updateSchemaAttribute");
                this.invalidParameterHandler.validateObject((Object)requestBody, "schemaAttributeProperties", "updateSchemaAttribute");
                if (!isMergeUpdate) {
                    this.invalidParameterHandler.validateName(requestBody.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "updateSchemaAttribute");
                }
                SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, requestBody, handler.getRepositoryHelper(), serverName, "updateSchemaAttribute");
                handler.updateSchemaAttribute(userId, null, null, schemaAttributeGUID, schemaAttributeGUIDParameterName, requestBody.getQualifiedName(), "schemaAttributeProperties.qualifiedName", schemaAttributeBuilder, schemaAttributeBuilder.getTypeName(), isMergeUpdate, false, false, null, "updateSchemaAttribute");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private SchemaAttributeBuilder getSchemaAttributeBuilder(String userId, SchemaAttributeProperties schemaAttributeProperties, OMRSRepositoryHelper repositoryHelper, String serverName, String methodName) throws InvalidParameterException {
        String typeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        if (schemaAttributeProperties.getTypeName() != null) {
            typeName = schemaAttributeProperties.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, instanceHandler.getServiceName(), methodName, repositoryHelper);
        int sortOrder = 0;
        if (schemaAttributeProperties.getSortOrder() != null) {
            sortOrder = schemaAttributeProperties.getSortOrder().getOrdinal();
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(schemaAttributeProperties.getQualifiedName(), schemaAttributeProperties.getDisplayName(), schemaAttributeProperties.getDescription(), schemaAttributeProperties.getElementPosition(), schemaAttributeProperties.getMinCardinality(), schemaAttributeProperties.getMaxCardinality(), schemaAttributeProperties.getIsDeprecated(), schemaAttributeProperties.getDefaultValueOverride(), schemaAttributeProperties.getAllowsDuplicateValues(), schemaAttributeProperties.getOrderedValues(), sortOrder, schemaAttributeProperties.getMinimumLength(), schemaAttributeProperties.getLength(), schemaAttributeProperties.getPrecision(), schemaAttributeProperties.getIsNullable(), schemaAttributeProperties.getNativeJavaClass(), schemaAttributeProperties.getAliases(), schemaAttributeProperties.getAdditionalProperties(), typeGUID, typeName, schemaAttributeProperties.getExtendedProperties(), repositoryHelper, instanceHandler.getServiceName(), serverName);
        if (schemaAttributeProperties.getSchemaType() != null) {
            SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaAttributeProperties.getSchemaType(), repositoryHelper, instanceHandler.getServiceName(), serverName, methodName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        }
        return schemaAttributeBuilder;
    }

    public VoidResponse setSchemaElementAsCalculatedValue(String serverName, String userId, String schemaElementGUID, CalculatedValueClassificationRequestBody requestBody) {
        String methodName = "setSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setSchemaElementAsCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setSchemaElementAsCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setSchemaElementAsCalculatedValue");
            if (requestBody != null) {
                InstanceProperties properties = instanceHandler.getRepositoryHelper(userId, serverName, "setSchemaElementAsCalculatedValue").addStringPropertyToInstance(instanceHandler.getServiceName(), null, OpenMetadataProperty.FORMULA.name, requestBody.getFormula(), "setSchemaElementAsCalculatedValue");
                handler.setClassificationInRepository(userId, null, null, schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, properties, false, false, false, requestBody.getEffectiveTime(), "setSchemaElementAsCalculatedValue");
            } else {
                handler.setClassificationInRepository(userId, null, null, schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, null, false, false, false, null, "setSchemaElementAsCalculatedValue");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setSchemaElementAsCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaElementAsCalculatedValue(String serverName, String userId, String schemaElementGUID, UpdateRequestBody requestBody) {
        String methodName = "clearSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaElementAsCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaElementAsCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearSchemaElementAsCalculatedValue");
            if (requestBody != null) {
                handler.removeClassificationFromRepository(userId, null, null, schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, false, false, requestBody.getEffectiveTime(), "clearSchemaElementAsCalculatedValue");
            } else {
                handler.removeClassificationFromRepository(userId, null, null, schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, false, false, null, "clearSchemaElementAsCalculatedValue");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSchemaElementAsCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, UpdateRequestBody requestBody) {
        String methodName = "removeSchemaAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaAttribute");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "removeSchemaAttribute");
                handler.deleteBeanInRepository(userId, null, null, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, false, null, null, false, false, null, "removeSchemaAttribute");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse findSchemaAttributes(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaAttributes");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "findSchemaAttributes");
                response.setElements(handler.findSchemaAttributes(userId, requestBody.getSearchString(), "searchString", OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, null, null, startFrom, pageSize, false, false, null, "findSchemaAttributes"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findSchemaAttributes", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getNestedAttributes(String serverName, String userId, String schemaTypeGUID, int startFrom, int pageSize, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNestedAttributes";
        String elementGUIDParameterName = schemaAttributeGUIDParameterName;
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedAttributes");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getNestedAttributes");
                response.setElements(handler.getAttachedSchemaAttributes(userId, schemaTypeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, startFrom, pageSize, false, false, null, "getNestedAttributes"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getNestedAttributes", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getNestedAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getSchemaAttributesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributesByName");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributesByName");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributesByName");
                response.setElements(handler.getSchemaAttributesByName(userId, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, requestBody.getName(), null, null, startFrom, pageSize, false, false, null, "getSchemaAttributesByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getSchemaAttributesByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaAttributesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeResponse getSchemaAttributeByGUID(String serverName, String userId, String schemaAttributeGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = schemaAttributeGUIDParameterName;
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributeByGUID");
        SchemaAttributeResponse response = new SchemaAttributeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributeByGUID");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributeByGUID");
                response.setElement((SchemaAttributeElement)handler.getSchemaAttribute(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, null, null, false, false, null, "getSchemaAttributeByGUID"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getSchemaAttributeByGUID", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaAttributeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addConnectionToAsset(String serverName, String userId, String assetGUID, OCFConnectionRequestBody requestBody) {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addConnectionToAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addConnectionToAsset");
            if (requestBody != null) {
                String assetSummary = requestBody.getShortDescription();
                Connection connection = requestBody.getConnection();
                if (connection != null) {
                    ConnectionHandler<ConnectionElement> connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "addConnectionToAsset");
                    connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, null, connection, assetSummary, false, false, connectionHandler.getSupportedZones(), new Date(), "addConnectionToAsset");
                } else {
                    String connectionParameterName = "requestBody.getConnection()";
                    restExceptionHandler.handleMissingValue("requestBody.getConnection()", "addConnectionToAsset");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addConnectionToAsset", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addConnectionToAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, SemanticAssignmentProperties requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            if (requestBody == null) {
                handler.saveSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", null, null, false, false, new Date(), "addSemanticAssignment");
            } else if (requestBody.getStatus() == null) {
                handler.saveSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", requestBody.getDescription(), requestBody.getExpression(), 3, requestBody.getConfidence(), requestBody.getCreatedBy(), requestBody.getSteward(), requestBody.getSource(), null, null, false, false, new Date(), "addSemanticAssignment");
            } else {
                handler.saveSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", requestBody.getDescription(), requestBody.getExpression(), requestBody.getStatus().getOrdinal(), requestBody.getConfidence(), requestBody.getCreatedBy(), requestBody.getSteward(), requestBody.getSource(), null, null, false, false, new Date(), "addSemanticAssignment");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String assetElementGUIDParameterName = "assetElementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        String methodName = "addSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addSemanticAssignment");
            handler.saveSemanticAssignment(userId, null, null, assetElementGUID, "assetElementGUID", glossaryTermGUID, "glossaryTermGUID", null, null, false, false, new Date(), "addSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        String assetGUIDParameterName = "assetGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, null, null, assetGUID, "assetGUID", glossaryTermGUID, "glossaryTermGUID", false, false, new Date(), "removeSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSemanticAssignment(String serverName, String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSemanticAssignment";
        String assetElementGUIDParameterName = "assetElementGUID";
        String glossaryTermGUIDParameterName = "glossaryTermGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSemanticAssignment");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeSemanticAssignment");
            handler.removeSemanticAssignment(userId, null, null, assetElementGUID, "assetElementGUID", glossaryTermGUID, "glossaryTermGUID", false, false, new Date(), "removeSemanticAssignment");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addAssetOrigin(String serverName, String userId, String assetGUID, OriginRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String organizationGUIDParameterName = "organizationGUID";
        String businessCapabilityGUIDParameterName = "businessCapabilityGUID";
        String methodName = "addAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addAssetOrigin");
                handler.addAssetOrigin(userId, assetGUID, "assetGUID", requestBody.getOrganizationGUID(), "organizationGUID", requestBody.getBusinessCapabilityGUID(), "businessCapabilityGUID", requestBody.getOtherOriginValues(), null, null, true, false, false, new Date(), "addAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAssetOrigin(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "removeAssetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAssetOrigin");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeAssetOrigin");
                handler.removeAssetOrigin(userId, assetGUID, "assetGUID", false, false, new Date(), "removeAssetOrigin");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeAssetOrigin", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "publishAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "publishAsset");
            handler.publishAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "publishAsset");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "withdrawAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "withdrawAsset");
            handler.withdrawAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "withdrawAsset");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "withdrawAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetZones(String serverName, String userId, String assetGUID, List<String> assetZones) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "updateAssetZones";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetZones");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetZones");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetZones");
            handler.updateAssetZones(userId, assetGUID, "assetGUID", assetZones, true, false, false, new Date(), "updateAssetZones");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateAssetZones", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetOwner(String serverName, String userId, String assetGUID, OwnerRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "updateAssetOwner";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetOwner");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetOwner");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetOwner");
                handler.addOwner(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, requestBody.getOwnerId(), requestBody.getOwnerTypeName(), requestBody.getOwnerPropertyName(), false, false, new Date(), "updateAssetOwner");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateAssetOwner", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateAssetOwner", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, SecurityTagsRequestBody requestBody) {
        String methodName = "addSecurityTags";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetGUID, "assetGUID", "Asset", requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), requestBody.getAccessGroups(), false, false, new Date(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, SecurityTagsRequestBody requestBody) {
        String assetElementGUIDParameterName = "assetElementGUID";
        String assetElementTypeName = "Referenceable";
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
                ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addSecurityTags");
                handler.addSecurityTags(userId, assetElementGUID, "assetElementGUID", "Referenceable", requestBody.getSecurityLabels(), requestBody.getSecurityProperties(), requestBody.getAccessGroups(), false, false, new Date(), "addSecurityTags");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetGUID, "assetGUID", "Asset", false, false, new Date(), "removeSecurityTags");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, NullRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        String assetElementGUIDParameterName = "assetElementGUID";
        String assetElementTypeName = "Referenceable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeSecurityTags");
            handler.removeSecurityTags(userId, assetElementGUID, "assetElementGUID", "Referenceable", false, false, new Date(), "removeSecurityTags");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTemplateClassification(String serverName, String userId, String assetGUID, TemplateClassificationRequestBody requestBody) {
        String methodName = "addTemplateClassification";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTemplateClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTemplateClassification");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "addTemplateClassification");
            if (requestBody != null) {
                handler.addTemplateClassification(userId, assetGUID, "assetGUID", "Asset", requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), false, false, new Date(), "addTemplateClassification");
            } else {
                handler.addTemplateClassification(userId, assetGUID, "assetGUID", "Asset", null, null, null, null, false, false, new Date(), "addTemplateClassification");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addTemplateClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTemplateClassification(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "removeTemplateClassification";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeName = "Asset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTemplateClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTemplateClassification");
            ReferenceableHandler<ReferenceableElement> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeTemplateClassification");
            handler.removeTemplateClassification(userId, assetGUID, "assetGUID", "Asset", false, false, new Date(), "removeTemplateClassification");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeTemplateClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse getAssetsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String nameParameterName = "name";
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            if (requestBody != null) {
                List assets = handler.getAssetsByName(userId, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAssetsByName");
                this.addSupplementaryProperties(assets, handler, "getAssetsByName");
                response.setElements(assets);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getAssetsByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse findAssets(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String searchStringParameter = "searchString";
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            if (requestBody != null) {
                List assets = handler.findAssets(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAssets");
                this.addSupplementaryProperties(assets, handler, "findAssets");
                response.setElements(assets);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findAssets", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementResponse getAssetSummary(String serverName, String userId, String assetGUID) {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetSummary");
        AssetElementResponse response = new AssetElementResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetSummary");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetSummary");
            AssetElement asset = (AssetElement)handler.getBeanFromRepository(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, new Date(), "getAssetSummary");
            if (asset != null) {
                this.getSupplementaryProperties(assetGUID, "assetGUID", (SupplementaryProperties)asset.getProperties(), handler, handler.getRepositoryHelper(), handler.getServiceName(), "getAssetSummary");
            }
            response.setElement(asset);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetSummary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SurveyReportsResponse getSurveyReports(String serverName, String userId, String assetGUID, int startingFrom, int maxPageSize) {
        String methodName = "getSurveyReports";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSurveyReports");
        SurveyReportsResponse response = new SurveyReportsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSurveyReports");
            SurveyReportHandler<SurveyReport> handler = instanceHandler.getSurveyReportHandler(userId, serverName, "getSurveyReports");
            response.setSurveyReports(handler.getSurveyReports(userId, assetGUID, startingFrom, maxPageSize, false, false, new Date(), "getSurveyReports"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSurveyReports", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationsResponse getSurveyReportAnnotations(String serverName, String userId, String surveyReportGUID, int startingFrom, int maximumResults, AnnotationStatusRequestBody requestBody) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AnnotationsResponse response = new AnnotationsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
                AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getDiscoveryReportAnnotations");
                int annotationStatus = AnnotationStatus.UNKNOWN_STATUS.getOrdinal();
                if (requestBody.getAnnotationStatus() != null) {
                    annotationStatus = requestBody.getAnnotationStatus().getOrdinal();
                }
                response.setElements(handler.getSurveyReportAnnotations(userId, surveyReportGUID, annotationStatus, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDiscoveryReportAnnotations", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationsResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults, AnnotationStatusRequestBody requestBody) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AnnotationsResponse response = new AnnotationsResponse();
        AuditLog auditLog = null;
        AnnotationStatus annotationStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (requestBody != null) {
            annotationStatus = requestBody.getAnnotationStatus();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            response.setElements(handler.getExtendedAnnotations(userId, annotationGUID, annotationStatus.getOrdinal(), startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "deleteAsset";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "deleteAsset");
            handler.deleteBeanInRepository(userId, null, null, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, false, null, null, false, false, new Date(), "deleteAsset");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsPeerDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "linkElementsAsPeerDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsPeerDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsPeerDuplicates");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "linkElementsAsPeerDuplicates");
            handler.linkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", true, 1, null, null, null, null, null, instanceHandler.getSupportedZones(userId, serverName, "linkElementsAsPeerDuplicates"), "linkElementsAsPeerDuplicates");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkElementsAsPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementsAsPeerDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementsAsPeerDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementsAsPeerDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementsAsPeerDuplicates");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "unlinkElementsAsPeerDuplicates");
            handler.unlinkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", instanceHandler.getSupportedZones(userId, serverName, "unlinkElementsAsPeerDuplicates"), "unlinkElementsAsPeerDuplicates");
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkElementsAsPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    void maintainSupplementaryProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String elementDomainName, String elementQualifiedName, SupplementaryProperties supplementaryProperties, boolean isMergeUpdate, Date effectiveTime, AssetHandler<AssetElement> assetHandler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (supplementaryProperties != null) {
            assetHandler.maintainSupplementaryProperties(userId, elementGUID, elementGUIDParameterName, elementTypeName, elementDomainName, elementQualifiedName, supplementaryProperties.getDisplayName(), supplementaryProperties.getDisplaySummary(), supplementaryProperties.getDisplayDescription(), supplementaryProperties.getAbbreviation(), supplementaryProperties.getUsage(), isMergeUpdate, false, false, effectiveTime, methodName);
        } else if (!isMergeUpdate) {
            assetHandler.maintainSupplementaryProperties(userId, elementGUID, elementGUIDParameterName, elementTypeName, elementDomainName, elementQualifiedName, null, null, null, null, null, false, false, false, effectiveTime, methodName);
        }
    }

    void addSupplementaryProperties(List<AssetElement> assets, AssetHandler<AssetElement> assetHandler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (assets != null && !assets.isEmpty()) {
            for (AssetElement element : assets) {
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", (SupplementaryProperties)element.getProperties(), assetHandler, assetHandler.getRepositoryHelper(), assetHandler.getServiceName(), methodName);
            }
        }
    }

    private void getSupplementaryProperties(String elementGUID, String elementGUIDParameterName, SupplementaryProperties supplementaryProperties, AssetHandler<AssetElement> assetHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail glossaryEntity = assetHandler.getSupplementaryProperties(elementGUID, elementGUIDParameterName, OpenMetadataType.ASSET.typeName, false, false, new Date(), methodName);
        if (glossaryEntity != null && glossaryEntity.getProperties() != null) {
            supplementaryProperties.setDisplayName(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.DISPLAY_NAME.name, glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setDisplaySummary(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.SUMMARY.name, glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setDisplayDescription(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.DESCRIPTION.name, glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setAbbreviation(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.ABBREVIATION.name, glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setUsage(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.USAGE.name, glossaryEntity.getProperties(), methodName));
        }
    }
}

