/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.CertificationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CertificationTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.LoggerFactory;

public class CertificationRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CertificationRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public CertificationTypeResponse getCertificationTypeByGUID(String serverName, String userId, String certificationTypeGUID) {
        String methodName = "getCertificationTypeByGUID";
        String guidParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByGUID");
        CertificationTypeResponse response = new CertificationTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByGUID");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByGUID");
            response.setElement((CertificationTypeElement)handler.getGovernanceDefinitionByGUID(userId, certificationTypeGUID, "certificationTypeGUID", false, false, new Date(), "getCertificationTypeByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCertificationTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypeResponse getCertificationTypeByDocId(String serverName, String userId, String documentIdentifier) {
        String methodName = "getCertificationTypeByDocId";
        String documentIdParameterName = "documentId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByDocId");
        CertificationTypeResponse response = new CertificationTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByDocId");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByDocId");
            List certificationTypeElements = handler.getGovernanceDefinitionsByName(userId, OpenMetadataType.CERTIFICATION_TYPE.typeName, documentIdentifier, "documentId", 0, 0, false, false, new Date(), "getCertificationTypeByDocId");
            if (certificationTypeElements != null && !certificationTypeElements.isEmpty()) {
                response.setElement((CertificationTypeElement)certificationTypeElements.get(0));
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCertificationTypeByDocId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypesResponse getCertificationTypesByTitle(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "getCertificationTypesByTitle";
        String titleParameterName = "title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypesByTitle");
        CertificationTypesResponse response = new CertificationTypesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypesByTitle");
                CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypesByTitle");
                response.setElements(handler.findGovernanceDefinitions(userId, OpenMetadataType.CERTIFICATION_TYPE.typeName, requestBody.getSearchString(), "title", startFrom, pageSize, false, false, new Date(), "getCertificationTypesByTitle"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getCertificationTypesByTitle", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCertificationTypesByTitle", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CertificationTypesResponse getCertificationTypeByDomainId(String serverName, String userId, int domainIdentifier, int startFrom, int pageSize) {
        String methodName = "getCertificationTypeByDomainId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertificationTypeByDomainId");
        CertificationTypesResponse response = new CertificationTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertificationTypeByDomainId");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "getCertificationTypeByDomainId");
            response.setElements(handler.getGovernanceDefinitionsByDomain(userId, OpenMetadataType.CERTIFICATION_TYPE.typeName, domainIdentifier, startFrom, pageSize, false, false, new Date(), "getCertificationTypeByDomainId"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCertificationTypeByDomainId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse certifyElement(String serverName, String userId, String elementGUID, String certificationTypeGUID, RelationshipRequestBody requestBody) {
        String methodName = "certifyElement";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "certifyElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof CertificationProperties) {
                    CertificationProperties properties = (CertificationProperties)relationshipProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "certifyElement");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "certifyElement");
                    response.setGUID(handler.certifyElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, certificationTypeGUID, "certificationTypeGUID", OpenMetadataType.CERTIFICATION_TYPE.typeName, properties.getCertificateId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getCertifiedBy(), properties.getCertifiedByTypeName(), properties.getCertifiedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getRecipient(), properties.getRecipientTypeName(), properties.getRecipientPropertyName(), properties.getNotes(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "certifyElement"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationTypeProperties.class.getName(), "certifyElement");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "certifyElement", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "certifyElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCertification(String serverName, String userId, String certificationGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateCertification";
        String certificationGUIDParameterName = "certificationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCertification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof CertificationProperties) {
                    CertificationProperties properties = (CertificationProperties)relationshipProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCertification");
                    CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "updateCertification");
                    handler.updateCertification(userId, null, null, certificationGUID, "certificationGUID", properties.getCertificateId(), properties.getStartDate(), properties.getEndDate(), properties.getConditions(), properties.getCertifiedBy(), properties.getCertifiedByTypeName(), properties.getCertifiedByPropertyName(), properties.getCustodian(), properties.getCustodianTypeName(), properties.getCustodianPropertyName(), properties.getRecipient(), properties.getRecipientTypeName(), properties.getRecipientPropertyName(), properties.getNotes(), isMergeUpdate, null, null, false, false, new Date(), "updateCertification");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CertificationProperties.class.getName(), "updateCertification");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateCertification", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateCertification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse decertifyElement(String serverName, String userId, String certificationGUID, RelationshipRequestBody requestBody) {
        String methodName = "decertifyElement";
        String certificationGUIDParameterName = "certificationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "decertifyElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "decertifyElement");
            CertificationHandler<CertificationTypeElement> handler = instanceHandler.getCertificationTypeHandler(userId, serverName, "decertifyElement");
            handler.decertifyElement(userId, null, null, certificationGUID, "certificationGUID", false, false, new Date(), "decertifyElement");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "decertifyElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getCertifiedElements(String serverName, String userId, String certificationTypeGUID, int startFrom, int pageSize) {
        String methodName = "getCertifiedElements";
        String guidParameter = "certificationTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertifiedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertifiedElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getCertifiedElements");
            response.setElements(handler.getAttachedElements(userId, certificationTypeGUID, "certificationTypeGUID", OpenMetadataType.CERTIFICATION_TYPE.typeName, OpenMetadataType.CERTIFICATION_RELATIONSHIP.typeGUID, OpenMetadataType.CERTIFICATION_RELATIONSHIP.typeName, OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getCertifiedElements"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCertifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getCertifications(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicences");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicences");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getLicences");
            response.setElements(handler.getAttachedElements(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CERTIFICATION_RELATIONSHIP.typeGUID, OpenMetadataType.CERTIFICATION_RELATIONSHIP.typeName, OpenMetadataType.CERTIFICATION_TYPE.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getLicences"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLicences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

