/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class ExternalReferenceRESTServices {
    private static final AssetOwnerInstanceHandler instanceHandler = new AssetOwnerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ExternalReferenceRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createExternalReference(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createExternalReference";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalReference");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ExternalReferenceProperties) {
                    ExternalReferenceProperties properties = (ExternalReferenceProperties)referenceableProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalReference");
                    ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "createExternalReference");
                    response.setGUID(handler.createExternalReference(userId, null, null, requestBody.getAnchorGUID(), properties.getQualifiedName(), properties.getDisplayName(), properties.getResourceDescription(), properties.getURI(), properties.getVersion(), properties.getOrganization(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, null, new Date(), "createExternalReference"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceProperties.class.getName(), "createExternalReference");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalReference", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalReference(String serverName, String userId, String externalReferenceGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateExternalReference";
        String guidParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ExternalReferenceProperties) {
                    ExternalReferenceProperties properties = (ExternalReferenceProperties)referenceableProperties;
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalReference");
                    ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "updateExternalReference");
                    handler.updateExternalReference(userId, null, null, externalReferenceGUID, "externalReferenceGUID", properties.getQualifiedName(), properties.getDisplayName(), properties.getResourceDescription(), properties.getURI(), properties.getVersion(), properties.getOrganization(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateExternalReference");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceProperties.class.getName(), "updateExternalReference");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalReference", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteExternalReference(String serverName, String userId, String externalReferenceGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteExternalReference";
        String guidParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteExternalReference");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "deleteExternalReference");
            if (requestBody != null) {
                handler.removeExternalReference(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), externalReferenceGUID, "externalReferenceGUID", false, false, new Date(), "deleteExternalReference");
            } else {
                handler.removeExternalReference(userId, null, null, externalReferenceGUID, "externalReferenceGUID", false, false, new Date(), "deleteExternalReference");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkExternalReferenceToElement(String serverName, String userId, String attachedToGUID, String externalReferenceGUID, RelationshipRequestBody requestBody) {
        String methodName = "linkExternalReferenceToElement";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkExternalReferenceToElement");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "linkExternalReferenceToElement");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ExternalReferenceLinkProperties) {
                    ExternalReferenceLinkProperties properties = (ExternalReferenceLinkProperties)relationshipProperties;
                    OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "linkExternalReferenceToElement");
                    String serviceName = instanceHandler.getServiceName();
                    InstanceProperties relationshipProperties2 = repositoryHelper.addStringPropertyToInstance(serviceName, null, OpenMetadataProperty.REFERENCE_ID.name, properties.getLinkId(), "linkExternalReferenceToElement");
                    relationshipProperties2 = repositoryHelper.addStringPropertyToInstance(serviceName, relationshipProperties2, OpenMetadataProperty.DESCRIPTION.name, properties.getLinkDescription(), "linkExternalReferenceToElement");
                    relationshipProperties2 = repositoryHelper.addStringPropertyToInstance(serviceName, relationshipProperties2, OpenMetadataProperty.PAGES.name, properties.getPages(), "linkExternalReferenceToElement");
                    handler.linkElementToElement(userId, null, null, attachedToGUID, "attachedToGUID", OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, relationshipProperties2, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "linkExternalReferenceToElement");
                } else if (requestBody.getProperties() == null) {
                    handler.linkElementToElement(userId, null, null, attachedToGUID, "attachedToGUID", OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, null, null, (Date)null, new Date(), "linkExternalReferenceToElement");
                }
            } else {
                this.restExceptionHandler.handleInvalidPropertiesObject(ExternalReferenceLinkProperties.class.getName(), "linkExternalReferenceToElement");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkExternalReferenceFromElement(String serverName, String userId, String attachedToGUID, String externalReferenceGUID, RelationshipRequestBody requestBody) {
        String methodName = "unlinkExternalReferenceToElement";
        String elementGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkExternalReferenceToElement");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "unlinkExternalReferenceToElement");
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, null, null, attachedToGUID, "attachedToGUID", OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, new Date(), "unlinkExternalReferenceToElement");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, attachedToGUID, "attachedToGUID", OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, new Date(), "unlinkExternalReferenceToElement");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unlinkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceResponse getExternalReferenceByGUID(String serverName, String userId, String externalReferenceGUID) {
        String methodName = "getExternalReferenceByGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferenceByGUID");
        ExternalReferenceResponse response = new ExternalReferenceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferenceByGUID");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "getExternalReferenceByGUID");
            response.setElement((ExternalReferenceElement)handler.getBeanFromRepository(userId, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, new Date(), "getExternalReferenceByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getExternalReferenceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferencesResponse findExternalReferencesById(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findExternalReferencesById";
        String resourceIdParameterName = "resourceId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findExternalReferencesById");
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findExternalReferencesById");
                ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "findExternalReferencesById");
                response.setElements(handler.findBeans(userId, requestBody.getSearchString(), "resourceId", OpenMetadataType.EXTERNAL_REFERENCE.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), "findExternalReferencesById"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findExternalReferencesById", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findExternalReferencesById", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferencesResponse getExternalReferencesByURL(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getExternalReferencesByURL";
        String urlParameterName = "resourceId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesByURL");
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesByURL");
                ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "getExternalReferencesByURL");
                response.setElements(handler.getExternalReferencesByURL(userId, requestBody.getName(), "resourceId", startFrom, pageSize, false, false, new Date(), "getExternalReferencesByURL"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesByURL", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getExternalReferencesByURL", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferencesResponse retrieveAttachedExternalReferences(String serverName, String userId, String attachedToGUID, int startFrom, int pageSize) {
        String methodName = "retrieveAttachedExternalReferences";
        String guidParameterName = "attachedToGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "retrieveAttachedExternalReferences");
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "retrieveAttachedExternalReferences");
            ExternalReferenceHandler<ExternalReferenceElement> handler = instanceHandler.getExternalReferencesHandler(userId, serverName, "retrieveAttachedExternalReferences");
            response.setElements(handler.getAttachedElements(userId, attachedToGUID, "attachedToGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "retrieveAttachedExternalReferences"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "retrieveAttachedExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getElementsForExternalReference(String serverName, String userId, String externalReferenceGUID, int startFrom, int pageSize) {
        String methodName = "getElementsForExternalReference";
        String guidParameter = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsForExternalReference");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsForExternalReference");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getElementsForExternalReference");
            response.setElements(handler.getAttachedElements(userId, externalReferenceGUID, "externalReferenceGUID", OpenMetadataType.EXTERNAL_REFERENCE.typeName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, OpenMetadataType.REFERENCEABLE.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getElementsForExternalReference"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getElementsForExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

