/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import org.odpi.openmetadata.accessservices.assetowner.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.FolderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewCSVFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.FileSystemRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
public class FileSystemOnboardingResource {
    private FileSystemRESTServices restAPI = new FileSystemRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/file-systems"})
    public GUIDResponse createFileSystemInCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewFileSystemRequestBody requestBody) {
        return this.restAPI.createFileSystemInCatalog(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders/{anchorGUID}"})
    public GUIDListResponse createFolderStructureInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String anchorGUID, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.createFolderStructureInCatalog(serverName, userId, anchorGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders"})
    public GUIDListResponse createFolderStructureInCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.createFolderStructureInCatalog(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/file-systems/{fileSystemGUID}/folders/{fileSystemGUID}/attach"})
    public VoidResponse attachFolderToFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.attachFolderToFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/file-systems/{fileSystemGUID}/folders/{fileSystemGUID}/detach"})
    public VoidResponse detachFolderFromFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.detachFolderFromFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/data-files"})
    public GUIDListResponse addDataFileAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewFileAssetRequestBody requestBody) {
        return this.restAPI.addDataFileAssetToCatalog(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/data-folders"})
    public GUIDListResponse addDataFolderAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewFileAssetRequestBody requestBody) {
        return this.restAPI.addDataFolderAssetToCatalog(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/attach"})
    public VoidResponse attachDataFileAssetToFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.attachDataFileAssetToFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/detach"})
    public VoidResponse detachDataFileAssetFromFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.detachDataFileAssetFromFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/move-to"})
    public VoidResponse moveDataFileInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.moveDataFileInCatalog(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/folders/{folderGUID}/assets/data-folders/{dataFolderGUID}/move-to"})
    public VoidResponse moveDataFolderInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String dataFolderGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.moveDataFolderInCatalog(serverName, userId, folderGUID, dataFolderGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/file-systems/{fileSystemGUID}"})
    public FileSystemResponse getFileSystemByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID) {
        return this.restAPI.getFileSystemByGUID(serverName, userId, fileSystemGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/file-systems/by-name/{uniqueName}"})
    public FileSystemResponse getFileSystemByUniqueName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String uniqueName) {
        return this.restAPI.getFileSystemByUniqueName(serverName, userId, uniqueName);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/file-systems"})
    public GUIDListResponse getFileSystems(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFileSystems(serverName, userId, startingFrom, maxPageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/folders/{folderGUID}"})
    public FolderResponse getFolderByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID) {
        return this.restAPI.getFolderByGUID(serverName, userId, folderGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/folders/by-path-name"})
    public FolderResponse getFolderByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.getFolderByPathName(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{anchorGUID}/folders"})
    public GUIDListResponse getNestedFolders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String anchorGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getNestedFolders(serverName, userId, anchorGUID, startingFrom, maxPageSize);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/folders/{folderGUID}/files"})
    public GUIDListResponse getFolderFiles(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFolderFiles(serverName, userId, folderGUID, startingFrom, maxPageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/data-files/avro"})
    public GUIDListResponse addAvroFileToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewFileAssetRequestBody requestBody) {
        return this.restAPI.addAvroFileToCatalog(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets/data-files/csv"})
    public GUIDListResponse addCSVFileToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewCSVFileAssetRequestBody requestBody) {
        return this.restAPI.addCSVFileToCatalog(serverName, userId, requestBody);
    }
}

