/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
public class AssetOwnerResource {
    private AssetOwnerRESTServices restAPI = new AssetOwnerRESTServices();

    @PostMapping(path={"/assets/{typeName}"})
    public GUIDResponse addAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestBody AssetRequestBody requestBody) {
        return this.restAPI.addAssetToCatalog(serverName, userId, typeName, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schema-type"})
    public GUIDResponse addSchemaToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SchemaRequestBody requestBody) {
        return this.restAPI.addSchemaToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/schemas/{schemaTypeGUID}/schema-attributes"})
    public VoidResponse addSchemaAttributesToSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody List<SchemaAttribute> schemaAttributes) {
        return this.restAPI.addSchemaAttributesToSchema(serverName, userId, schemaTypeGUID, schemaAttributes);
    }

    @PostMapping(path={"/assets/{assetGUID}/connection"})
    public VoidResponse addConnectionToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.addConnectionToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}/delete"})
    VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}/delete"})
    public VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @PathVariable NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin"})
    public VoidResponse addAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OriginRequestBody requestBody) {
        return this.restAPI.addAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin/delete"})
    public VoidResponse removeAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/governance-zones"})
    public VoidResponse updateAssetZones(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody List<String> assetZones) {
        return this.restAPI.updateAssetZones(serverName, userId, assetGUID, assetZones);
    }

    @PostMapping(path={"/assets/{assetGUID}/owner"})
    public VoidResponse updateAssetOwner(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OwnerRequestBody requestBody) {
        return this.restAPI.updateAssetOwner(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetElementGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(String serverName, String userId, String assetGUID, String assetElementGUID, NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/by-name"})
    public AssetsResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getAssetsByName(serverName, userId, name, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-search-string"})
    public AssetsResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String searchString) {
        return this.restAPI.findAssets(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/{assetGUID}/discovery-analysis-reports"})
    public DiscoveryAnalysisReportListResponse getDiscoveryAnalysisReports(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryAnalysisReports(serverName, userId, assetGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, userId, discoveryReportGUID, startingFrom, maximumResults, requestBody);
    }

    @GetMapping(path={"/annotations/{annotationGUID}/annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.getExtendedAnnotations(serverName, userId, annotationGUID, startingFrom, maximumResults, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/delete"})
    public VoidResponse deleteAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.deleteAsset(serverName, userId, assetGUID, requestBody);
    }
}

