/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import org.odpi.openmetadata.accessservices.assetowner.server.ValidValuesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValueConsumersResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ValidValuesResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
public class ValidValuesResource {
    private ValidValuesRESTServices restAPI = new ValidValuesRESTServices();

    @PostMapping(path={"/valid-values/new-set"})
    public GUIDResponse createValidValueSet(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.createValidValueSet(serverName, userId, requestBody);
    }

    @PostMapping(path={"/valid-values/new-definition"})
    public GUIDResponse createValidValueDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.createValidValueDefinition(serverName, userId, setGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/update"})
    public VoidResponse updateValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.updateValidValue(serverName, userId, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/delete"})
    public VoidResponse deleteValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody String qualifiedName) {
        return this.restAPI.deleteValidValue(serverName, userId, validValueGUID, qualifiedName);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}"})
    public VoidResponse attachValidValueToSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.attachValidValueToSet(serverName, userId, setGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}/delete"})
    public VoidResponse detachValidValueFromSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.detachValidValueFromSet(serverName, userId, setGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/implementations/{assetGUID}"})
    public VoidResponse linkValidValueToImplementation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.linkValidValueToImplementation(serverName, userId, validValueGUID, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/classify-as-reference-data"})
    public VoidResponse classifyAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.classifyAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/implementations/{assetGUID}/delete"})
    public VoidResponse unlinkValidValueFromImplementation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.unlinkValidValueFromImplementation(serverName, userId, validValueGUID, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/declassify-as-reference-data"})
    public VoidResponse declassifyAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.declassifyAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/consumers/{consumerGUID}"})
    public VoidResponse assignValidValueToConsumer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String consumerGUID, @RequestBody BooleanRequestBody requestBody) {
        return this.restAPI.assignValidValueToConsumer(serverName, userId, validValueGUID, consumerGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/consumers/{consumerGUID}/delete"})
    public VoidResponse unassignValidValueFromConsumer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String consumerGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.unassignValidValueFromConsumer(serverName, userId, validValueGUID, consumerGUID, requestBody);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}"})
    public ValidValueResponse getValidValueByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID) {
        return this.restAPI.getValidValueByGUID(serverName, userId, validValueGUID);
    }

    @PostMapping(path={"/valid-values/by-name"})
    public ValidValuesResponse getValidValueByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody String validValueName) {
        return this.restAPI.getValidValueByName(serverName, userId, validValueName);
    }

    @PostMapping(path={"/valid-values/by-search-string"})
    public ValidValuesResponse findValidValues(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String searchString) {
        return this.restAPI.findValidValues(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/sets/{validValueSetGUID}/members"})
    public ValidValuesResponse getValidValueSetMembers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueSetMembers(serverName, userId, validValueSetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/set-membership"})
    public ValidValuesResponse getSetsForValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSetsForValidValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/consumers"})
    public ValidValueConsumersResponse getValidValuesConsumers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesConsumers(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/implementations"})
    public AssetsResponse getValidValuesImplementations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesImplementations(serverName, userId, validValueGUID, startFrom, pageSize);
    }
}

