/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.DiscoveryAnalysisReportListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.OriginRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.OwnerRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaAttributesRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.\n\n", externalDocs=@ExternalDocumentation(description="Asset Owner Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-owner/"))
public class AssetOwnerResource {
    private AssetOwnerRESTServices restAPI = new AssetOwnerRESTServices();

    @GetMapping(path={"/assets/sub-types"})
    public NameListResponse getTypesOfAsset(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAsset(serverName, userId);
    }

    @GetMapping(path={"/assets/sub-types/descriptions"})
    public StringMapResponse getTypesOfAssetDescriptions(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAssetDescriptions(serverName, userId);
    }

    @PostMapping(path={"/assets/{typeName}"})
    public GUIDResponse addAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestBody AssetProperties requestBody) {
        return this.restAPI.addAssetToCatalog(serverName, userId, typeName, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/top-level-schema-type-with-attributes"})
    @Deprecated
    public GUIDResponse addCombinedSchemaToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CombinedSchemaRequestBody schemaInformation) {
        return this.restAPI.addCombinedSchemaToAsset(serverName, userId, assetGUID, schemaInformation);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/with-attributes"})
    public GUIDResponse addComplexSchemaToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CombinedSchemaRequestBody schemaInformation) {
        return this.restAPI.addCombinedSchemaToAsset(serverName, userId, assetGUID, schemaInformation);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas"})
    public GUIDResponse addSchemaTypeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SchemaTypeProperties schemaType) {
        return this.restAPI.addSchemaTypeToAsset(serverName, userId, assetGUID, schemaType);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/top-level-schema-type"})
    @Deprecated
    public GUIDResponse addSchemaTypeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SchemaTypeRequestBody schemaType) {
        return this.restAPI.addSchemaTypeToAsset(serverName, userId, assetGUID, schemaType);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{schemaTypeGUID}/attach"})
    public VoidResponse attachSchemaTypeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String schemaTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.attachSchemaTypeToAsset(serverName, userId, assetGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/detach"})
    public GUIDResponse detachSchemaTypeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.detachSchemaTypeFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/top-level-schema-type/delete"})
    public VoidResponse deleteAssetSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteAssetSchemaType(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes/list/deprecated"})
    public VoidResponse addSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody SchemaAttributesRequestBody schemaAttributes) {
        return this.restAPI.addSchemaAttributes(serverName, userId, assetGUID, parentGUID, schemaAttributes);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes/list"})
    public VoidResponse addSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody List<SchemaAttributeProperties> schemaAttributes) {
        return this.restAPI.addSchemaAttributes(serverName, userId, assetGUID, parentGUID, schemaAttributes);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes/deprecated"})
    @Deprecated
    public GUIDResponse addSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody SchemaAttributeRequestBody schemaAttribute) {
        return this.restAPI.addSchemaAttribute(serverName, userId, assetGUID, parentGUID, (SchemaAttributeProperties)schemaAttribute);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes"})
    public GUIDResponse addSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody SchemaAttributeProperties schemaAttribute) {
        return this.restAPI.addSchemaAttribute(serverName, userId, assetGUID, parentGUID, schemaAttribute);
    }

    @PostMapping(path={"/assets/{assetGUID}/connection"})
    public VoidResponse addConnectionToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.addConnectionToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}/delete"})
    public VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}/delete"})
    public VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @PathVariable(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin"})
    public VoidResponse addAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OriginRequestBody requestBody) {
        return this.restAPI.addAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin/delete"})
    public VoidResponse removeAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/publish"})
    public VoidResponse publishAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.publishAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/withdraw"})
    public VoidResponse withdrawAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.withdrawAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/governance-zones"})
    public VoidResponse updateAssetZones(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody List<String> assetZones) {
        return this.restAPI.updateAssetZones(serverName, userId, assetGUID, assetZones);
    }

    @PostMapping(path={"/assets/{assetGUID}/owner"})
    public VoidResponse updateAssetOwner(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OwnerRequestBody requestBody) {
        return this.restAPI.updateAssetOwner(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetElementGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/template-classification"})
    public VoidResponse addTemplateClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) TemplateRequestBody requestBody) {
        return this.restAPI.addTemplateClassification(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/template-classification/delete"})
    public VoidResponse removeTemplateClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTemplateClassification(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/by-name"})
    public AssetElementsResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String name) {
        return this.restAPI.getAssetsByName(serverName, userId, name, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-search-string"})
    public AssetElementsResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String searchString) {
        return this.restAPI.findAssets(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/{assetGUID}"})
    public AssetElementResponse getAssetSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getAssetSummary(serverName, userId, assetGUID);
    }

    @GetMapping(path={"/assets/{assetGUID}/discovery-analysis-reports"})
    public DiscoveryAnalysisReportListResponse getDiscoveryAnalysisReports(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryAnalysisReports(serverName, userId, assetGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, userId, discoveryReportGUID, startingFrom, maximumResults, requestBody);
    }

    @GetMapping(path={"/annotations/{annotationGUID}/annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.getExtendedAnnotations(serverName, userId, annotationGUID, startingFrom, maximumResults, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/delete"})
    public VoidResponse deleteAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteAsset(serverName, userId, assetGUID, requestBody);
    }
}

