/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetowner.server.CertificationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-owner/overview/"))
public class AssetCertificationsResource {
    private final CertificationRESTServices restAPI = new CertificationRESTServices();

    @GetMapping(path={"/certification-types/{certificationTypeGUID}"})
    public CertificationTypeResponse getCertificationTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationTypeGUID) {
        return this.restAPI.getCertificationTypeByGUID(serverName, userId, certificationTypeGUID);
    }

    @GetMapping(path={"/certification-types/by-document-id/{documentIdentifier}"})
    public CertificationTypeResponse getCertificationTypeByDocId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String documentIdentifier) {
        return this.restAPI.getCertificationTypeByDocId(serverName, userId, documentIdentifier);
    }

    @PostMapping(path={"/certification-types/by-title"})
    public CertificationTypesResponse getCertificationTypesByTitle(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.getCertificationTypesByTitle(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/certification-types/by-domain/{domainIdentifier}"})
    public CertificationTypesResponse getCertificationTypeByDomainId(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertificationTypeByDomainId(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{elementGUID}/certification-types/{certificationTypeGUID}/certify"})
    public GUIDResponse certifyElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String certificationTypeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.certifyElement(serverName, userId, elementGUID, certificationTypeGUID, requestBody);
    }

    @PostMapping(path={"/certifications/{certificationGUID}/update"})
    public VoidResponse updateCertification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationGUID, @RequestParam boolean isMergeUpdate, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateCertification(serverName, userId, certificationGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/certifications/{certificationGUID}/delete"})
    public VoidResponse decertifyElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.decertifyElement(serverName, userId, certificationGUID, requestBody);
    }

    @GetMapping(path={"/elements/certifications/{certificationTypeGUID}"})
    public RelatedElementsResponse getCertifiedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String certificationTypeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertifiedElements(serverName, userId, certificationTypeGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/{elementGUID}/certifications"})
    public RelatedElementsResponse getCertifications(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCertifications(serverName, userId, elementGUID, startFrom, pageSize);
    }
}

