/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetowner.server.RelatedElementRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-owner/overview/"))
public class AssetRelationshipsResource {
    private final RelatedElementRESTServices restAPI = new RelatedElementRESTServices();

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}"})
    public VoidResponse setupMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}/delete"})
    public VoidResponse clearMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/more-information/by-descriptive-element/{elementGUID}"})
    public RelatedElementsResponse getMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMoreInformation(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/more-information/by-detail-element/{detailGUID}"})
    public RelatedElementsResponse getDescriptiveElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String detailGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDescriptiveElements(serverName, userId, detailGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}"})
    public VoidResponse setupStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}/delete"})
    public VoidResponse clearStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-commissioned-element/{elementGUID}"})
    public RelatedElementsResponse getStakeholders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholders(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-stakeholder/{stakeholderGUID}"})
    public RelatedElementsResponse getStakeholderCommissionedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String stakeholderGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholderCommissionedElements(serverName, userId, stakeholderGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}"})
    public VoidResponse setupResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}/delete"})
    public VoidResponse clearResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/resource-list/by-assignee/{elementGUID}"})
    public RelatedElementsResponse getResourceList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResourceList(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/resource-list/by-resource/{resourceGUID}"})
    public RelatedElementsResponse getSupportedByResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String resourceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByResource(serverName, userId, resourceGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/catalog-templates/{templateGUID}"})
    public VoidResponse setupCatalogTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String templateGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupCatalogTemplate(serverName, userId, elementGUID, templateGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/catalog-templates/{templateGUID}/delete"})
    public VoidResponse clearCatalogTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String templateGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearCatalogTemplate(serverName, userId, elementGUID, templateGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/catalog-templates/by-assignee/{elementGUID}"})
    public RelatedElementsResponse getCatalogTemplateList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCatalogTemplateList(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/catalog-templates/by-template/{templateGUID}"})
    public RelatedElementsResponse getSupportedByTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByTemplate(serverName, userId, templateGUID, startFrom, pageSize);
    }
}

