/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetowner.server.ValidValuesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-owner/overview/"))
public class ValidValuesOnboardingResource {
    private final ValidValuesRESTServices restAPI = new ValidValuesRESTServices();

    @PostMapping(path={"/valid-values/new-set"})
    public GUIDResponse createValidValueSet(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.createValidValueSet(serverName, userId, requestBody);
    }

    @PostMapping(path={"/valid-values/new-definition/{setGUID}"})
    public GUIDResponse createValidValueDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @RequestParam(required=false, defaultValue="false") boolean isDefaultValue, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.createValidValueDefinition(serverName, userId, setGUID, isDefaultValue, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/update"})
    public VoidResponse updateValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody ValidValuesRequestBody requestBody) {
        return this.restAPI.updateValidValue(serverName, userId, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/delete"})
    public VoidResponse deleteValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody String qualifiedName) {
        return this.restAPI.deleteValidValue(serverName, userId, validValueGUID, qualifiedName);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}"})
    public VoidResponse attachValidValueToSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestParam(required=false, defaultValue="false") boolean isDefaultValue, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.attachValidValueToSet(serverName, userId, setGUID, validValueGUID, isDefaultValue, requestBody);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}/delete"})
    public VoidResponse detachValidValueFromSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.detachValidValueFromSet(serverName, userId, setGUID, validValueGUID, requestBody);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}"})
    public ValidValueResponse getValidValueByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID) {
        return this.restAPI.getValidValueByGUID(serverName, userId, validValueGUID);
    }

    @PostMapping(path={"/valid-values/by-name"})
    public ValidValuesResponse getValidValueByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody String validValueName) {
        return this.restAPI.getValidValueByName(serverName, userId, validValueName, startFrom, pageSize);
    }

    @PostMapping(path={"/valid-values/by-search-string"})
    public ValidValuesResponse findValidValues(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.findValidValues(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/valid-values/sets/{validValueSetGUID}/members"})
    public ValidValuesResponse getValidValueSetMembers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueSetMembers(serverName, userId, validValueSetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/set-membership"})
    public ValidValuesResponse getSetsForValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSetsForValidValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }
}

