/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetowner.server.LicenseRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-owner/overview/"))
public class AssetLicensesResource {
    private final LicenseRESTServices restAPI = new LicenseRESTServices();

    @GetMapping(path={"/license-types/{licenseTypeGUID}"})
    public LicenseTypeResponse getLicenseTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseTypeGUID) {
        return this.restAPI.getLicenseTypeByGUID(serverName, userId, licenseTypeGUID);
    }

    @GetMapping(path={"/license-types/by-document-id/{documentIdentifier}"})
    public LicenseTypeResponse getLicenseTypeByDocId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String documentIdentifier) {
        return this.restAPI.getLicenseTypeByDocId(serverName, userId, documentIdentifier);
    }

    @PostMapping(path={"/license-types/by-title"})
    public LicenseTypesResponse getLicenseTypesByTitle(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.getLicenseTypesByTitle(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/license-types/by-domain/{domainIdentifier}"})
    public LicenseTypesResponse getLicenseTypeByDomainId(@PathVariable String serverName, @PathVariable String userId, @PathVariable int domainIdentifier, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicenseTypeByDomainId(serverName, userId, domainIdentifier, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{elementGUID}/license-types/{licenseTypeGUID}/license"})
    public GUIDResponse licenseElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String licenseTypeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.licenseElement(serverName, userId, elementGUID, licenseTypeGUID, requestBody);
    }

    @PostMapping(path={"/licenses/{licenseGUID}/update"})
    public VoidResponse updateLicense(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseGUID, @RequestParam boolean isMergeUpdate, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateLicense(serverName, userId, licenseGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/licenses/{licenseGUID}/delete"})
    public VoidResponse unlicenseElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.unlicenseElement(serverName, userId, licenseGUID, requestBody);
    }

    @GetMapping(path={"/elements/licenses/{licenseTypeGUID}"})
    public RelatedElementsResponse getLicensedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String licenseTypeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicensedElements(serverName, userId, licenseTypeGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/{elementGUID}/licenses"})
    public RelatedElementsResponse getLicenses(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLicenses(serverName, userId, elementGUID, startFrom, pageSize);
    }
}

