/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.server.AssetOwnerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.AnnotationStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.AnnotationsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeaderResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OriginRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OwnerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SurveyReportsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-owner/users/{userId}"})
@Tag(name="Metadata Access Server: Asset Owner OMAS", description="The Asset Owner OMAS provides APIs and notifications for tools and applications supporting the work of Asset Owners in protecting and enhancing their assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/asset-owner/overview/"))
public class AssetOwnerResource {
    private final AssetOwnerRESTServices restAPI = new AssetOwnerRESTServices();

    @GetMapping(path={"/description"})
    public RegisteredOMAGServiceResponse getServiceDescription(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getServiceDescription(serverName, userId);
    }

    @GetMapping(path={"/assets/sub-types"})
    public NameListResponse getTypesOfAsset(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAsset(serverName, userId);
    }

    @GetMapping(path={"/assets/sub-types/descriptions"})
    public StringMapResponse getTypesOfAssetDescriptions(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAssetDescriptions(serverName, userId);
    }

    @PostMapping(path={"/assets/{typeName}"})
    public GUIDResponse addAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestBody AssetProperties requestBody) {
        return this.restAPI.addAssetToCatalog(serverName, userId, typeName, requestBody);
    }

    @PostMapping(path={"/assets/from-template/{templateGUID}"})
    public GUIDResponse addAssetToCatalogUsingTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateProperties requestBody) {
        return this.restAPI.addAssetToCatalogUsingTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/update"})
    public VoidResponse updateAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam boolean isMergeUpdate, @RequestBody AssetProperties requestBody) {
        return this.restAPI.updateAsset(serverName, userId, assetGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/to-asset/{toAssetGUID}"})
    public GUIDResponse setupRelatedAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @PathVariable String toAssetGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupRelatedAsset(serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/to-asset/{toAssetGUID}/retrieve"})
    public RelationshipElementResponse getAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @PathVariable String toAssetGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAssetRelationship(serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/{relationshipGUID}/update"})
    public VoidResponse updateAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String relationshipGUID, @RequestParam boolean isMergeUpdate, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateAssetRelationship(serverName, userId, relationshipTypeName, relationshipGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/{relationshipGUID}/remove"})
    public VoidResponse clearAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String relationshipGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAssetRelationship(serverName, userId, relationshipTypeName, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/from-asset/{fromAssetGUID}/retrieve/end2"})
    public RelationshipElementsResponse getRelatedAssetsAtEnd2(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String fromAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getRelatedAssetsAtEnd2(serverName, userId, relationshipTypeName, fromAssetGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/to-asset/{toAssetGUID}/retrieve/end1"})
    public RelationshipElementsResponse getRelatedAssetsAtEnd1(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String toAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getRelatedAssetsAtEnd1(serverName, userId, relationshipTypeName, toAssetGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/top-level-schema-type-with-attributes"})
    @Deprecated
    public GUIDResponse addCombinedSchemaToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CombinedSchemaRequestBody schemaInformation) {
        return this.restAPI.addCombinedSchemaToAsset(serverName, userId, assetGUID, schemaInformation);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/with-attributes"})
    public GUIDResponse addComplexSchemaToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody CombinedSchemaRequestBody schemaInformation) {
        return this.restAPI.addCombinedSchemaToAsset(serverName, userId, assetGUID, schemaInformation);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas"})
    public GUIDResponse addSchemaTypeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SchemaTypeProperties schemaType) {
        return this.restAPI.addSchemaTypeToAsset(serverName, userId, assetGUID, schemaType);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{schemaTypeGUID}/attach"})
    public VoidResponse attachSchemaTypeToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String schemaTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.attachSchemaTypeToAsset(serverName, userId, assetGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/detach"})
    public GUIDResponse detachSchemaTypeFromAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.detachSchemaTypeFromAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/delete"})
    public VoidResponse deleteAssetSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteAssetSchemaType(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/schema-types"})
    public GUIDResponse createSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="null") String anchorGUID, @RequestBody SchemaTypeProperties requestBody) {
        return this.restAPI.createSchemaType(serverName, userId, anchorGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/from-template/{templateGUID}"})
    public GUIDResponse createSchemaTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaTypeFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}"})
    public VoidResponse updateSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaTypeProperties requestBody) {
        return this.restAPI.updateSchemaType(serverName, userId, schemaTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}"})
    public VoidResponse setupSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementGUID}/{parentElementTypeName}/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse clearSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @PathVariable String schemaTypeGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSchemaTypeParent(serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{endOneGUID}/relationships/{relationshipTypeName}/schema-elements/{endTwoGUID}"})
    public VoidResponse setupSchemaElementRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endOneGUID, @PathVariable String relationshipTypeName, @PathVariable String endTwoGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupSchemaElementRelationship(serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{endOneGUID}/relationships/{relationshipTypeName}/schema-elements/{endTwoGUID}/remove"})
    public VoidResponse clearSchemaElementRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endOneGUID, @PathVariable String relationshipTypeName, @PathVariable String endTwoGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSchemaElementRelationship(serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/remove"})
    public VoidResponse removeSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.removeSchemaType(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/by-search-string"})
    public SchemaTypeElementsResponse findSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaType(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/parents/{parentElementTypeName}/{parentElementGUID}/schema-types/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeForElement(serverName, userId, parentElementGUID, parentElementTypeName, requestBody);
    }

    @PostMapping(path={"/schema-types/by-name"})
    public SchemaTypeElementsResponse getSchemaTypeByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/retrieve"})
    public SchemaTypeElementResponse getSchemaTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeByGUID(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/parents/schema-types/{schemaTypeGUID}/retrieve"})
    public ElementHeaderResponse getSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaTypeParent(serverName, userId, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes/list"})
    public VoidResponse addSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody List<SchemaAttributeProperties> schemaAttributes) {
        return this.restAPI.addSchemaAttributes(serverName, userId, assetGUID, parentGUID, schemaAttributes);
    }

    @PostMapping(path={"/assets/{assetGUID}/schemas/{parentGUID}/schema-attributes"})
    public GUIDResponse addSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String parentGUID, @RequestBody SchemaAttributeProperties schemaAttribute) {
        return this.restAPI.addSchemaAttribute(serverName, userId, assetGUID, parentGUID, schemaAttribute);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/schema-attributes/from-template/{templateGUID}"})
    public GUIDResponse createSchemaAttributeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaAttributeFromTemplate(serverName, userId, schemaElementGUID, templateGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}"})
    public VoidResponse updateSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaAttributeProperties requestBody) {
        return this.restAPI.updateSchemaAttribute(serverName, userId, schemaAttributeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value"})
    public VoidResponse setSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody CalculatedValueClassificationRequestBody requestBody) {
        return this.restAPI.setSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/is-calculated-value/remove"})
    public VoidResponse clearSchemaElementAsCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.clearSchemaElementAsCalculatedValue(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/remove"})
    public VoidResponse removeSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeSchemaAttribute(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-search-string"})
    public SchemaAttributesResponse findSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSchemaAttributes(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-elements/{parentSchemaElementGUID}/schema-attributes/retrieve"})
    public SchemaAttributesResponse getNestedAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSchemaElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNestedAttributes(serverName, userId, parentSchemaElementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-attributes/by-name"})
    public SchemaAttributesResponse getSchemaAttributesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSchemaAttributesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/retrieve"})
    public SchemaAttributeResponse getSchemaAttributeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSchemaAttributeByGUID(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/connection"})
    public VoidResponse addConnectionToAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OCFConnectionRequestBody requestBody) {
        return this.restAPI.addConnectionToAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) SemanticAssignmentProperties requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}"})
    public VoidResponse addSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/meanings/{glossaryTermGUID}/delete"})
    public VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/meanings/{glossaryTermGUID}/delete"})
    public VoidResponse removeSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String glossaryTermGUID, @PathVariable String assetElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSemanticAssignment(serverName, userId, assetGUID, glossaryTermGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin"})
    public VoidResponse addAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OriginRequestBody requestBody) {
        return this.restAPI.addAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/origin/delete"})
    public VoidResponse removeAssetOrigin(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeAssetOrigin(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/publish"})
    public VoidResponse publishAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.publishAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/withdraw"})
    public VoidResponse withdrawAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.withdrawAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/governance-zones"})
    public VoidResponse updateAssetZones(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody List<String> assetZones) {
        return this.restAPI.updateAssetZones(serverName, userId, assetGUID, assetZones);
    }

    @PostMapping(path={"/assets/{assetGUID}/owner"})
    public VoidResponse updateAssetOwner(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody OwnerRequestBody requestBody) {
        return this.restAPI.updateAssetOwner(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetElementGUID, @RequestBody SecurityTagsRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/attachments/{assetElementGUID}/security-tags/delete"})
    public VoidResponse removeSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeSecurityTags(serverName, userId, assetGUID, assetElementGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/template-classification"})
    public VoidResponse addTemplateClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) TemplateClassificationRequestBody requestBody) {
        return this.restAPI.addTemplateClassification(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/template-classification/delete"})
    public VoidResponse removeTemplateClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTemplateClassification(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/by-name"})
    public AssetElementsResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getAssetsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-search-string"})
    public AssetElementsResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findAssets(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/{assetGUID}"})
    public AssetElementResponse getAssetSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getAssetSummary(serverName, userId, assetGUID);
    }

    @GetMapping(path={"/assets/{assetGUID}/discovery-analysis-reports"})
    public SurveyReportsResponse getDiscoveryAnalysisReports(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getSurveyReports(serverName, userId, assetGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}/annotations"})
    public AnnotationsResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody AnnotationStatusRequestBody requestBody) {
        return this.restAPI.getSurveyReportAnnotations(serverName, userId, discoveryReportGUID, startingFrom, maximumResults, requestBody);
    }

    @GetMapping(path={"/annotations/{annotationGUID}/annotations"})
    public AnnotationsResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody AnnotationStatusRequestBody requestBody) {
        return this.restAPI.getExtendedAnnotations(serverName, userId, annotationGUID, startingFrom, maximumResults, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/delete"})
    public VoidResponse deleteAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/elements/{element1GUID}/duplicate-of/{element2GUID}"})
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String element1GUID, @PathVariable String element2GUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkElementsAsPeerDuplicates(serverName, userId, element1GUID, element2GUID, requestBody);
    }

    @PostMapping(path={"/elements/{element1GUID}/duplicate-of/{element2GUID}/delete"})
    public VoidResponse unlinkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String element1GUID, @PathVariable String element2GUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkElementsAsPeerDuplicates(serverName, userId, element1GUID, element2GUID, requestBody);
    }
}

