/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOwnerEventInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOwnerEventListener;
import org.odpi.openmetadata.accessservices.assetowner.events.AssetOwnerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetowner.ffdc.AssetOwnerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetOwnerOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements AssetOwnerEventInterface {
    private static final Logger log = LoggerFactory.getLogger(AssetOwnerOutTopicClientConnector.class);
    private List<AssetOwnerEventListener> internalEventListeners = new ArrayList<AssetOwnerEventListener>();

    public synchronized void registerListener(String userId, AssetOwnerEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(AssetOwnerErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                AssetOwnerOutTopicEvent eventObject = (AssetOwnerOutTopicEvent)super.getEventBean(event, AssetOwnerOutTopicEvent.class);
                for (AssetOwnerEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

