/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.samples.readavrofile;

import java.io.File;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreConnector;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.http.HttpHelper;

public class AvroFileReaderSample {
    private final String fileName;
    private final String serverName;
    private final String serverURLRoot;
    private final String clientUserId;

    public AvroFileReaderSample(String fileName, String serverName, String serverURLRoot, String clientUserId) {
        this.fileName = fileName;
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    void run() {
        BasicFileStoreConnector connector = this.getConnectorUsingMetadata();
        if (connector == null) {
            connector = this.getConnectorUsingHardCodedConnection();
        }
        this.displayFile(connector);
    }

    private BasicFileStoreConnector getConnectorUsingMetadata() {
        try {
            AssetConsumer client = new AssetConsumer(this.serverName, this.serverURLRoot);
            List knownAssets = client.getAssetsByName(this.clientUserId, this.fileName, 0, 99);
            if (knownAssets != null) {
                System.out.println("The open metadata repositories have returned " + knownAssets.size() + " asset definitions for the requested file name " + this.fileName);
                for (String assetGUID : knownAssets) {
                    if (assetGUID == null) continue;
                    try {
                        return (BasicFileStoreConnector)client.getConnectorForAsset(this.clientUserId, assetGUID);
                    }
                    catch (Throwable error) {
                        System.out.println("Unable to create connector for asset: " + assetGUID);
                    }
                }
            } else {
                System.out.println("The open metadata repositories do not have an asset definition for the requested file name " + this.fileName);
            }
        }
        catch (Throwable error) {
            System.out.println("The connector can not be created from metadata.  Error message is: " + error.getMessage());
        }
        return null;
    }

    private BasicFileStoreConnector getConnectorUsingHardCodedConnection() {
        BasicFileStoreConnector connector = null;
        try {
            AssetConsumer client = new AssetConsumer(this.serverName, this.serverURLRoot);
            connector = (BasicFileStoreConnector)client.getConnectorByConnection(this.clientUserId, this.getHardCodedConnection(this.fileName));
        }
        catch (Throwable error) {
            System.out.println("The connector can not be created with Asset Consumer OMAS.");
        }
        return connector;
    }

    private BasicFileStoreConnector getConnectorWithOCF() {
        BasicFileStoreConnector connector = null;
        try {
            ConnectorBroker broker = new ConnectorBroker();
            connector = (BasicFileStoreConnector)broker.getConnector(this.getHardCodedConnection(this.fileName));
        }
        catch (Throwable error) {
            System.out.println("The connector can not be created with OCF.");
        }
        return connector;
    }

    private Connection getHardCodedConnection(String fileName) {
        String endpointGUID = "85cedbcb-5a38-412d-a40e-df318cc3e48f";
        String connectorTypeGUID = "de8ce2df-b990-4ef5-a716-26f134eddc51";
        String connectionGUID = "87013f6c-bff2-4326-a49e-ea953a925e14";
        String endpointDescription = "File name.";
        String endpointName = "AvroFileStore.Endpoint." + fileName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(Endpoint.getEndpointType());
        endpoint.setGUID("85cedbcb-5a38-412d-a40e-df318cc3e48f");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("File name.");
        endpoint.setAddress(fileName);
        String connectorTypeDescription = "BasicFileStore connector type.";
        String connectorTypeJavaClassName = BasicFileStoreProvider.class.getName();
        String connectorTypeName = "AvroFileStore.ConnectorType.Test";
        ConnectorType connectorType = new ConnectorType();
        connectorType.setType(ConnectorType.getConnectorTypeType());
        connectorType.setGUID("de8ce2df-b990-4ef5-a716-26f134eddc51");
        connectorType.setQualifiedName(connectorTypeName);
        connectorType.setDisplayName(connectorTypeName);
        connectorType.setDescription("BasicFileStore connector type.");
        connectorType.setConnectorProviderClassName(connectorTypeJavaClassName);
        String connectionDescription = "AvroFileStore connection.";
        String connectionName = "AvroFileStore.Connection.Test";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setGUID("87013f6c-bff2-4326-a49e-ea953a925e14");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("AvroFileStore connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(connectorType);
        return connection;
    }

    private void displayFile(BasicFileStoreConnector connector) {
        try {
            System.out.println("===============================");
            System.out.println("Accessing file: " + this.fileName);
            File file = connector.getFile();
            System.out.println("File: " + file.getName());
            System.out.println("Path: " + file.getPath());
            System.out.println("------------------------------------------------------------------------");
            ConnectedAssetProperties assetProperties = connector.getConnectedAssetProperties(this.clientUserId);
            if (assetProperties != null) {
                System.out.println(assetProperties.toString());
            } else {
                System.out.println("No asset properties  ...");
            }
        }
        catch (FileException error) {
            System.out.println("The connector is unable to retrieve the requested record because the file is not valid.");
        }
        catch (Throwable exception) {
            System.out.println("Exception " + exception.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Please specify the file name in the first parameter");
            System.exit(-1);
        }
        String fileName = args[0];
        String serverName = "active-metadata-store";
        String serverURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("Avro File Reader Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            AvroFileReaderSample sample = new AvroFileReaderSample(fileName, serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

