/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.samples.readcsvfile;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileReadException;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreConnector;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.http.HttpHelper;

public class CSVFileReaderSample {
    private final String fileName;
    private final String serverName;
    private final String serverURLRoot;
    private final String clientUserId;

    public CSVFileReaderSample(String fileName, String serverName, String serverURLRoot, String clientUserId) {
        this.fileName = fileName;
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    void run() {
        CSVFileStoreConnector connector = this.getConnectorUsingMetadata();
        if (connector == null) {
            connector = this.getConnectorUsingHardCodedConnection();
        }
        this.displayFile(connector);
    }

    private CSVFileStoreConnector getConnectorUsingMetadata() {
        try {
            AssetConsumer client = new AssetConsumer(this.serverName, this.serverURLRoot);
            List knownAssets = client.findAssets(this.clientUserId, ".*", 2, 4);
            if (knownAssets != null) {
                System.out.println("The open metadata repositories have returned " + knownAssets.size() + " asset definitions for the requested file name " + this.fileName);
                for (String assetGUID : knownAssets) {
                    if (assetGUID == null) continue;
                    try {
                        return (CSVFileStoreConnector)client.getConnectorForAsset(this.clientUserId, assetGUID);
                    }
                    catch (Exception error) {
                        System.out.println("Unable to create connector for asset: " + assetGUID);
                    }
                }
            } else {
                System.out.println("The open metadata repositories do not have an asset definition for the requested file name " + this.fileName);
            }
        }
        catch (Exception error) {
            System.out.println("The connector can not be created from metadata.  Error message is: " + error.getMessage());
        }
        return null;
    }

    private CSVFileStoreConnector getConnectorUsingHardCodedConnection() {
        CSVFileStoreConnector connector = null;
        try {
            AssetConsumer client = new AssetConsumer(this.serverName, this.serverURLRoot);
            connector = (CSVFileStoreConnector)client.getConnectorByConnection(this.clientUserId, this.getHardCodedConnection(this.fileName));
        }
        catch (Exception error) {
            System.out.println("The connector can not be created with Asset Consumer OMAS.");
        }
        return connector;
    }

    private CSVFileStoreConnector getConnectorWithOCF() {
        CSVFileStoreConnector connector = null;
        try {
            ConnectorBroker broker = new ConnectorBroker();
            connector = (CSVFileStoreConnector)broker.getConnector(this.getHardCodedConnection(this.fileName));
        }
        catch (Exception error) {
            System.out.println("The connector can not be created with OCF.");
        }
        return connector;
    }

    private Connection getHardCodedConnection(String fileName) {
        String endpointGUID = "8bf8f5fa-b5d8-40e1-a00e-e4a0c59fd6c0";
        String connectorTypeGUID = "2e1556a3-908f-4303-812d-d81b48b19bab";
        String connectionGUID = "b9af734f-f005-4085-9975-bf46c67a099a";
        String endpointDescription = "File name.";
        String endpointName = "CSVFileStore.Endpoint." + fileName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(Endpoint.getEndpointType());
        endpoint.setGUID("8bf8f5fa-b5d8-40e1-a00e-e4a0c59fd6c0");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("File name.");
        endpoint.setAddress(fileName);
        String connectorTypeDescription = "CSVFileStore connector type.";
        String connectorTypeJavaClassName = CSVFileStoreProvider.class.getName();
        String connectorTypeName = "CSVFileStore.ConnectorType.Test";
        ConnectorType connectorType = new ConnectorType();
        connectorType.setType(ConnectorType.getConnectorTypeType());
        connectorType.setGUID("2e1556a3-908f-4303-812d-d81b48b19bab");
        connectorType.setQualifiedName(connectorTypeName);
        connectorType.setDisplayName(connectorTypeName);
        connectorType.setDescription("CSVFileStore connector type.");
        connectorType.setConnectorProviderClassName(connectorTypeJavaClassName);
        String connectionDescription = "CSVFileStore connection.";
        String connectionName = "CSVFileStore.Connection.Test";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setGUID("b9af734f-f005-4085-9975-bf46c67a099a");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("CSVFileStore connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(connectorType);
        return connection;
    }

    private void displayFile(CSVFileStoreConnector connector) {
        try {
            System.out.println("===============================");
            System.out.println("Accessing file: " + this.fileName);
            long numberOfRecords = connector.getRecordCount();
            long displayedRecords = 10L;
            List columnNames = connector.getColumnNames();
            System.out.println("Number of records: " + numberOfRecords);
            if (numberOfRecords < displayedRecords) {
                displayedRecords = numberOfRecords;
                System.out.println("All records ...");
            } else {
                System.out.println("First 10 records ...");
            }
            System.out.println("------------------------------------------------------------------------");
            System.out.println(columnNames);
            System.out.println("------------------------------------------------------------------------");
            for (long i = 0L; i < displayedRecords; ++i) {
                List columns = connector.readRecord(i);
                System.out.println(columns);
            }
            System.out.println("------------------------------------------------------------------------");
            ConnectedAssetDetails assetProperties = connector.getConnectedAssetProperties(this.clientUserId);
            if (assetProperties != null) {
                AssetUniverse assetUniverse = assetProperties.getAssetUniverse();
                if (assetUniverse != null) {
                    System.out.println("Type Name: " + assetUniverse.getType().getTypeName());
                    System.out.println("Qualified Name: " + assetUniverse.getQualifiedName());
                } else {
                    System.out.println(assetProperties.toString());
                }
            } else {
                System.out.println("No asset properties  ...");
            }
        }
        catch (FileReadException error) {
            System.out.println("The connector is unable to retrieve the requested record because the file is too short.");
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception.getMessage());
        }
    }

    public static void main(String[] args) {
        String fileName = "open-metadata-resources/open-metadata-samples/access-services-samples/asset-management-samples/ContactList.csv";
        String serverName = "active-metadata-store";
        String serverURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        if (args.length > 0) {
            fileName = args[0];
        }
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("CSV File Reader Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println("Reading file: " + fileName);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            CSVFileReaderSample sample = new CSVFileReaderSample(fileName, serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

