/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.apacheatlas;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ApacheAtlasRESTClient;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryAnchorElement;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.GlossaryExchangeService;

public class ApacheAtlasIntegrationConnector
extends CatalogIntegratorConnector
implements AssetManagerEventListener {
    private String glossaryQualifiedName = null;
    private String glossaryGUID = null;
    private String targetRootURL = "localhost:21000";
    private CatalogIntegratorContext myContext = null;
    private GlossaryExchangeService glossaryExchangeService = null;
    private ApacheAtlasRESTClient atlasClient = null;

    public void start() throws ConnectorCheckedException {
        block7: {
            Map configurationProperties;
            super.start();
            String methodName = "start";
            this.myContext = super.getContext();
            EndpointProperties endpoint = this.connectionProperties.getEndpoint();
            if (endpoint != null) {
                this.targetRootURL = endpoint.getAddress();
            }
            if ((configurationProperties = this.connectionProperties.getConfigurationProperties()) != null) {
                this.glossaryQualifiedName = configurationProperties.get("glossaryQualifiedName").toString();
            }
            if (this.auditLog != null) {
                if (this.glossaryQualifiedName == null) {
                    this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_ALL.getMessageDefinition(this.connectorName, this.targetRootURL));
                } else {
                    this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_SPECIFIC.getMessageDefinition(this.connectorName, this.targetRootURL, this.glossaryQualifiedName));
                }
            }
            try {
                this.myContext.registerListener((AssetManagerEventListener)this);
                this.atlasClient = new ApacheAtlasRESTClient("Apache Atlas at " + this.targetRootURL, this.targetRootURL, this.auditLog);
                this.glossaryExchangeService = this.myContext.getGlossaryExchangeService();
            }
            catch (Exception error) {
                if (this.auditLog == null) break block7;
                this.auditLog.logException("start", ApacheAtlasAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.connectorName, this.glossaryQualifiedName), (Throwable)error);
            }
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        try {
            if (this.glossaryQualifiedName == null) {
                List glossaries = this.glossaryExchangeService.findGlossaries(".*", 0, 0, new Date());
                if (glossaries != null) {
                    for (GlossaryElement glossary : glossaries) {
                        this.refreshGlossary(glossary);
                    }
                }
            } else {
                List glossaries = this.glossaryExchangeService.getGlossariesByName(this.glossaryGUID, 0, 0, new Date());
                if (glossaries != null) {
                    for (GlossaryElement glossary : glossaries) {
                        this.refreshGlossary(glossary);
                    }
                }
            }
        }
        catch (InvalidParameterException error) {
            if (this.auditLog != null) {
                this.auditLog.logException("refresh", ApacheAtlasAuditCode.UNABLE_TO_RETRIEVE_TOPICS.getMessageDefinition(this.connectorName, "localhost:9092", ((Object)((Object)error)).getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("refresh", ApacheAtlasAuditCode.UNABLE_TO_RETRIEVE_TOPICS.getMessageDefinition(this.connectorName, "localhost:9092", error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
        }
    }

    private GlossaryElement getGlossaryElement(String glossaryQualifiedName, String methodName) throws ConnectorCheckedException {
        try {
            List egeriaGlossaries = this.glossaryExchangeService.getGlossariesByName(glossaryQualifiedName, 0, 0, null);
            if (egeriaGlossaries != null) {
                for (GlossaryElement glossaryElement : egeriaGlossaries) {
                    String qualifiedName = glossaryElement.getGlossaryProperties().getQualifiedName();
                    if (!glossaryQualifiedName.equals(qualifiedName)) continue;
                    this.glossaryGUID = glossaryElement.getElementHeader().getGUID();
                }
            }
            if (this.glossaryGUID == null && this.auditLog != null) {
                this.auditLog.logMessage(methodName, ApacheAtlasAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.connectorName, glossaryQualifiedName));
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, ApacheAtlasAuditCode.UNABLE_TO_RETRIEVE_TOPICS.getMessageDefinition(this.connectorName, "localhost:9092", error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
        return null;
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        ElementType elementType;
        ElementHeader elementHeader = event.getElementHeader();
        AssetManagerEventType eventType = event.getEventType();
        if (elementHeader != null && (elementType = elementHeader.getType()) != null) {
            ArrayList<String> elementTypeNames = new ArrayList<String>();
            elementTypeNames.add(elementType.getTypeName());
            if (elementType.getSuperTypeNames() != null) {
                elementTypeNames.addAll(elementType.getSuperTypeNames());
            }
            if (elementTypeNames.contains("Glossary")) {
                if (this.glossaryGUID == null) {
                    this.refreshGlossary(eventType, elementHeader);
                } else if (this.glossaryGUID.equals(elementHeader.getGUID())) {
                    this.refreshGlossary(eventType, elementHeader);
                }
            } else if (elementTypeNames.contains("GlossaryTerm")) {
                if (this.glossaryGUID == null) {
                    this.refreshGlossaryTerm(eventType, elementHeader);
                } else {
                    String anchorGUID = this.myContext.getAnchorGUID(elementHeader);
                    if (this.glossaryGUID.equals(anchorGUID)) {
                        this.refreshGlossaryTerm(eventType, elementHeader);
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshGlossary(AssetManagerEventType eventType, ElementHeader glossaryHeader) {
        try {
            GlossaryElement glossary = this.glossaryExchangeService.getGlossaryByGUID(glossaryHeader.getGUID(), new Date());
            if (glossary == null) return;
            this.refreshGlossary(glossary);
            return;
        }
        catch (InvalidParameterException notFound) {
            if (eventType == AssetManagerEventType.ELEMENT_DELETED) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshGlossary(GlossaryElement glossaryElement) {
        AtlasGlossaryAnchorElement atlasGlossaryAnchor;
        if (glossaryElement == null || (atlasGlossaryAnchor = this.atlasClient.syncGlossary(glossaryElement)) != null) {
            // empty if block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshGlossaryTerm(AssetManagerEventType eventType, ElementHeader glossaryTermHeader) {
        try {
            GlossaryTermElement glossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(glossaryTermHeader.getGUID(), new Date());
            if (glossaryTerm == null) return;
            this.refreshGlossaryTerm(glossaryTerm, null);
            return;
        }
        catch (InvalidParameterException notFound) {
            if (eventType == AssetManagerEventType.ELEMENT_DELETED) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshGlossaryTerm(GlossaryTermElement glossaryTerm, AtlasGlossaryAnchorElement atlasGlossaryAnchor) {
        if (glossaryTerm.getElementHeader().getStatus() == ElementStatus.ACTIVE) {
            this.atlasClient.syncGlossaryTerm(glossaryTerm, atlasGlossaryAnchor);
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", ApacheAtlasAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

