/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.apacheatlas;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ApacheAtlasRESTClient;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.NameConflictException;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryAnchorElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryBaseProperties;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryCategoryElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryMemberBaseProperties;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryTermElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasRelatedCategoryHeader;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasRelatedTermHeader;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.GlossaryExchangeService;

public class ApacheAtlasIntegrationConnector
extends CatalogIntegratorConnector
implements AssetManagerEventListener {
    private static final String egeriaGUIDPropertyName = "egeriaGUID";
    private static final String egeriaOwnedPropertyName = "egeriaOwned";
    private static final String atlasGUIDPropertyName = "atlasGUID";
    private String fixedEgeriaGlossaryQualifiedName = null;
    private String fixedEgeriaGlossaryGUID = null;
    private String atlasGlossaryName = null;
    private String targetRootURL = null;
    private CatalogIntegratorContext myContext = null;
    private GlossaryExchangeService glossaryExchangeService = null;
    private ApacheAtlasRESTClient atlasClient = null;

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
        if (this.connectionProperties.getUserId() == null || this.connectionProperties.getClearPassword() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_USER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null) {
            this.fixedEgeriaGlossaryQualifiedName = configurationProperties.get("egeriaGlossaryQualifiedName").toString();
            this.atlasGlossaryName = configurationProperties.get("atlasGlossaryName").toString();
        }
        if (this.auditLog != null) {
            if (this.fixedEgeriaGlossaryQualifiedName == null) {
                this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_ALL_EGERIA_GLOSSARIES.getMessageDefinition(this.connectorName, this.targetRootURL));
            } else {
                this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_SPECIFIC_EGERIA_GLOSSARIES.getMessageDefinition(this.connectorName, this.targetRootURL, this.fixedEgeriaGlossaryQualifiedName));
            }
            if (this.atlasGlossaryName == null) {
                this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_ALL_ATLAS_GLOSSARIES.getMessageDefinition(this.connectorName, this.targetRootURL));
            } else {
                this.auditLog.logMessage("start", ApacheAtlasAuditCode.CONNECTOR_CONFIGURATION_SPECIFIC_ATLAS_GLOSSARIES.getMessageDefinition(this.connectorName, this.targetRootURL, this.atlasGlossaryName));
            }
        }
        if (this.myContext.getAssetManagerName() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_ASSET_MANAGER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            this.atlasClient = new ApacheAtlasRESTClient(this.connectorName, "Apache Atlas", this.targetRootURL, this.connectionProperties.getUserId(), this.connectionProperties.getClearPassword(), this.auditLog);
            this.glossaryExchangeService = this.myContext.getGlossaryExchangeService();
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", ApacheAtlasAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, error.getClass().getName(), this.targetRootURL, "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        try {
            if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
                if (this.fixedEgeriaGlossaryQualifiedName == null) {
                    List glossaries = this.glossaryExchangeService.findGlossaries(".*", 0, 0, new Date());
                    if (glossaries != null) {
                        for (GlossaryElement glossary : glossaries) {
                            this.processEgeriaGlossary(glossary);
                        }
                    }
                } else {
                    GlossaryElement glossary = this.getGlossaryElement(this.fixedEgeriaGlossaryQualifiedName, "refresh");
                    if (glossary != null) {
                        this.processEgeriaGlossary(glossary);
                    } else if (this.auditLog != null) {
                        this.auditLog.logMessage("refresh", ApacheAtlasAuditCode.UNABLE_TO_RETRIEVE_EGERIA_GLOSSARY.getMessageDefinition(this.connectorName, this.fixedEgeriaGlossaryQualifiedName));
                    }
                }
            }
            if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.FROM_THIRD_PARTY) {
                int glossaryCount = 0;
                boolean requestedAtlasGlossaryMissing = this.atlasGlossaryName != null;
                AtlasGlossaryElement atlasGlossary = this.atlasClient.getAtlasGlossary(glossaryCount);
                while (atlasGlossary != null) {
                    if (!this.isEgeriaOwned(atlasGlossary)) {
                        if (this.atlasGlossaryName == null) {
                            this.processAtlasGlossary(atlasGlossary);
                        } else if (this.atlasGlossaryName.equals(atlasGlossary.getName())) {
                            this.processAtlasGlossary(atlasGlossary);
                            requestedAtlasGlossaryMissing = false;
                        }
                    }
                    atlasGlossary = this.atlasClient.getAtlasGlossary(glossaryCount++);
                }
                if (requestedAtlasGlossaryMissing && this.auditLog != null) {
                    this.auditLog.logMessage("refresh", ApacheAtlasAuditCode.UNABLE_TO_RETRIEVE_ATLAS_GLOSSARY.getMessageDefinition(this.connectorName, this.atlasGlossaryName));
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("refresh", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
        }
        if (!this.myContext.isListenerRegistered() && this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                this.myContext.registerListener((AssetManagerEventListener)this);
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", ApacheAtlasAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
            }
        }
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        block11: {
            try {
                ElementHeader elementHeader = event.getElementHeader();
                if (elementHeader != null && !this.isAtlasOwnedElement(elementHeader)) {
                    if (this.myContext.isTypeOf(elementHeader, "Glossary")) {
                        if (this.validGlossaryElement(elementHeader)) {
                            this.processEgeriaGlossary(this.glossaryExchangeService.getGlossaryByGUID(elementHeader.getGUID(), null));
                        }
                    } else if (this.myContext.isTypeOf(elementHeader, "GlossaryTerm")) {
                        if (this.validTermElement(elementHeader)) {
                            this.processEgeriaGlossaryTerm(this.glossaryExchangeService.getGlossaryTermByGUID(elementHeader.getGUID(), null));
                        }
                    } else if (this.myContext.isTypeOf(elementHeader, "GlossaryCategory") && this.validCategoryElement(elementHeader)) {
                        this.processEgeriaGlossaryCategory(this.glossaryExchangeService.getGlossaryCategoryByGUID(elementHeader.getGUID(), null));
                    }
                }
            }
            catch (InvalidParameterException elementHeader) {
            }
            catch (Exception error) {
                String methodName = "processEvent";
                if (this.auditLog == null) break block11;
                this.auditLog.logException("processEvent", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()), (Throwable)error);
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", ApacheAtlasAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName, this.targetRootURL));
        }
        super.disconnect();
    }

    private boolean validGlossaryElement(ElementHeader elementHeader) throws ConnectorCheckedException {
        String methodName = "validGlossaryElement";
        if (this.fixedEgeriaGlossaryQualifiedName != null) {
            GlossaryElement glossaryElement;
            String glossaryGUID = elementHeader.getGUID();
            if (this.fixedEgeriaGlossaryGUID == null && (glossaryElement = this.getGlossaryElement(this.fixedEgeriaGlossaryQualifiedName, "validGlossaryElement")) != null) {
                this.fixedEgeriaGlossaryGUID = glossaryElement.getElementHeader().getGUID();
            }
            return glossaryGUID.equals(this.fixedEgeriaGlossaryGUID);
        }
        return true;
    }

    private boolean validTermElement(ElementHeader elementHeader) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "validTermElement";
        if (this.fixedEgeriaGlossaryQualifiedName != null) {
            GlossaryElement glossary = this.glossaryExchangeService.getGlossaryForTerm(elementHeader.getGUID(), new Date());
            if (glossary != null) {
                GlossaryElement fixedGlossaryElement;
                if (this.fixedEgeriaGlossaryGUID == null && (fixedGlossaryElement = this.getGlossaryElement(this.fixedEgeriaGlossaryQualifiedName, "validTermElement")) != null) {
                    this.fixedEgeriaGlossaryGUID = fixedGlossaryElement.getElementHeader().getGUID();
                }
                return glossary.getElementHeader().getGUID().equals(this.fixedEgeriaGlossaryGUID);
            }
            return false;
        }
        return true;
    }

    private boolean validCategoryElement(ElementHeader elementHeader) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "validCategoryElement";
        if (this.fixedEgeriaGlossaryQualifiedName != null) {
            GlossaryElement glossary = this.glossaryExchangeService.getGlossaryForCategory(elementHeader.getGUID(), new Date());
            if (glossary != null) {
                GlossaryElement fixedGlossaryElement;
                if (this.fixedEgeriaGlossaryGUID == null && (fixedGlossaryElement = this.getGlossaryElement(this.fixedEgeriaGlossaryQualifiedName, "validCategoryElement")) != null) {
                    this.fixedEgeriaGlossaryGUID = fixedGlossaryElement.getElementHeader().getGUID();
                }
                return glossary.getElementHeader().getGUID().equals(this.fixedEgeriaGlossaryGUID);
            }
            return false;
        }
        return true;
    }

    private String getAtlasGUID(MetadataElement metadataElement) {
        if (metadataElement.getCorrelationHeaders() != null) {
            for (MetadataCorrelationHeader metadataCorrelationHeader : metadataElement.getCorrelationHeaders()) {
                if (!metadataCorrelationHeader.getExternalIdentifierName().equals(atlasGUIDPropertyName)) continue;
                return metadataCorrelationHeader.getExternalIdentifier();
            }
        }
        return null;
    }

    private String retryGetAtlasGUID(GlossaryCategoryElement metadataElement) {
        try {
            GlossaryCategoryElement refreshedCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(metadataElement.getElementHeader().getGUID(), new Date());
            return this.getAtlasGUID((MetadataElement)refreshedCategory);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String retryGetAtlasGUID(GlossaryTermElement metadataElement) {
        try {
            GlossaryTermElement refreshedTerm = this.glossaryExchangeService.getGlossaryTermByGUID(metadataElement.getElementHeader().getGUID(), new Date());
            return this.getAtlasGUID((MetadataElement)refreshedTerm);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getEgeriaGUID(AtlasGlossaryBaseProperties atlasElement) {
        Object guidProperty;
        if (atlasElement.getAdditionalAttributes() != null && (guidProperty = atlasElement.getAdditionalAttributes().get(egeriaGUIDPropertyName)) != null) {
            return guidProperty.toString();
        }
        return null;
    }

    private boolean isAtlasOwnedElement(ElementHeader elementHeader) {
        return elementHeader.getOrigin().getHomeMetadataCollectionId() != null && elementHeader.getOrigin().getHomeMetadataCollectionId().equals(this.myContext.getAssetManagerGUID());
    }

    private boolean isEgeriaOwned(AtlasGlossaryBaseProperties properties) {
        Map<String, Object> additionalAttributes = properties.getAdditionalAttributes();
        return additionalAttributes != null && additionalAttributes.containsKey(egeriaOwnedPropertyName) && "true".equals(additionalAttributes.get(egeriaOwnedPropertyName).toString());
    }

    private void processEgeriaGlossary(GlossaryElement egeriaGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processEgeriaGlossary";
        if (egeriaGlossary != null) {
            if (this.isAtlasOwnedElement(egeriaGlossary.getElementHeader())) {
                String atlasGlossaryGUID = this.getAtlasGUID((MetadataElement)egeriaGlossary);
                if (atlasGlossaryGUID != null) {
                    this.refreshAtlasGlossaryInEgeria(this.atlasClient.getAtlasGlossary(atlasGlossaryGUID), egeriaGlossary);
                } else if (this.auditLog != null) {
                    this.auditLog.logMessage("processEgeriaGlossary", ApacheAtlasAuditCode.EGERIA_GUID_MISSING.getMessageDefinition("Glossary", egeriaGlossary.getElementHeader().getGUID()));
                }
            } else {
                this.refreshEgeriaGlossaryInAtlas(egeriaGlossary);
            }
            this.processEgeriaGlossaryCategories(egeriaGlossary);
            this.processEgeriaGlossaryTerms(egeriaGlossary);
        }
    }

    private void processEgeriaGlossaryTerms(GlossaryElement glossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (glossary != null) {
            int startFrom = 0;
            List egeriaGlossaryTerms = this.glossaryExchangeService.getTermsForGlossary(glossary.getElementHeader().getGUID(), startFrom, this.myContext.getMaxPageSize(), new Date());
            while (egeriaGlossaryTerms != null) {
                for (GlossaryTermElement egeriaGlossaryTerm : egeriaGlossaryTerms) {
                    this.processEgeriaGlossaryTerm(egeriaGlossaryTerm);
                }
                egeriaGlossaryTerms = this.glossaryExchangeService.getTermsForGlossary(glossary.getElementHeader().getGUID(), startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
            }
        }
    }

    private void processEgeriaGlossaryTerm(GlossaryTermElement glossaryTermElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (glossaryTermElement != null) {
            String methodName = "processEgeriaGlossaryTerm";
            if (this.isAtlasOwnedElement(glossaryTermElement.getElementHeader())) {
                String atlasGlossaryTermGUID = this.getAtlasGUID((MetadataElement)glossaryTermElement);
                if (atlasGlossaryTermGUID != null) {
                    this.refreshAtlasGlossaryTermInEgeria(this.atlasClient.getAtlasGlossaryTerm(atlasGlossaryTermGUID), glossaryTermElement);
                } else if (this.auditLog != null) {
                    this.auditLog.logMessage("processEgeriaGlossaryTerm", ApacheAtlasAuditCode.EGERIA_GUID_MISSING.getMessageDefinition("GlossaryTerm", glossaryTermElement.getElementHeader().getGUID()));
                }
            } else {
                this.refreshEgeriaGlossaryTermInAtlas(glossaryTermElement, this.getDestinationAtlasGlossary(glossaryTermElement.getElementHeader()));
            }
        }
    }

    private void processEgeriaGlossaryCategories(GlossaryElement egeriaGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (egeriaGlossary != null) {
            int startFrom = 0;
            List egeriaGlossaryCategories = this.glossaryExchangeService.getCategoriesForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom, this.myContext.getMaxPageSize(), new Date());
            while (egeriaGlossaryCategories != null) {
                for (GlossaryCategoryElement egeriaGlossaryCategory : egeriaGlossaryCategories) {
                    this.processEgeriaGlossaryCategory(egeriaGlossaryCategory);
                }
                egeriaGlossaryCategories = this.glossaryExchangeService.getCategoriesForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
            }
        }
    }

    private void processEgeriaGlossaryCategory(GlossaryCategoryElement glossaryCategoryElement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processEgeriaGlossaryCategory";
        if (this.isAtlasOwnedElement(glossaryCategoryElement.getElementHeader())) {
            String atlasGlossaryCategoryGUID = this.getAtlasGUID((MetadataElement)glossaryCategoryElement);
            if (atlasGlossaryCategoryGUID != null) {
                this.refreshAtlasGlossaryCategoryInEgeria(this.atlasClient.getAtlasGlossaryCategory(atlasGlossaryCategoryGUID), glossaryCategoryElement);
            } else if (this.auditLog != null) {
                this.auditLog.logMessage("processEgeriaGlossaryCategory", ApacheAtlasAuditCode.EGERIA_GUID_MISSING.getMessageDefinition("GlossaryCategory", glossaryCategoryElement.getElementHeader().getGUID()));
            }
        } else {
            this.refreshEgeriaGlossaryCategoryInAtlas(this.getDestinationAtlasGlossary(glossaryCategoryElement.getElementHeader()), glossaryCategoryElement);
        }
    }

    private void processAtlasGlossary(AtlasGlossaryElement atlasGlossaryElement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processAtlasGlossary";
        String egeriaGlossaryGUID = this.getEgeriaGUID(atlasGlossaryElement);
        if (egeriaGlossaryGUID == null) {
            this.createAtlasGlossaryInEgeria(atlasGlossaryElement);
            this.processAtlasGlossaryCategories(atlasGlossaryElement);
            this.processAtlasGlossaryTerms(atlasGlossaryElement);
        } else if (this.isEgeriaOwned(atlasGlossaryElement)) {
            GlossaryElement egeriaGlossaryElement;
            block11: {
                egeriaGlossaryElement = null;
                try {
                    egeriaGlossaryElement = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
                }
                catch (InvalidParameterException missingGlossary) {
                    if (this.auditLog == null) break block11;
                    this.auditLog.logMessage("processAtlasGlossary", ApacheAtlasAuditCode.EGERIA_GLOSSARY_DELETED.getMessageDefinition(egeriaGlossaryGUID, atlasGlossaryElement.getName()));
                }
            }
            if (egeriaGlossaryElement == null) {
                this.atlasClient.deleteAtlasGlossary(atlasGlossaryElement);
            } else {
                this.refreshEgeriaGlossaryInAtlas(egeriaGlossaryElement);
                this.processEgeriaGlossaryCategories(egeriaGlossaryElement);
                this.processEgeriaGlossaryTerms(egeriaGlossaryElement);
            }
        } else {
            AtlasGlossaryElement owningAtlasGlossary = atlasGlossaryElement;
            GlossaryElement egeriaGlossaryElement = null;
            try {
                egeriaGlossaryElement = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
            }
            catch (InvalidParameterException missingGlossary) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processAtlasGlossary", ApacheAtlasAuditCode.REPLACING_EGERIA_GLOSSARY.getMessageDefinition(egeriaGlossaryGUID, atlasGlossaryElement.getName(), this.connectorName));
                }
                owningAtlasGlossary = this.clearEgeriaGUIDFromGlossary(atlasGlossaryElement);
            }
            this.refreshAtlasGlossaryInEgeria(owningAtlasGlossary, egeriaGlossaryElement);
            this.processAtlasGlossaryCategories(owningAtlasGlossary);
            this.processAtlasGlossaryTerms(owningAtlasGlossary);
        }
    }

    private void processAtlasGlossaryTerms(AtlasGlossaryElement atlasGlossaryElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (atlasGlossaryElement != null && atlasGlossaryElement.getTerms() != null) {
            for (AtlasRelatedTermHeader relatedAtlasTerm : atlasGlossaryElement.getTerms()) {
                this.processAtlasGlossaryTerm(this.atlasClient.getAtlasGlossaryTerm(relatedAtlasTerm.getTermGuid()), atlasGlossaryElement);
            }
        }
    }

    private void processAtlasGlossaryTerm(AtlasGlossaryTermElement atlasGlossaryTerm, AtlasGlossaryElement atlasGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "processAtlasGlossaryTerm";
        String egeriaTermGUID = this.getEgeriaGUID(atlasGlossaryTerm);
        if (egeriaTermGUID == null) {
            this.createAtlasGlossaryTermInEgeria(atlasGlossaryTerm, this.getEgeriaDestinationGlossaryForElement(atlasGlossaryTerm));
        } else if (this.isEgeriaOwned(atlasGlossaryTerm)) {
            GlossaryTermElement egeriaGlossaryTerm;
            block13: {
                egeriaGlossaryTerm = null;
                try {
                    egeriaGlossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(egeriaTermGUID, new Date());
                }
                catch (InvalidParameterException missingTerm) {
                    if (this.auditLog == null) break block13;
                    this.auditLog.logMessage("processAtlasGlossaryTerm", ApacheAtlasAuditCode.EGERIA_GLOSSARY_TERM_DELETED.getMessageDefinition(egeriaTermGUID, atlasGlossaryTerm.getName()));
                }
            }
            if (egeriaGlossaryTerm == null) {
                this.atlasClient.deleteAtlasGlossaryTerm(atlasGlossaryTerm);
            } else {
                this.refreshEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossary);
            }
        } else {
            AtlasGlossaryTermElement owningAtlasTerm = atlasGlossaryTerm;
            GlossaryTermElement egeriaGlossaryTerm = null;
            try {
                egeriaGlossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(egeriaTermGUID, new Date());
            }
            catch (InvalidParameterException missingTerm) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processAtlasGlossaryTerm", ApacheAtlasAuditCode.REPLACING_EGERIA_GLOSSARY_TERM.getMessageDefinition(egeriaTermGUID, atlasGlossaryTerm.getName(), this.connectorName));
                }
                owningAtlasTerm = this.clearEgeriaGUIDFromTerm(atlasGlossaryTerm);
            }
            if (egeriaGlossaryTerm == null) {
                this.createAtlasGlossaryTermInEgeria(owningAtlasTerm, this.getEgeriaDestinationGlossaryForElement(owningAtlasTerm));
            } else {
                this.refreshAtlasGlossaryTermInEgeria(owningAtlasTerm, egeriaGlossaryTerm);
            }
        }
    }

    private void processAtlasGlossaryCategories(AtlasGlossaryElement atlasGlossaryElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (atlasGlossaryElement != null && atlasGlossaryElement.getCategories() != null) {
            for (AtlasRelatedCategoryHeader relatedAtlasCategory : atlasGlossaryElement.getCategories()) {
                this.processAtlasGlossaryCategory(this.atlasClient.getAtlasGlossaryCategory(relatedAtlasCategory.getCategoryGuid()), atlasGlossaryElement);
            }
        }
    }

    private void processAtlasGlossaryCategory(AtlasGlossaryCategoryElement atlasGlossaryCategory, AtlasGlossaryElement atlasGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "processAtlasGlossaryCategory";
        String egeriaCategoryGUID = this.getEgeriaGUID(atlasGlossaryCategory);
        if (egeriaCategoryGUID == null) {
            this.createAtlasGlossaryCategoryInEgeria(atlasGlossaryCategory, this.getEgeriaDestinationGlossaryForElement(atlasGlossaryCategory));
        } else if (this.isEgeriaOwned(atlasGlossaryCategory)) {
            GlossaryCategoryElement egeriaGlossaryCategory;
            block13: {
                egeriaGlossaryCategory = null;
                try {
                    egeriaGlossaryCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(egeriaCategoryGUID, new Date());
                }
                catch (InvalidParameterException missingCategory) {
                    if (this.auditLog == null) break block13;
                    this.auditLog.logMessage("processAtlasGlossaryCategory", ApacheAtlasAuditCode.EGERIA_GLOSSARY_CATEGORY_DELETED.getMessageDefinition(egeriaCategoryGUID, atlasGlossaryCategory.getName()));
                }
            }
            if (egeriaGlossaryCategory == null) {
                this.atlasClient.deleteAtlasGlossaryCategory(atlasGlossaryCategory);
            } else {
                this.refreshEgeriaGlossaryCategoryInAtlas(atlasGlossary, egeriaGlossaryCategory);
            }
        } else {
            AtlasGlossaryCategoryElement owningAtlasCategory = atlasGlossaryCategory;
            GlossaryCategoryElement egeriaGlossaryCategory = null;
            try {
                egeriaGlossaryCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(egeriaCategoryGUID, new Date());
            }
            catch (InvalidParameterException missingCategory) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processAtlasGlossaryCategory", ApacheAtlasAuditCode.REPLACING_EGERIA_GLOSSARY_CATEGORY.getMessageDefinition(egeriaCategoryGUID, atlasGlossaryCategory.getName(), this.connectorName));
                }
                owningAtlasCategory = this.clearEgeriaGUIDFromCategory(atlasGlossaryCategory);
            }
            if (egeriaGlossaryCategory == null) {
                this.createAtlasGlossaryCategoryInEgeria(owningAtlasCategory, this.getEgeriaDestinationGlossaryForElement(owningAtlasCategory));
            } else {
                this.refreshAtlasGlossaryCategoryInEgeria(owningAtlasCategory, egeriaGlossaryCategory);
            }
        }
    }

    private void refreshEgeriaGlossaryInAtlas(GlossaryElement egeriaGlossaryElement) {
        if (egeriaGlossaryElement != null) {
            AtlasGlossaryElement atlasGlossary = this.getDestinationAtlasGlossary(egeriaGlossaryElement.getElementHeader());
            if (this.auditLog != null) {
                String methodName = "refreshEgeriaGlossaryTermInAtlas";
                String atlasGlossaryName = null;
                if (atlasGlossary != null) {
                    atlasGlossaryName = atlasGlossary.getName();
                }
                this.auditLog.logMessage("refreshEgeriaGlossaryTermInAtlas", ApacheAtlasAuditCode.SYNC_EGERIA_GLOSSARY.getMessageDefinition(this.connectorName, egeriaGlossaryElement.getGlossaryProperties().getDisplayName(), egeriaGlossaryElement.getElementHeader().getGUID(), atlasGlossaryName));
            }
        }
    }

    private void refreshEgeriaGlossaryTermInAtlas(GlossaryTermElement egeriaGlossaryTerm, AtlasGlossaryElement atlasGlossaryDestination) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaGlossaryTermInAtlas";
        if (egeriaGlossaryTerm != null) {
            String atlasGlossaryTermGUID = this.getAtlasGUID((MetadataElement)egeriaGlossaryTerm);
            AtlasGlossaryTermElement atlasGlossaryTerm = null;
            if (atlasGlossaryTermGUID == null) {
                String atlasGlossaryGUID;
                GlossaryElement egeriaGlossary;
                block16: {
                    egeriaGlossary = null;
                    try {
                        egeriaGlossary = this.glossaryExchangeService.getGlossaryForTerm(egeriaGlossaryTerm.getElementHeader().getGUID(), new Date());
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block16;
                        this.auditLog.logException("refreshEgeriaGlossaryTermInAtlas", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refreshEgeriaGlossaryTermInAtlas", error.getMessage()), (Throwable)error);
                    }
                }
                if (egeriaGlossary != null && (atlasGlossaryGUID = this.getAtlasGUID((MetadataElement)egeriaGlossary)) != null) {
                    atlasGlossaryTerm = this.getAtlasGlossaryTermProperties(egeriaGlossaryTerm, null, atlasGlossaryDestination);
                    int termNameIndex = 1;
                    while (atlasGlossaryTermGUID == null) {
                        try {
                            atlasGlossaryTermGUID = this.atlasClient.createAtlasGlossaryTerm(atlasGlossaryTerm);
                        }
                        catch (NameConflictException conflictException) {
                            atlasGlossaryTermGUID = this.retryGetAtlasGUID(egeriaGlossaryTerm);
                            if (atlasGlossaryTermGUID != null) continue;
                            if (this.auditLog != null) {
                                this.auditLog.logMessage("refreshEgeriaGlossaryTermInAtlas", ApacheAtlasAuditCode.TERM_ALREADY_EXISTS.getMessageDefinition(atlasGlossaryTerm.getName()));
                            }
                            atlasGlossaryTerm.setName(egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName() + " (" + termNameIndex++ + ")");
                        }
                    }
                    if (this.auditLog != null) {
                        String atlasTermName = atlasGlossaryTermGUID;
                        if (atlasGlossaryTerm != null) {
                            atlasTermName = atlasGlossaryTerm.getName();
                        }
                        this.auditLog.logMessage("refreshEgeriaGlossaryTermInAtlas", ApacheAtlasAuditCode.SYNC_EGERIA_GLOSSARY_TERM.getMessageDefinition(this.connectorName, egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), egeriaGlossaryTerm.getElementHeader().getGUID(), atlasTermName));
                    }
                    atlasGlossaryTerm.setGuid(atlasGlossaryTermGUID);
                }
            }
            if (atlasGlossaryTermGUID != null) {
                if (atlasGlossaryTerm == null) {
                    atlasGlossaryTerm = this.getAtlasGlossaryTermProperties(egeriaGlossaryTerm, atlasGlossaryTermGUID, atlasGlossaryDestination);
                }
                this.ensureAtlasExternalIdentifier((MetadataElement)egeriaGlossaryTerm, atlasGlossaryTermGUID);
                List categories = this.glossaryExchangeService.getCategoriesForTerm(egeriaGlossaryTerm.getElementHeader().getGUID(), 0, this.myContext.getMaxPageSize(), new Date());
                if (categories != null) {
                    ArrayList<AtlasRelatedCategoryHeader> atlasCategories = new ArrayList<AtlasRelatedCategoryHeader>();
                    for (GlossaryCategoryElement category : categories) {
                        String atlasCategoryGUID = this.getAtlasGUID((MetadataElement)category);
                        if (atlasCategoryGUID == null) continue;
                        AtlasRelatedCategoryHeader atlasCategory = new AtlasRelatedCategoryHeader();
                        atlasCategory.setCategoryGuid(atlasCategoryGUID);
                        atlasCategories.add(atlasCategory);
                    }
                    if (!atlasCategories.isEmpty()) {
                        atlasGlossaryTerm.setCategories(atlasCategories);
                    }
                }
                this.atlasClient.saveAtlasGlossaryTerm(atlasGlossaryTerm);
            }
        }
    }

    private void refreshEgeriaGlossaryCategoryInAtlas(AtlasGlossaryElement atlasGlossaryDestination, GlossaryCategoryElement egeriaGlossaryCategory) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaGlossaryCategoryInAtlas";
        if (egeriaGlossaryCategory != null) {
            String atlasGlossaryCategoryGUID = this.getAtlasGUID((MetadataElement)egeriaGlossaryCategory);
            AtlasGlossaryCategoryElement atlasGlossaryCategory = null;
            if (atlasGlossaryCategoryGUID == null) {
                String atlasGlossaryGUID;
                GlossaryElement egeriaGlossary;
                block16: {
                    egeriaGlossary = null;
                    try {
                        egeriaGlossary = this.glossaryExchangeService.getGlossaryForCategory(egeriaGlossaryCategory.getElementHeader().getGUID(), new Date());
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block16;
                        this.auditLog.logException("refreshEgeriaGlossaryCategoryInAtlas", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refreshEgeriaGlossaryCategoryInAtlas", error.getMessage()), (Throwable)error);
                    }
                }
                if (egeriaGlossary != null && (atlasGlossaryGUID = this.getAtlasGUID((MetadataElement)egeriaGlossary)) != null) {
                    atlasGlossaryCategory = this.getAtlasGlossaryCategoryProperties(egeriaGlossaryCategory, null, atlasGlossaryDestination);
                    int categoryNameIndex = 1;
                    while (atlasGlossaryCategoryGUID == null) {
                        try {
                            atlasGlossaryCategoryGUID = this.atlasClient.createAtlasGlossaryCategory(atlasGlossaryCategory);
                        }
                        catch (NameConflictException conflictException) {
                            atlasGlossaryCategoryGUID = this.retryGetAtlasGUID(egeriaGlossaryCategory);
                            if (atlasGlossaryCategoryGUID != null) continue;
                            if (this.auditLog != null) {
                                this.auditLog.logMessage("refreshEgeriaGlossaryCategoryInAtlas", ApacheAtlasAuditCode.CATEGORY_ALREADY_EXISTS.getMessageDefinition(atlasGlossaryCategory.getName()));
                            }
                            atlasGlossaryCategory.setName(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName() + " (" + categoryNameIndex++ + ")");
                        }
                    }
                    if (this.auditLog != null) {
                        String atlasCategoryName = atlasGlossaryCategoryGUID;
                        if (atlasGlossaryCategory != null) {
                            atlasCategoryName = atlasGlossaryCategory.getName();
                        }
                        this.auditLog.logMessage("refreshEgeriaGlossaryCategoryInAtlas", ApacheAtlasAuditCode.SYNC_EGERIA_GLOSSARY_CATEGORY.getMessageDefinition(this.connectorName, egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), egeriaGlossaryCategory.getElementHeader().getGUID(), atlasCategoryName));
                    }
                    atlasGlossaryCategory.setGuid(atlasGlossaryCategoryGUID);
                }
            }
            if (atlasGlossaryCategoryGUID != null) {
                String atlasParentGUID;
                GlossaryCategoryElement parentCategory;
                this.ensureAtlasExternalIdentifier((MetadataElement)egeriaGlossaryCategory, atlasGlossaryCategoryGUID);
                if (atlasGlossaryCategory == null) {
                    atlasGlossaryCategory = this.getAtlasGlossaryCategoryProperties(egeriaGlossaryCategory, atlasGlossaryCategoryGUID, atlasGlossaryDestination);
                }
                if ((parentCategory = this.glossaryExchangeService.getGlossaryCategoryParent(egeriaGlossaryCategory.getElementHeader().getGUID(), new Date())) != null && (atlasParentGUID = this.getAtlasGUID((MetadataElement)parentCategory)) != null) {
                    AtlasRelatedCategoryHeader atlasParent = new AtlasRelatedCategoryHeader();
                    atlasParent.setCategoryGuid(atlasParentGUID);
                    atlasGlossaryCategory.setParentCategory(atlasParent);
                }
                this.atlasClient.saveAtlasGlossaryCategory(atlasGlossaryCategory);
                if (this.auditLog != null) {
                    String atlasCategoryName = atlasGlossaryCategoryGUID;
                    if (atlasGlossaryCategory != null) {
                        atlasCategoryName = atlasGlossaryCategory.getName();
                    }
                    this.auditLog.logMessage("refreshEgeriaGlossaryCategoryInAtlas", ApacheAtlasAuditCode.SYNC_EGERIA_GLOSSARY_CATEGORY.getMessageDefinition(this.connectorName, egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), egeriaGlossaryCategory.getElementHeader().getGUID(), atlasCategoryName));
                }
            }
        }
    }

    private void refreshAtlasGlossaryInEgeria(AtlasGlossaryElement atlasGlossaryElement, GlossaryElement egeriaGlossaryElement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAtlasGlossaryInEgeria";
        if (atlasGlossaryElement != null) {
            if (egeriaGlossaryElement == null) {
                String egeriaGlossaryGUID = this.getEgeriaGUID(atlasGlossaryElement = this.createAtlasGlossaryInEgeria(atlasGlossaryElement));
                if (egeriaGlossaryGUID != null) {
                    egeriaGlossaryElement = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
                }
            } else {
                GlossaryProperties glossaryProperties = this.getEgeriaGlossaryProperties(atlasGlossaryElement);
                this.glossaryExchangeService.updateGlossary(this.getEgeriaGUID(atlasGlossaryElement), null, true, glossaryProperties, null);
            }
            if (this.auditLog != null) {
                String egeriaQualifiedName = null;
                String egeriaGUID = null;
                if (egeriaGlossaryElement != null) {
                    egeriaQualifiedName = egeriaGlossaryElement.getGlossaryProperties().getQualifiedName();
                    egeriaGUID = egeriaGlossaryElement.getElementHeader().getGUID();
                }
                if (this.auditLog != null) {
                    this.auditLog.logMessage("refreshAtlasGlossaryInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY.getMessageDefinition(this.connectorName, atlasGlossaryElement.getName(), egeriaQualifiedName, egeriaGUID));
                }
            }
        }
    }

    private AtlasGlossaryElement createAtlasGlossaryInEgeria(AtlasGlossaryElement atlasGlossaryElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Map<String, Object> glossaryAdditionalAttributes;
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryElement.getGuid());
        GlossaryProperties glossaryProperties = this.getEgeriaGlossaryProperties(atlasGlossaryElement);
        String glossaryGUID = this.glossaryExchangeService.createGlossary(true, externalIdentifierProperties, glossaryProperties);
        if (this.auditLog != null) {
            String methodName = "createAtlasGlossaryInEgeria";
            this.auditLog.logMessage("createAtlasGlossaryInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY.getMessageDefinition(this.connectorName, atlasGlossaryElement.getName(), glossaryProperties.getQualifiedName(), glossaryGUID));
        }
        if ((glossaryAdditionalAttributes = atlasGlossaryElement.getAdditionalAttributes()) == null) {
            glossaryAdditionalAttributes = new HashMap<String, Object>();
        }
        glossaryAdditionalAttributes.put(egeriaGUIDPropertyName, glossaryGUID);
        glossaryAdditionalAttributes.put(egeriaOwnedPropertyName, false);
        atlasGlossaryElement.setAdditionalAttributes(glossaryAdditionalAttributes);
        return this.atlasClient.saveAtlasGlossary(atlasGlossaryElement);
    }

    private void refreshAtlasGlossaryTermInEgeria(AtlasGlossaryTermElement atlasGlossaryTerm, GlossaryTermElement egeriaGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryTermProperties glossaryTermProperties = this.getEgeriaGlossaryTermProperties(atlasGlossaryTerm);
        this.glossaryExchangeService.updateGlossaryTerm(egeriaGlossaryTerm.getElementHeader().getGUID(), atlasGlossaryTerm.getGuid(), false, glossaryTermProperties, new Date());
        if (this.auditLog != null) {
            String methodName = "refreshAtlasGlossaryTermInEgeria";
            this.auditLog.logMessage("refreshAtlasGlossaryTermInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY_TERM.getMessageDefinition(this.connectorName, atlasGlossaryTerm.getName(), glossaryTermProperties.getQualifiedName(), egeriaGlossaryTerm.getElementHeader().getGUID()));
        }
        this.setUpTermCategoriesInEgeria(egeriaGlossaryTerm.getElementHeader().getGUID(), atlasGlossaryTerm);
        this.setUpTermRelationshipsInEgeria(egeriaGlossaryTerm.getElementHeader().getGUID(), atlasGlossaryTerm);
    }

    private void createAtlasGlossaryTermInEgeria(AtlasGlossaryTermElement atlasGlossaryTerm, GlossaryElement destinationGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Map<String, Object> glossaryAdditionalAttributes;
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryTerm.getGuid());
        GlossaryTermProperties glossaryTermProperties = this.getEgeriaGlossaryTermProperties(atlasGlossaryTerm);
        String egeriaTermGUID = this.glossaryExchangeService.createGlossaryTerm(destinationGlossary.getElementHeader().getGUID(), true, externalIdentifierProperties, glossaryTermProperties, new Date());
        if (this.auditLog != null) {
            String methodName = "createAtlasGlossaryTermInEgeria";
            this.auditLog.logMessage("createAtlasGlossaryTermInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY_TERM.getMessageDefinition(this.connectorName, atlasGlossaryTerm.getName(), glossaryTermProperties.getQualifiedName(), egeriaTermGUID));
        }
        if ((glossaryAdditionalAttributes = atlasGlossaryTerm.getAdditionalAttributes()) == null) {
            glossaryAdditionalAttributes = new HashMap<String, Object>();
        }
        glossaryAdditionalAttributes.put(egeriaGUIDPropertyName, egeriaTermGUID);
        glossaryAdditionalAttributes.put(egeriaOwnedPropertyName, false);
        atlasGlossaryTerm.setAdditionalAttributes(glossaryAdditionalAttributes);
        this.atlasClient.saveAtlasGlossaryTerm(atlasGlossaryTerm);
        this.setUpTermCategoriesInEgeria(egeriaTermGUID, atlasGlossaryTerm);
        this.setUpTermRelationshipsInEgeria(egeriaTermGUID, atlasGlossaryTerm);
    }

    private GlossaryElement getEgeriaDestinationGlossaryForElement(AtlasGlossaryMemberBaseProperties atlasGlossaryMember) {
        block4: {
            AtlasGlossaryAnchorElement glossaryAnchorElement;
            if (atlasGlossaryMember != null && (glossaryAnchorElement = atlasGlossaryMember.getAnchor()) != null) {
                try {
                    String egeriaGlossaryGUID;
                    AtlasGlossaryElement atlasGlossary = this.atlasClient.getAtlasGlossary(glossaryAnchorElement.getGlossaryGuid());
                    if (atlasGlossary != null && (egeriaGlossaryGUID = this.getEgeriaGUID(atlasGlossary)) != null) {
                        return this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
                    }
                }
                catch (Exception notFound) {
                    if (this.auditLog == null) break block4;
                    String methodName = "getEgeriaDestinationGlossaryForElement";
                    this.auditLog.logException("getEgeriaDestinationGlossaryForElement", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, notFound.getClass().getName(), "getEgeriaDestinationGlossaryForElement", notFound.getMessage()), (Throwable)notFound);
                }
            }
        }
        return null;
    }

    private AtlasGlossaryElement getDestinationAtlasGlossary(ElementHeader elementHeader) {
        block11: {
            try {
                GlossaryElement egeriaGlossary = null;
                if (this.myContext.isTypeOf(elementHeader, "Glossary")) {
                    egeriaGlossary = this.glossaryExchangeService.getGlossaryByGUID(elementHeader.getGUID(), null);
                } else if (this.myContext.isTypeOf(elementHeader, "GlossaryTerm")) {
                    egeriaGlossary = this.glossaryExchangeService.getGlossaryForTerm(elementHeader.getGUID(), null);
                } else if (this.myContext.isTypeOf(elementHeader, "GlossaryCategory")) {
                    egeriaGlossary = this.glossaryExchangeService.getGlossaryForCategory(elementHeader.getGUID(), null);
                }
                if (egeriaGlossary != null && egeriaGlossary.getGlossaryProperties() != null) {
                    String atlasGlossaryGUID = this.getAtlasGUID((MetadataElement)egeriaGlossary);
                    if (atlasGlossaryGUID == null) {
                        AtlasGlossaryElement atlasGlossaryElement = this.getAtlasGlossaryProperties(egeriaGlossary, null);
                        atlasGlossaryGUID = this.atlasClient.createAtlasGlossary(atlasGlossaryElement);
                        this.ensureAtlasExternalIdentifier((MetadataElement)egeriaGlossary, atlasGlossaryGUID);
                    } else {
                        AtlasGlossaryElement atlasGlossaryElement = this.getAtlasGlossaryProperties(egeriaGlossary, this.atlasClient.getAtlasGlossary(atlasGlossaryGUID));
                        this.atlasClient.saveAtlasGlossary(atlasGlossaryElement);
                        this.ensureAtlasExternalIdentifier((MetadataElement)egeriaGlossary, atlasGlossaryElement.getGuid());
                    }
                    if (atlasGlossaryGUID != null) {
                        return this.atlasClient.getAtlasGlossary(atlasGlossaryGUID);
                    }
                }
            }
            catch (Exception notFound) {
                String methodName = "getDestinationAtlasGlossary";
                if (this.auditLog == null) break block11;
                this.auditLog.logException("getDestinationAtlasGlossary", ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, notFound.getClass().getName(), "getDestinationAtlasGlossary(" + elementHeader.getGUID() + ")", notFound.getMessage()), (Throwable)notFound);
            }
        }
        return null;
    }

    private void setUpTermCategoriesInEgeria(String egeriaTermGUID, AtlasGlossaryTermElement atlasGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (atlasGlossaryTerm.getCategories() != null) {
            for (AtlasRelatedCategoryHeader relatedCategory : atlasGlossaryTerm.getCategories()) {
                String egeriaCategoryGUID;
                AtlasGlossaryCategoryElement atlasGlossaryCategory = this.atlasClient.getAtlasGlossaryCategory(relatedCategory.getCategoryGuid());
                if (atlasGlossaryCategory == null || (egeriaCategoryGUID = this.getEgeriaGUID(atlasGlossaryCategory)) == null) continue;
                this.glossaryExchangeService.setupTermCategory(egeriaCategoryGUID, egeriaTermGUID, null, new Date());
            }
        }
        Map<String, AtlasGlossaryCategoryElement> atlasCategories = this.getAtlasCategoriesForElement(atlasGlossaryTerm.getCategories());
        int startFrom = 0;
        List linkedCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaTermGUID, startFrom, this.myContext.getMaxPageSize(), new Date());
        while (linkedCategories != null) {
            for (GlossaryCategoryElement egeriaCategory : linkedCategories) {
                String atlasCategoryGUID;
                if (!this.isAtlasOwnedElement(egeriaCategory.getElementHeader()) || atlasCategories.containsKey(atlasCategoryGUID = this.getAtlasGUID((MetadataElement)egeriaCategory))) continue;
                this.glossaryExchangeService.clearTermCategory(egeriaCategory.getElementHeader().getGUID(), egeriaTermGUID, new Date());
            }
            linkedCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaTermGUID, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
        }
    }

    private void setUpTermRelationshipsInEgeria(String egeriaTermGUID, AtlasGlossaryTermElement atlasGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    private void refreshAtlasGlossaryCategoryInEgeria(AtlasGlossaryCategoryElement atlasCategory, GlossaryCategoryElement egeriaCategory) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GlossaryCategoryProperties glossaryCategoryProperties = this.getEgeriaGlossaryCategoryProperties(atlasCategory);
        this.glossaryExchangeService.updateGlossaryCategory(egeriaCategory.getElementHeader().getGUID(), atlasCategory.getGuid(), false, glossaryCategoryProperties, new Date());
        if (this.auditLog != null) {
            String methodName = "refreshAtlasGlossaryCategoryInEgeria";
            this.auditLog.logMessage("refreshAtlasGlossaryCategoryInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY_CATEGORY.getMessageDefinition(this.connectorName, atlasCategory.getName(), glossaryCategoryProperties.getQualifiedName(), egeriaCategory.getElementHeader().getGUID()));
        }
        this.setUpCategoryHierarchyInEgeria(egeriaCategory.getElementHeader().getGUID(), atlasCategory);
    }

    private void createAtlasGlossaryCategoryInEgeria(AtlasGlossaryCategoryElement atlasGlossaryCategory, GlossaryElement destinationGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Map<String, Object> glossaryAdditionalAttributes;
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryCategory.getGuid());
        GlossaryCategoryProperties glossaryCategoryProperties = this.getEgeriaGlossaryCategoryProperties(atlasGlossaryCategory);
        String egeriaCategoryGUID = this.glossaryExchangeService.createGlossaryCategory(destinationGlossary.getElementHeader().getGUID(), true, externalIdentifierProperties, glossaryCategoryProperties, atlasGlossaryCategory.getParentCategory() == null, new Date());
        if (this.auditLog != null) {
            String methodName = "createAtlasGlossaryCategoryInEgeria";
            this.auditLog.logMessage("createAtlasGlossaryCategoryInEgeria", ApacheAtlasAuditCode.SYNC_ATLAS_GLOSSARY_CATEGORY.getMessageDefinition(this.connectorName, atlasGlossaryCategory.getName(), glossaryCategoryProperties.getQualifiedName(), egeriaCategoryGUID));
        }
        if ((glossaryAdditionalAttributes = atlasGlossaryCategory.getAdditionalAttributes()) == null) {
            glossaryAdditionalAttributes = new HashMap<String, Object>();
        }
        glossaryAdditionalAttributes.put(egeriaGUIDPropertyName, egeriaCategoryGUID);
        glossaryAdditionalAttributes.put(egeriaOwnedPropertyName, false);
        atlasGlossaryCategory.setAdditionalAttributes(glossaryAdditionalAttributes);
        this.atlasClient.saveAtlasGlossaryCategory(atlasGlossaryCategory);
        this.setUpCategoryHierarchyInEgeria(egeriaCategoryGUID, atlasGlossaryCategory);
    }

    private void setUpCategoryHierarchyInEgeria(String egeriaCategoryGUID, AtlasGlossaryCategoryElement atlasGlossaryCategory) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryCategoryElement egeriaParentCategory = this.glossaryExchangeService.getGlossaryCategoryParent(egeriaCategoryGUID, new Date());
        if (egeriaParentCategory == null) {
            String egeriaParentCategoryGUIDFromAtlas;
            AtlasGlossaryCategoryElement atlasParentCategory;
            if (atlasGlossaryCategory.getParentCategory() != null && (atlasParentCategory = this.atlasClient.getAtlasGlossaryCategory(atlasGlossaryCategory.getParentCategory().getCategoryGuid())) != null && (egeriaParentCategoryGUIDFromAtlas = this.getEgeriaGUID(atlasParentCategory)) != null) {
                this.glossaryExchangeService.setupCategoryParent(egeriaParentCategoryGUIDFromAtlas, egeriaCategoryGUID, new Date());
            }
        } else if (atlasGlossaryCategory.getParentCategory() != null) {
            AtlasGlossaryCategoryElement atlasParentCategory = this.atlasClient.getAtlasGlossaryCategory(atlasGlossaryCategory.getParentCategory().getCategoryGuid());
            if (atlasParentCategory != null) {
                String egeriaParentCategoryGUIDFromAtlas = this.getEgeriaGUID(atlasParentCategory);
                if (!egeriaParentCategory.getElementHeader().getGUID().equals(egeriaParentCategoryGUIDFromAtlas)) {
                    this.glossaryExchangeService.clearCategoryParent(egeriaParentCategory.getElementHeader().getGUID(), egeriaCategoryGUID, new Date());
                    this.glossaryExchangeService.setupCategoryParent(egeriaParentCategoryGUIDFromAtlas, egeriaCategoryGUID, new Date());
                }
            }
        } else if (this.isAtlasOwnedElement(egeriaParentCategory.getElementHeader())) {
            this.glossaryExchangeService.clearCategoryParent(egeriaParentCategory.getElementHeader().getGUID(), egeriaCategoryGUID, new Date());
        }
    }

    private ExternalIdentifierProperties getExternalIdentifier(String atlasGUID) {
        ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
        externalIdentifierProperties.setExternalIdentifier(atlasGUID);
        externalIdentifierProperties.setExternalIdentifierName(atlasGUIDPropertyName);
        return externalIdentifierProperties;
    }

    private void ensureAtlasExternalIdentifier(MetadataElement egeriaElement, String atlasGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (egeriaElement.getCorrelationHeaders() != null) {
            for (MetadataCorrelationHeader header : egeriaElement.getCorrelationHeaders()) {
                if (!atlasGUID.equals(header.getExternalIdentifier())) continue;
                return;
            }
        }
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGUID);
        this.myContext.addExternalIdentifier(egeriaElement.getElementHeader().getGUID(), egeriaElement.getElementHeader().getType().getTypeName(), externalIdentifierProperties);
    }

    private AtlasGlossaryElement clearEgeriaGUIDFromGlossary(AtlasGlossaryElement atlasGlossaryElement) throws PropertyServerException {
        if (atlasGlossaryElement != null && atlasGlossaryElement.getAdditionalAttributes() != null) {
            HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
            for (String propertyName : atlasGlossaryElement.getAdditionalAttributes().keySet()) {
                if (propertyName.equals(egeriaGUIDPropertyName) || propertyName.equals(egeriaOwnedPropertyName)) continue;
                additionalAttributes.put(propertyName, atlasGlossaryElement.getAdditionalAttributes().get(propertyName));
            }
            if (additionalAttributes.isEmpty()) {
                additionalAttributes = null;
            }
            atlasGlossaryElement.setAdditionalAttributes(additionalAttributes);
            return this.atlasClient.saveAtlasGlossary(atlasGlossaryElement);
        }
        return null;
    }

    private AtlasGlossaryCategoryElement clearEgeriaGUIDFromCategory(AtlasGlossaryCategoryElement atlasGlossaryCategory) throws PropertyServerException {
        if (atlasGlossaryCategory != null && atlasGlossaryCategory.getAdditionalAttributes() != null) {
            HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
            for (String propertyName : atlasGlossaryCategory.getAdditionalAttributes().keySet()) {
                if (propertyName.equals(egeriaGUIDPropertyName) || propertyName.equals(egeriaOwnedPropertyName)) continue;
                additionalAttributes.put(propertyName, atlasGlossaryCategory.getAdditionalAttributes().get(propertyName));
            }
            if (additionalAttributes.isEmpty()) {
                additionalAttributes = null;
            }
            atlasGlossaryCategory.setAdditionalAttributes(additionalAttributes);
            return this.atlasClient.saveAtlasGlossaryCategory(atlasGlossaryCategory);
        }
        return null;
    }

    private AtlasGlossaryTermElement clearEgeriaGUIDFromTerm(AtlasGlossaryTermElement atlasGlossaryTermElement) throws PropertyServerException {
        if (atlasGlossaryTermElement != null && atlasGlossaryTermElement.getAdditionalAttributes() != null) {
            HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
            for (String propertyName : atlasGlossaryTermElement.getAdditionalAttributes().keySet()) {
                if (propertyName.equals(egeriaGUIDPropertyName) || propertyName.equals(egeriaOwnedPropertyName)) continue;
                additionalAttributes.put(propertyName, atlasGlossaryTermElement.getAdditionalAttributes().get(propertyName));
            }
            if (additionalAttributes.isEmpty()) {
                additionalAttributes = null;
            }
            atlasGlossaryTermElement.setAdditionalAttributes(additionalAttributes);
            return this.atlasClient.saveAtlasGlossaryTerm(atlasGlossaryTermElement);
        }
        return null;
    }

    private GlossaryElement getGlossaryElement(String glossaryQualifiedName, String methodName) throws ConnectorCheckedException {
        try {
            List egeriaGlossaries = this.glossaryExchangeService.getGlossariesByName(glossaryQualifiedName, 0, 0, null);
            if (egeriaGlossaries != null) {
                for (GlossaryElement glossaryElement : egeriaGlossaries) {
                    String qualifiedName = glossaryElement.getGlossaryProperties().getQualifiedName();
                    if (!glossaryQualifiedName.equals(qualifiedName)) continue;
                    return glossaryElement;
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, ApacheAtlasAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
        return null;
    }

    private GlossaryProperties getEgeriaGlossaryProperties(AtlasGlossaryElement atlasGlossaryElement) {
        GlossaryProperties glossaryProperties = new GlossaryProperties();
        glossaryProperties.setQualifiedName("AtlasGlossary." + atlasGlossaryElement.getQualifiedName());
        glossaryProperties.setDisplayName(atlasGlossaryElement.getName());
        if (atlasGlossaryElement.getShortDescription() != null) {
            glossaryProperties.setDescription(atlasGlossaryElement.getShortDescription() + "\n\n" + atlasGlossaryElement.getLongDescription());
        } else {
            glossaryProperties.setDescription(atlasGlossaryElement.getLongDescription());
        }
        glossaryProperties.setLanguage(atlasGlossaryElement.getLanguage());
        glossaryProperties.setUsage(atlasGlossaryElement.getUsage());
        return glossaryProperties;
    }

    AtlasGlossaryElement getAtlasGlossaryProperties(GlossaryElement egeriaGlossary, AtlasGlossaryElement existingGlossary) {
        String[] descriptionSentences;
        AtlasGlossaryElement atlasGlossaryElement = new AtlasGlossaryElement();
        if (existingGlossary != null) {
            atlasGlossaryElement = existingGlossary;
        }
        atlasGlossaryElement.setName(egeriaGlossary.getGlossaryProperties().getDisplayName());
        if (egeriaGlossary.getGlossaryProperties().getDescription() != null && (descriptionSentences = egeriaGlossary.getGlossaryProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            atlasGlossaryElement.setShortDescription(descriptionSentences[0]);
        }
        atlasGlossaryElement.setLongDescription(egeriaGlossary.getGlossaryProperties().getDescription());
        atlasGlossaryElement.setLanguage(egeriaGlossary.getGlossaryProperties().getLanguage());
        atlasGlossaryElement.setUsage(egeriaGlossary.getGlossaryProperties().getUsage());
        HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
        additionalAttributes.put(egeriaGUIDPropertyName, egeriaGlossary.getElementHeader().getGUID());
        additionalAttributes.put(egeriaOwnedPropertyName, true);
        atlasGlossaryElement.setAdditionalAttributes(additionalAttributes);
        return atlasGlossaryElement;
    }

    private GlossaryTermProperties getEgeriaGlossaryTermProperties(AtlasGlossaryTermElement atlasGlossaryTermElement) {
        GlossaryTermProperties glossaryTermProperties = new GlossaryTermProperties();
        glossaryTermProperties.setQualifiedName("AtlasGlossaryTerm." + atlasGlossaryTermElement.getQualifiedName());
        glossaryTermProperties.setDisplayName(atlasGlossaryTermElement.getName());
        if (atlasGlossaryTermElement.getShortDescription() != null) {
            glossaryTermProperties.setDescription(atlasGlossaryTermElement.getShortDescription() + "\n\n" + atlasGlossaryTermElement.getLongDescription());
        } else {
            glossaryTermProperties.setDescription(atlasGlossaryTermElement.getLongDescription());
        }
        glossaryTermProperties.setAbbreviation(atlasGlossaryTermElement.getAbbreviation());
        glossaryTermProperties.setUsage(atlasGlossaryTermElement.getUsage());
        return glossaryTermProperties;
    }

    AtlasGlossaryTermElement getAtlasGlossaryTermProperties(GlossaryTermElement egeriaGlossaryTerm, String atlasGlossaryTermGUID, AtlasGlossaryElement atlasGlossary) throws PropertyServerException {
        String[] descriptionSentences;
        AtlasGlossaryTermElement atlasGlossaryTermElement;
        if (atlasGlossaryTermGUID != null) {
            Map<String, AtlasGlossaryTermElement> existingTerms = this.getAtlasTermsForGlossary(atlasGlossary);
            atlasGlossaryTermElement = this.atlasClient.getAtlasGlossaryTerm(atlasGlossaryTermGUID);
            atlasGlossaryTermElement.setName(this.getNameForAtlasTerm(egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), atlasGlossaryTermGUID, existingTerms));
        } else {
            atlasGlossaryTermElement = new AtlasGlossaryTermElement();
            AtlasGlossaryAnchorElement anchorElement = new AtlasGlossaryAnchorElement();
            anchorElement.setGlossaryGuid(atlasGlossary.getGuid());
            anchorElement.setDisplayText(atlasGlossary.getName());
            atlasGlossaryTermElement.setAnchor(anchorElement);
            atlasGlossaryTermElement.setName(egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName());
        }
        if (egeriaGlossaryTerm.getGlossaryTermProperties().getDescription() != null && (descriptionSentences = egeriaGlossaryTerm.getGlossaryTermProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            atlasGlossaryTermElement.setShortDescription(descriptionSentences[0]);
        }
        atlasGlossaryTermElement.setLongDescription(egeriaGlossaryTerm.getGlossaryTermProperties().getDescription());
        atlasGlossaryTermElement.setAbbreviation(egeriaGlossaryTerm.getGlossaryTermProperties().getAbbreviation());
        atlasGlossaryTermElement.setUsage(egeriaGlossaryTerm.getGlossaryTermProperties().getUsage());
        HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
        additionalAttributes.put(egeriaGUIDPropertyName, egeriaGlossaryTerm.getElementHeader().getGUID());
        additionalAttributes.put(egeriaOwnedPropertyName, true);
        atlasGlossaryTermElement.setAdditionalAttributes(additionalAttributes);
        return atlasGlossaryTermElement;
    }

    private GlossaryCategoryProperties getEgeriaGlossaryCategoryProperties(AtlasGlossaryCategoryElement atlasGlossaryCategoryElement) {
        GlossaryCategoryProperties glossaryCategoryProperties = new GlossaryCategoryProperties();
        glossaryCategoryProperties.setQualifiedName("AtlasGlossaryCategory." + atlasGlossaryCategoryElement.getQualifiedName());
        glossaryCategoryProperties.setDisplayName(atlasGlossaryCategoryElement.getName());
        if (atlasGlossaryCategoryElement.getShortDescription() != null) {
            glossaryCategoryProperties.setDescription(atlasGlossaryCategoryElement.getShortDescription() + "\n\n" + atlasGlossaryCategoryElement.getLongDescription());
        } else {
            glossaryCategoryProperties.setDescription(atlasGlossaryCategoryElement.getLongDescription());
        }
        return glossaryCategoryProperties;
    }

    AtlasGlossaryCategoryElement getAtlasGlossaryCategoryProperties(GlossaryCategoryElement egeriaGlossaryCategory, String atlasGlossaryCategoryGUID, AtlasGlossaryElement atlasGlossary) throws PropertyServerException {
        String[] descriptionSentences;
        AtlasGlossaryCategoryElement atlasGlossaryCategoryElement;
        if (atlasGlossaryCategoryGUID != null) {
            Map<String, AtlasGlossaryCategoryElement> existingCategories = this.getAtlasCategoriesForGlossary(atlasGlossary);
            atlasGlossaryCategoryElement = this.atlasClient.getAtlasGlossaryCategory(atlasGlossaryCategoryGUID);
            atlasGlossaryCategoryElement.setName(this.getNameForAtlasCategory(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), atlasGlossaryCategoryGUID, existingCategories));
        } else {
            atlasGlossaryCategoryElement = new AtlasGlossaryCategoryElement();
            AtlasGlossaryAnchorElement anchorElement = new AtlasGlossaryAnchorElement();
            anchorElement.setGlossaryGuid(atlasGlossary.getGuid());
            anchorElement.setDisplayText(atlasGlossary.getName());
            atlasGlossaryCategoryElement.setAnchor(anchorElement);
            atlasGlossaryCategoryElement.setName(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName());
        }
        if (egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription() != null && (descriptionSentences = egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            atlasGlossaryCategoryElement.setShortDescription(descriptionSentences[0]);
        }
        atlasGlossaryCategoryElement.setLongDescription(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription());
        HashMap<String, Object> additionalAttributes = new HashMap<String, Object>();
        additionalAttributes.put(egeriaGUIDPropertyName, egeriaGlossaryCategory.getElementHeader().getGUID());
        additionalAttributes.put(egeriaOwnedPropertyName, true);
        atlasGlossaryCategoryElement.setAdditionalAttributes(additionalAttributes);
        return atlasGlossaryCategoryElement;
    }

    private String getNameForAtlasTerm(String egeriaTermName, String atlasTermGUID, Map<String, AtlasGlossaryTermElement> atlasGlossaryTermElementMap) {
        String atlasTermName;
        if (atlasGlossaryTermElementMap == null) {
            return egeriaTermName;
        }
        if (atlasTermGUID != null && atlasGlossaryTermElementMap.get(atlasTermGUID) != null && (atlasTermName = atlasGlossaryTermElementMap.get(atlasTermGUID).getName()).startsWith(egeriaTermName)) {
            return atlasTermName;
        }
        int termCount = 0;
        for (AtlasGlossaryTermElement existingAtlasTerm : atlasGlossaryTermElementMap.values()) {
            if (!egeriaTermName.equals(existingAtlasTerm.getName())) {
                String[] termEndingParts;
                String[] termNameParts = egeriaTermName.split(Pattern.quote(" ("));
                if (termNameParts.length <= 1 || (termEndingParts = termNameParts[termNameParts.length - 1].split(Pattern.quote(")"))).length != 1) continue;
                try {
                    int termIndex = Integer.parseInt(termEndingParts[0]);
                    if (termIndex < termCount) continue;
                    termCount = termIndex + 1;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            ++termCount;
        }
        if (termCount == 0) {
            return egeriaTermName;
        }
        return egeriaTermName + " (" + termCount + ")";
    }

    private String getNameForAtlasCategory(String egeriaCategoryName, String atlasCategoryGUID, Map<String, AtlasGlossaryCategoryElement> atlasGlossaryCategoryElementMap) {
        String atlasCategoryName;
        if (atlasGlossaryCategoryElementMap == null) {
            return egeriaCategoryName;
        }
        if (atlasCategoryGUID != null && atlasGlossaryCategoryElementMap.get(atlasCategoryGUID) != null && (atlasCategoryName = atlasGlossaryCategoryElementMap.get(atlasCategoryGUID).getName()).startsWith(egeriaCategoryName)) {
            return atlasCategoryName;
        }
        int categoryCount = 0;
        for (AtlasGlossaryCategoryElement existingAtlasCategory : atlasGlossaryCategoryElementMap.values()) {
            if (!egeriaCategoryName.equals(existingAtlasCategory.getName())) {
                String[] categoryEndingParts;
                String[] categoryNameParts = egeriaCategoryName.split(Pattern.quote(" ("));
                if (categoryNameParts.length <= 1 || (categoryEndingParts = categoryNameParts[categoryNameParts.length - 1].split(Pattern.quote(")"))).length != 1) continue;
                try {
                    int categoryIndex = Integer.parseInt(categoryEndingParts[0]);
                    if (categoryIndex < categoryCount) continue;
                    categoryCount = categoryIndex + 1;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            ++categoryCount;
        }
        if (categoryCount == 0) {
            return egeriaCategoryName;
        }
        return egeriaCategoryName + " (" + categoryCount + ")";
    }

    private Map<String, AtlasGlossaryTermElement> getAtlasTermsForGlossary(AtlasGlossaryElement atlasGlossary) throws PropertyServerException {
        if (atlasGlossary != null && atlasGlossary.getTerms() != null && !atlasGlossary.getTerms().isEmpty()) {
            HashMap<String, AtlasGlossaryTermElement> atlasTerms = new HashMap<String, AtlasGlossaryTermElement>();
            for (AtlasRelatedTermHeader termHeader : atlasGlossary.getTerms()) {
                AtlasGlossaryTermElement atlasGlossaryTermElement = this.atlasClient.getAtlasGlossaryTerm(termHeader.getTermGuid());
                if (atlasGlossaryTermElement == null || atlasGlossaryTermElement.getGuid() == null) continue;
                atlasTerms.put(atlasGlossaryTermElement.getGuid(), atlasGlossaryTermElement);
            }
            return atlasTerms;
        }
        return null;
    }

    private Map<String, AtlasGlossaryCategoryElement> getAtlasCategoriesForGlossary(AtlasGlossaryElement atlasGlossary) throws PropertyServerException {
        if (atlasGlossary != null) {
            return this.getAtlasCategoriesForElement(atlasGlossary.getCategories());
        }
        return null;
    }

    private Map<String, AtlasGlossaryCategoryElement> getAtlasCategoriesForElement(List<AtlasRelatedCategoryHeader> relatedCategories) throws PropertyServerException {
        if (relatedCategories != null && !relatedCategories.isEmpty()) {
            HashMap<String, AtlasGlossaryCategoryElement> atlasCategories = new HashMap<String, AtlasGlossaryCategoryElement>();
            for (AtlasRelatedCategoryHeader categoryHeader : relatedCategories) {
                AtlasGlossaryCategoryElement atlasGlossaryCategoryElement = this.atlasClient.getAtlasGlossaryCategory(categoryHeader.getCategoryGuid());
                if (atlasGlossaryCategoryElement == null || atlasGlossaryCategoryElement.getGuid() == null) continue;
                atlasCategories.put(atlasGlossaryCategoryElement.getGuid(), atlasGlossaryCategoryElement);
            }
            return atlasCategories;
        }
        return null;
    }
}

