/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.apacheatlas;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.NameConflictException;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryCategoryElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryElement;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.properties.AtlasGlossaryTermElement;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.springframework.core.ParameterizedTypeReference;

public class ApacheAtlasRESTClient {
    protected String serverName;
    protected String baseURL;
    protected AuditLog auditLog;
    private final RESTClientConnector clientConnector;

    protected ApacheAtlasRESTClient(String connectorName, String serverName, String baseURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverName = serverName;
        this.baseURL = baseURL;
        this.auditLog = auditLog;
        RESTClientFactory factory = new RESTClientFactory(serverName, baseURL, userId, password);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(connectorName, error.getMessage()), this.getClass().getName(), "RESTClient(userId and password)", (Throwable)error, "baseURL, serverName, userId or password");
        }
    }

    AtlasGlossaryElement getAtlasGlossary(int glossaryCount) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryCount)";
        String url = this.baseURL + "/api/atlas/v2/glossary?limit=1&offset=" + glossaryCount + "&sort=ASC";
        ArrayList glossaryElements = this.callGetRESTCallNoParams("getAtlasGlossary(glossaryCount)", ArrayList.class, url);
        if (glossaryElements != null && !glossaryElements.isEmpty()) {
            LinkedHashMap requestedGlossary = (LinkedHashMap)glossaryElements.get(0);
            return this.getAtlasGlossary(requestedGlossary.get("guid").toString());
        }
        return null;
    }

    AtlasGlossaryElement getAtlasGlossary(String glossaryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryGUID)";
        String url = this.baseURL + "/api/atlas/v2/glossary/" + glossaryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossary(glossaryGUID)", AtlasGlossaryElement.class, url);
    }

    String createAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "createAtlasGlossary(glossary)";
        String url = this.baseURL + "/api/atlas/v2/glossary";
        AtlasGlossaryElement newGlossary = this.callPostRESTCallNoParams("createAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, glossary);
        if (newGlossary != null) {
            return newGlossary.getGuid();
        }
        return null;
    }

    AtlasGlossaryElement saveAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "saveAtlasGlossary(glossary)";
        String url = this.baseURL + "/api/atlas/v2/glossary/{0}";
        return this.callPutRESTCall("saveAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, (Object)glossary, glossary.getGuid());
    }

    void deleteAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "deleteAtlasGlossary()";
        String url = this.baseURL + "/api/atlas/v2/glossary/" + glossary.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossary()", url);
    }

    AtlasGlossaryTermElement getAtlasGlossaryTerm(String glossaryTermGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryTerm(glossaryTermGUID)";
        String url = this.baseURL + "/api/atlas/v2/glossary/term/" + glossaryTermGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryTerm(glossaryTermGUID)", AtlasGlossaryTermElement.class, url);
    }

    String createAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException, NameConflictException {
        AtlasGlossaryTermElement newTerm;
        String methodName = "createAtlasGlossaryTerm()";
        String url = this.baseURL + "/api/atlas/v2/glossary/term";
        try {
            newTerm = this.callPostRESTCallNameConflict("createAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, term);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.TERM_ALREADY_EXISTS.getMessageDefinition(term.getName()), this.getClass().getName(), "createAtlasGlossaryTerm()", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newTerm != null) {
            return newTerm.getGuid();
        }
        return null;
    }

    AtlasGlossaryTermElement saveAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryTerm()";
        String url = this.baseURL + "/api/atlas/v2/glossary/term/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, (Object)term, term.getGuid());
    }

    void deleteAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryTerm()";
        String url = this.baseURL + "/api/atlas/v2/glossary/term/" + term.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryTerm()", url);
    }

    AtlasGlossaryCategoryElement getAtlasGlossaryCategory(String glossaryCategoryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryCategory(glossaryCategoryGUID)";
        String url = this.baseURL + "/api/atlas/v2/glossary/category/" + glossaryCategoryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryCategory(glossaryCategoryGUID)", AtlasGlossaryCategoryElement.class, url);
    }

    String createAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException, NameConflictException {
        AtlasGlossaryCategoryElement newGlossaryCategory;
        String methodName = "createAtlasGlossaryCategory(category)";
        String url = this.baseURL + "/api/atlas/v2/glossary/category";
        try {
            newGlossaryCategory = this.callPostRESTCallNameConflict("createAtlasGlossaryCategory(category)", AtlasGlossaryCategoryElement.class, url, category);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.CATEGORY_ALREADY_EXISTS.getMessageDefinition(category.getName()), this.getClass().getName(), "createAtlasGlossaryCategory(category)", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newGlossaryCategory != null) {
            return newGlossaryCategory.getGuid();
        }
        return null;
    }

    AtlasGlossaryCategoryElement saveAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryCategory(glossaryGUID)";
        String url = this.baseURL + "/api/atlas/v2/glossary/category/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryCategory(glossaryGUID)", AtlasGlossaryCategoryElement.class, url, (Object)category, category.getGuid());
    }

    void deleteAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryCategory(glossaryGUID)";
        String url = this.baseURL + "/api/atlas/v2/glossary/category/" + category.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryCategory(glossaryGUID)", url);
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNameConflict(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            if (!error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                this.logRESTCallException(methodName, error);
            }
            throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.baseURL, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPostRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPutRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected void callDeleteRESTCall(String methodName, String urlTemplate) throws PropertyServerException {
        try {
            this.clientConnector.callDeleteRESTCallNoParams(methodName, Object.class, urlTemplate, null);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callDeleteRESTCall(methodName, responseType, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, Exception error) throws PropertyServerException {
        if (this.auditLog != null) {
            this.auditLog.logException(methodName, ApacheAtlasAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.baseURL, error.getMessage()), (Throwable)error);
        }
        throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.baseURL, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
    }
}

