/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.apacheatlas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.ApacheHiveIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.ApacheKafkaIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.AtlasGlossaryIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.AtlasLineageIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.RDBMSIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.integration.apacheatlas.modules.RegisteredIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ApacheAtlasRESTProvider;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasAttributeDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasCardinality;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasPropagateTags;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasRelationshipCategory;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasRelationshipDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasRelationshipEndDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasTypesDef;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class ApacheAtlasIntegrationConnector
extends CatalogIntegratorConnector
implements AssetManagerEventListener {
    private String targetRootURL = null;
    private CatalogIntegratorContext myContext = null;
    private ApacheAtlasRESTConnector atlasClient = null;
    private AtlasLineageIntegrationModule lineageIntegrationModule = null;
    private final Map<String, List<RegisteredIntegrationModule>> moduleMap = new HashMap<String, List<RegisteredIntegrationModule>>();
    private final List<RegisteredIntegrationModule> moduleList = new ArrayList<RegisteredIntegrationModule>();
    public static final String OPEN_METADATA_CORRELATION_TYPE_NAME = "OpenMetadataCorrelation";
    public static final String OPEN_METADATA_CORRELATION_LINK_TYPE_NAME = "OpenMetadataCorrelationLink";
    public static final String GLOSSARY_CORRELATION_LINK_TYPE_NAME = "OpenMetadataGlossaryCorrelationLink";

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
        if (this.connectionProperties.getUserId() == null || this.connectionProperties.getClearPassword() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_USER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        if (this.myContext.getAssetManagerName() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_ASSET_MANAGER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            ApacheAtlasRESTConnector apacheAtlasRESTConnector;
            Connection atlasConnection = new Connection(this.connectionBean);
            atlasConnection.setConnectorType(new ApacheAtlasRESTProvider().getConnectorType());
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            Connector newConnector = connectorBroker.getConnector(atlasConnection);
            if (!(newConnector instanceof ApacheAtlasRESTConnector)) {
                throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_ATLAS_CLIENT.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
            }
            this.atlasClient = apacheAtlasRESTConnector = (ApacheAtlasRESTConnector)newConnector;
            this.atlasClient.start();
            this.setupCorrelationTypes(this.atlasClient);
            this.registerSupportedModule(new AtlasGlossaryIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new ApacheHiveIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new RDBMSIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new ApacheKafkaIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.lineageIntegrationModule = new AtlasLineageIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors);
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", ApacheAtlasAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, error.getClass().getName(), this.targetRootURL, "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    private void registerSupportedModule(RegisteredIntegrationModule supportedModule) {
        this.moduleList.add(supportedModule);
        if (supportedModule.getListenForTypes() != null) {
            for (String supportedType : supportedModule.getListenForTypes()) {
                if (supportedType == null) continue;
                List<RegisteredIntegrationModule> modulesForTypeName = this.moduleMap.get(supportedType);
                if (modulesForTypeName == null) {
                    modulesForTypeName = new ArrayList<RegisteredIntegrationModule>();
                }
                modulesForTypeName.add(supportedModule);
                this.moduleMap.put(supportedType, modulesForTypeName);
            }
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        for (RegisteredIntegrationModule registeredModule : this.moduleList) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("refresh", ApacheAtlasAuditCode.SYNC_INTEGRATION_MODULE.getMessageDefinition(this.connectorName, registeredModule.getModuleName()));
            }
            registeredModule.refresh();
        }
        this.lineageIntegrationModule.synchronizeLineage();
        if (!this.myContext.isListenerRegistered() && this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                this.myContext.registerListener((AssetManagerEventListener)this);
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", ApacheAtlasAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
            }
        }
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        if (!this.myContext.isRefreshInProgress()) {
            ElementHeader elementHeader = event.getElementHeader();
            for (String supportedType : this.moduleMap.keySet()) {
                List<RegisteredIntegrationModule> modulesForTypeName;
                if (!this.myContext.isTypeOf(elementHeader, supportedType) || (modulesForTypeName = this.moduleMap.get(supportedType)) == null) continue;
                for (RegisteredIntegrationModule registeredModule : modulesForTypeName) {
                    registeredModule.processEvent(event);
                }
            }
        }
    }

    private void setupCorrelationTypes(ApacheAtlasRESTConnector atlasClient) throws PropertyServerException {
        AtlasRelationshipEndDef end2;
        AtlasRelationshipEndDef end1;
        AtlasRelationshipDef relationshipDef;
        ArrayList<AtlasRelationshipDef> relationshipDefs;
        AtlasTypesDef typesDef;
        String serviceType = "open_metadata_ecosystem";
        String entityDescription = "Information used in synchronizing Apache Atlas metadata with external catalogs via the Open Metadata Ecosystem supported by Egeria.";
        String egeriaQualifiedNamePropertyName = "egeriaQualifiedName";
        String egeriaQualifiedNameDescription = "Unique name of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaTypeNamePropertyName = "egeriaTypeName";
        String egeriaTypeNameDescription = "Type name of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaGUIDPropertyName = "egeriaGUID";
        String egeriaGUIDDescription = "Unique identifier of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaOwnedPropertyName = "egeriaOwned";
        String egeriaOwnedDescription = "Boolean flag indicating whether the instance originated in the open metadata ecosystem (true) or Apache Atlas (false).";
        String relationshipDescription = "Relationship to connect a referenceable to correlation information from the open metadata ecosystem.";
        String correlationEndLabel = "openMetadataCorrelation";
        String associatedElementEndLabel = "associatedElement";
        String associatedGlossaryEndLabel = "associatedMeaning";
        String referenceableTypeName = "Referenceable";
        String internalTypeName = "__internal";
        String typeVersion = "V1.0";
        atlasClient.getAllTypes();
        try {
            atlasClient.getEntityType(OPEN_METADATA_CORRELATION_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
            AtlasEntityDef entityDef = new AtlasEntityDef();
            ArrayList<AtlasAttributeDef> attributeDefs = new ArrayList<AtlasAttributeDef>();
            entityDef.setName(OPEN_METADATA_CORRELATION_TYPE_NAME);
            entityDef.setDescription("Information used in synchronizing Apache Atlas metadata with external catalogs via the Open Metadata Ecosystem supported by Egeria.");
            entityDef.setServiceType("open_metadata_ecosystem");
            entityDef.setTypeVersion("V1.0");
            entityDef.setVersion(1L);
            attributeDefs.add(this.getStringAttributeDef("egeriaQualifiedName", "Unique name of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(this.getStringAttributeDef("egeriaTypeName", "Type name of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(this.getStringAttributeDef("egeriaGUID", "Unique identifier of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(this.getBooleanAttributeDef("egeriaOwned", "Boolean flag indicating whether the instance originated in the open metadata ecosystem (true) or Apache Atlas (false)."));
            entityDef.setAttributeDefs(attributeDefs);
            entityDefs.add(entityDef);
            typesDef.setEntityDefs(entityDefs);
            atlasClient.addNewTypes(typesDef);
        }
        try {
            atlasClient.getRelationshipType(OPEN_METADATA_CORRELATION_LINK_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            relationshipDefs = new ArrayList<AtlasRelationshipDef>();
            relationshipDef = new AtlasRelationshipDef();
            end1 = new AtlasRelationshipEndDef();
            end2 = new AtlasRelationshipEndDef();
            relationshipDef.setName(OPEN_METADATA_CORRELATION_LINK_TYPE_NAME);
            relationshipDef.setDescription("Relationship to connect a referenceable to correlation information from the open metadata ecosystem.");
            relationshipDef.setServiceType("open_metadata_ecosystem");
            relationshipDef.setTypeVersion("V1.0");
            relationshipDef.setVersion(1L);
            relationshipDef.setRelationshipCategory(AtlasRelationshipCategory.ASSOCIATION);
            relationshipDef.setPropagateTags(AtlasPropagateTags.NONE);
            end1.setType("Referenceable");
            end1.setName("openMetadataCorrelation");
            end1.setContainer(false);
            end1.setCardinality(AtlasCardinality.SINGLE);
            end1.setLegacyAttribute(false);
            end2.setType(OPEN_METADATA_CORRELATION_TYPE_NAME);
            end2.setName("associatedElement");
            end2.setContainer(false);
            end2.setCardinality(AtlasCardinality.SINGLE);
            end2.setLegacyAttribute(false);
            relationshipDef.setEndDef1(end1);
            relationshipDef.setEndDef2(end2);
            relationshipDefs.add(relationshipDef);
            typesDef.setRelationshipDefs(relationshipDefs);
            atlasClient.addNewTypes(typesDef);
        }
        try {
            atlasClient.getRelationshipType(GLOSSARY_CORRELATION_LINK_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            relationshipDefs = new ArrayList();
            relationshipDef = new AtlasRelationshipDef();
            end1 = new AtlasRelationshipEndDef();
            end2 = new AtlasRelationshipEndDef();
            relationshipDef.setName(GLOSSARY_CORRELATION_LINK_TYPE_NAME);
            relationshipDef.setDescription("Relationship to connect a referenceable to correlation information from the open metadata ecosystem.");
            relationshipDef.setServiceType("open_metadata_ecosystem");
            relationshipDef.setTypeVersion("V1.0");
            relationshipDef.setVersion(1L);
            relationshipDef.setRelationshipCategory(AtlasRelationshipCategory.ASSOCIATION);
            relationshipDef.setPropagateTags(AtlasPropagateTags.NONE);
            end1.setType("__internal");
            end1.setName("openMetadataCorrelation");
            end1.setContainer(false);
            end1.setCardinality(AtlasCardinality.SINGLE);
            end1.setLegacyAttribute(false);
            end2.setType(OPEN_METADATA_CORRELATION_TYPE_NAME);
            end2.setName("associatedMeaning");
            end2.setContainer(false);
            end2.setCardinality(AtlasCardinality.SINGLE);
            end2.setLegacyAttribute(false);
            relationshipDef.setEndDef1(end1);
            relationshipDef.setEndDef2(end2);
            relationshipDefs.add(relationshipDef);
            typesDef.setRelationshipDefs(relationshipDefs);
            atlasClient.addNewTypes(typesDef);
        }
    }

    private AtlasAttributeDef getStringAttributeDef(String propertyName, String propertyDescription) {
        AtlasAttributeDef attributeDef = new AtlasAttributeDef();
        attributeDef.setName(propertyName);
        attributeDef.setDescription(propertyDescription);
        attributeDef.setTypeName("string");
        attributeDef.setOptional(false);
        attributeDef.setCardinality(AtlasCardinality.SINGLE);
        attributeDef.setValuesMinCount(1);
        attributeDef.setValuesMaxCount(1);
        attributeDef.setUnique(false);
        attributeDef.setIndexable(true);
        attributeDef.setIncludeInNotification(false);
        attributeDef.setSearchWeight(10);
        return attributeDef;
    }

    private AtlasAttributeDef getBooleanAttributeDef(String propertyName, String propertyDescription) {
        AtlasAttributeDef attributeDef = new AtlasAttributeDef();
        attributeDef.setName(propertyName);
        attributeDef.setDescription(propertyDescription);
        attributeDef.setTypeName("boolean");
        attributeDef.setOptional(false);
        attributeDef.setCardinality(AtlasCardinality.SINGLE);
        attributeDef.setValuesMinCount(1);
        attributeDef.setValuesMaxCount(1);
        attributeDef.setUnique(false);
        attributeDef.setIndexable(false);
        attributeDef.setIncludeInNotification(false);
        attributeDef.setSearchWeight(10);
        return attributeDef;
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", ApacheAtlasAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName, this.targetRootURL));
        }
        this.atlasClient.disconnect();
        super.disconnect();
    }
}

