/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console;

import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;

public class ConsoleAuditLogStoreConnector
extends OMRSAuditLogStoreConnectorBase {
    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        if (super.isSupportedSeverity(logRecord)) {
            System.out.println(logRecord.getTimeStamp() + " " + logRecord.getOriginator().getServerName() + " " + logRecord.getSeverity() + " " + logRecord.getMessageId() + " " + logRecord.getMessageText());
            if (OMRSAuditLogRecordSeverity.EXCEPTION.getName().equals(logRecord.getSeverity()) && logRecord.getExceptionClassName() != null) {
                System.out.println(logRecord.getTimeStamp() + " " + logRecord.getOriginator().getServerName() + " " + logRecord.getSeverity() + " " + logRecord.getMessageId() + " Supplementary information: log record id " + logRecord.getGUID() + " " + logRecord.getExceptionClassName() + " returned message of " + logRecord.getExceptionMessage() + " and stacktrace of \n" + logRecord.getExceptionStackTrace());
            }
        }
        return logRecord.getGUID();
    }
}

