/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedAuditLogStoreConnector
extends OMRSAuditLogStoreConnectorBase {
    private static final String defaultDirectoryTemplate = "omag.server.auditlog";
    private static final Logger log = LoggerFactory.getLogger(FileBasedAuditLogStoreConnector.class);
    private String logStoreTemplateName = null;

    public void start() throws ConnectorCheckedException {
        super.start();
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.logStoreTemplateName = endpoint.getAddress();
        }
        if (this.logStoreTemplateName == null) {
            this.logStoreTemplateName = defaultDirectoryTemplate;
        }
        try {
            File auditLogStoreDirectory = new File(this.logStoreTemplateName);
            FileUtils.forceMkdir((File)auditLogStoreDirectory);
        }
        catch (IOException ioException) {
            log.error("Unusable Server Audit Log Store :(", (Throwable)ioException);
        }
    }

    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        if (this.isSupportedSeverity(logRecord)) {
            try {
                File configStoreFile = new File(this.logStoreTemplateName + "/log-record-" + logRecord.getGUID());
                ObjectMapper objectMapper = new ObjectMapper();
                String configStoreFileContents = objectMapper.writeValueAsString((Object)logRecord);
                FileUtils.writeStringToFile((File)configStoreFile, (String)configStoreFileContents, (String)null, (boolean)false);
            }
            catch (IOException ioException) {
                log.error("Unusable Server Audit Log Store :(", (Throwable)ioException);
            }
        }
        return logRecord.getGUID();
    }

    public OMRSAuditLogRecord getAuditLogRecord(String logRecordId) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "getAuditLogRecord";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsByTimeStamp(Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByTimeStamp";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsBySeverity(String severity, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsBySeverity";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsByComponent(String component, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByComponent";
        return null;
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

