/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatter {
    private static final Logger log = LoggerFactory.getLogger(MessageFormatter.class);

    private String formatMessage(String messageTemplate, String[] messageParameters) {
        MessageFormat mf = new MessageFormat(messageTemplate);
        String formattedMessage = messageTemplate;
        int parameterCount = 0;
        if (messageParameters != null) {
            parameterCount = messageParameters.length;
            formattedMessage = mf.format(messageParameters);
        }
        if (mf.getFormats().length > parameterCount) {
            log.error("Missing parameter for message {}", (Object)messageTemplate);
        }
        log.debug("New message: {}", (Object)formattedMessage);
        return formattedMessage;
    }

    String getFormattedMessageText(MessageDefinition messageDefinition) {
        return this.formatMessage(messageDefinition.getMessageTemplate(), messageDefinition.getMessageParams());
    }

    public String getFormattedMessage(MessageDefinition messageDefinition) {
        return messageDefinition.getMessageId() + " " + this.formatMessage(messageDefinition.getMessageTemplate(), messageDefinition.getMessageParams());
    }
}

