/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private Date timeStamp = null;
    private Map<String, String> originatorProperties = null;
    private AuditLogReportingComponent originatorComponent = null;
    private String actionDescription = null;
    private long threadId = 0L;
    private String threadName = null;
    private int severityCode = 0;
    private String severity = null;
    private String messageId = null;
    private String messageText = null;
    private String[] messageParameters = null;
    private List<String> additionalInformation = null;
    private String systemAction = null;
    private String userAction = null;
    private String exceptionClassName = null;
    private String exceptionMessage = null;
    private String exceptionStackTrace = null;

    public AuditLogRecord() {
    }

    public AuditLogRecord(AuditLogRecord template) {
        this.guid = template.getGUID();
        this.timeStamp = template.getTimeStamp();
        this.originatorProperties = template.getOriginatorProperties();
        this.originatorComponent = template.getOriginatorComponent();
        this.actionDescription = template.getActionDescription();
        this.threadId = template.getThreadId();
        this.threadName = template.getThreadName();
        this.severityCode = template.getSeverityCode();
        this.severity = template.getSeverity();
        this.messageId = template.getMessageId();
        this.messageText = template.getMessageText();
        this.messageParameters = template.getMessageParameters();
        this.additionalInformation = template.getAdditionalInformation();
        this.systemAction = template.getSystemAction();
        this.userAction = template.getUserAction();
        this.exceptionClassName = template.getExceptionClassName();
        this.exceptionMessage = template.getExceptionMessage();
        this.exceptionStackTrace = template.getExceptionStackTrace();
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Map<String, String> getOriginatorProperties() {
        return this.originatorProperties;
    }

    public void setOriginatorProperties(Map<String, String> originatorProperties) {
        this.originatorProperties = originatorProperties;
    }

    public AuditLogReportingComponent getOriginatorComponent() {
        return this.originatorComponent;
    }

    public void setOriginatorComponent(AuditLogReportingComponent originatorComponent) {
        this.originatorComponent = originatorComponent;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public int getSeverityCode() {
        return this.severityCode;
    }

    public void setSeverityCode(int severityCode) {
        this.severityCode = severityCode;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public void setMessageParameters(String[] messageParameters) {
        this.messageParameters = messageParameters;
    }

    public List<String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public void setSystemAction(String systemAction) {
        this.systemAction = systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public void setExceptionStackTrace(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public String toString() {
        return "AuditLogRecord{guid='" + this.guid + '\'' + ", timeStamp=" + this.timeStamp + ", originator=" + this.originatorProperties + ", reportingComponent=" + this.originatorComponent + ", actionDescription='" + this.actionDescription + '\'' + ", threadId=" + this.threadId + ", threadName='" + this.threadName + '\'' + ", severityCode=" + this.severityCode + ", severity='" + this.severity + '\'' + ", messageId='" + this.messageId + '\'' + ", messageText='" + this.messageText + '\'' + ", messageParameters=" + Arrays.toString(this.messageParameters) + ", additionalInformation=" + this.additionalInformation + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionMessage='" + this.exceptionMessage + '\'' + ", exceptionStackTrace='" + this.exceptionStackTrace + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AuditLogRecord that = (AuditLogRecord)objectToCompare;
        return this.threadId == that.threadId && this.severityCode == that.severityCode && Objects.equals(this.guid, that.guid) && Objects.equals(this.timeStamp, that.timeStamp) && Objects.equals(this.originatorProperties, that.originatorProperties) && Objects.equals(this.originatorComponent, that.originatorComponent) && Objects.equals(this.actionDescription, that.actionDescription) && Objects.equals(this.threadName, that.threadName) && Objects.equals(this.severity, that.severity) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.messageText, that.messageText) && Arrays.equals(this.messageParameters, that.messageParameters) && Objects.equals(this.additionalInformation, that.additionalInformation) && Objects.equals(this.systemAction, that.systemAction) && Objects.equals(this.userAction, that.userAction) && Objects.equals(this.exceptionClassName, that.exceptionClassName) && Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.exceptionStackTrace, that.exceptionStackTrace);
    }

    public int hashCode() {
        int result = Objects.hash(this.guid, this.timeStamp, this.originatorProperties, this.originatorComponent, this.actionDescription, this.threadId, this.threadName, this.severityCode, this.severity, this.messageId, this.messageText, this.additionalInformation, this.systemAction, this.userAction, this.exceptionClassName, this.exceptionMessage, this.exceptionStackTrace);
        result = 31 * result + Arrays.hashCode(this.messageParameters);
        return result;
    }
}

