/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecord;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReport;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLog
extends MessageFormatter {
    private static final Logger log = LoggerFactory.getLogger(AuditLog.class);
    private AuditLogDestination destination;
    private AuditLogReportingComponent reportingComponent;
    protected List<AuditLog> childAuditLogs = new ArrayList<AuditLog>();
    protected AuditLogActivity auditLogActivity = new AuditLogActivity();

    public AuditLog(AuditLogDestination destination, int componentId, ComponentDevelopmentStatus componentDevelopmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        this.destination = destination;
        this.reportingComponent = new AuditLogReportingComponent(componentId, componentDevelopmentStatus, componentName, componentDescription, componentWikiURL);
    }

    public AuditLog(AuditLogDestination destination, ComponentDescription reportingComponent) {
        this.destination = destination;
        this.reportingComponent = new AuditLogReportingComponent(reportingComponent.getComponentId(), reportingComponent.getComponentDevelopmentStatus(), reportingComponent.getComponentName(), reportingComponent.getComponentType(), reportingComponent.getComponentWikiURL());
    }

    public AuditLog createNewAuditLog(int componentId, ComponentDevelopmentStatus componentDevelopmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        AuditLog childAuditLog = new AuditLog(this.destination, componentId, componentDevelopmentStatus, componentName, componentDescription, componentWikiURL);
        log.debug("New audit log for component {}", (Object)componentName);
        this.childAuditLogs.add(childAuditLog);
        log.debug("Current Tree {}", (Object)this.childAuditLogs.toString());
        return childAuditLog;
    }

    public AuditLog createNewAuditLog(ComponentDescription childComponent) {
        return this.createNewAuditLog(childComponent.getComponentId(), childComponent.getComponentDevelopmentStatus(), childComponent.getComponentName(), childComponent.getComponentType(), childComponent.getComponentWikiURL());
    }

    public void logMessage(String actionDescription, AuditLogMessageDefinition messageDefinition) {
        this.storeLogRecord(actionDescription, messageDefinition, null, null);
    }

    public void logMessage(String actionDescription, AuditLogMessageDefinition messageDefinition, String additionalInformation) {
        ArrayList<String> additionalInformationArray = null;
        if (additionalInformation != null) {
            additionalInformationArray = new ArrayList<String>();
            additionalInformationArray.add(additionalInformation);
        }
        this.storeLogRecord(actionDescription, messageDefinition, additionalInformationArray, null);
    }

    public void logMessage(String actionDescription, AuditLogMessageDefinition messageDefinition, List<String> additionalInformation) {
        this.storeLogRecord(actionDescription, messageDefinition, additionalInformation, null);
    }

    public void logException(String actionDescription, AuditLogMessageDefinition messageDefinition, Throwable caughtException) {
        this.storeLogRecord(actionDescription, messageDefinition, null, caughtException);
    }

    public void logException(String actionDescription, AuditLogMessageDefinition messageDefinition, String additionalInformation, Throwable caughtException) {
        ArrayList<String> additionalInformationArray = null;
        if (additionalInformation != null) {
            additionalInformationArray = new ArrayList<String>();
            additionalInformationArray.add(additionalInformation);
        }
        this.storeLogRecord(actionDescription, messageDefinition, additionalInformationArray, caughtException);
    }

    public void logException(String actionDescription, AuditLogMessageDefinition messageDefinition, List<String> additionalInformation, Throwable caughtException) {
        this.storeLogRecord(actionDescription, messageDefinition, additionalInformation, caughtException);
    }

    private void storeLogRecord(String actionDescription, AuditLogMessageDefinition messageDefinition, List<String> additionalInformation, Throwable caughtException) {
        if (this.destination != null) {
            this.destination.addLogRecord(this.createLogRecord(actionDescription, messageDefinition, additionalInformation, caughtException));
        }
    }

    private AuditLogRecord createLogRecord(String actionDescription, AuditLogMessageDefinition messageDefinition, List<String> additionalInformation, Throwable caughtException) {
        AuditLogRecord logRecord = new AuditLogRecord();
        logRecord.setGUID(UUID.randomUUID().toString());
        logRecord.setTimeStamp(new Date());
        if (this.destination != null) {
            logRecord.setOriginatorProperties(this.destination.getOriginatorProperties());
        }
        logRecord.setOriginatorComponent(this.reportingComponent);
        logRecord.setActionDescription(actionDescription);
        logRecord.setThreadId(Thread.currentThread().getId());
        logRecord.setThreadName(Thread.currentThread().getName());
        if (messageDefinition != null) {
            AuditLogRecordSeverity severity = messageDefinition.getSeverity();
            if (severity != null) {
                logRecord.setSeverityCode(severity.getOrdinal());
                logRecord.setSeverity(severity.getName());
                this.auditLogActivity.countRecord(severity.getOrdinal(), severity.getName());
            }
            logRecord.setMessageId(messageDefinition.getMessageId());
            logRecord.setMessageText(this.getFormattedMessageText(messageDefinition));
            logRecord.setMessageParameters(messageDefinition.getMessageParams());
            logRecord.setSystemAction(messageDefinition.getSystemAction());
            logRecord.setUserAction(messageDefinition.getUserAction());
        }
        logRecord.setAdditionalInformation(additionalInformation);
        if (caughtException != null) {
            logRecord.setExceptionClassName(caughtException.getClass().getName());
            logRecord.setExceptionMessage(caughtException.getMessage());
            StringWriter stackTrace = new StringWriter();
            caughtException.printStackTrace(new PrintWriter(stackTrace));
            logRecord.setExceptionStackTrace(stackTrace.toString());
        }
        return logRecord;
    }

    public Map<String, String> getOriginatorProperties() {
        if (this.destination != null) {
            return this.destination.getOriginatorProperties();
        }
        return null;
    }

    public AuditLogReport getReport() {
        AuditLogReport report = new AuditLogReport();
        report.setReportingComponent(this.reportingComponent);
        if (!this.childAuditLogs.isEmpty()) {
            ArrayList<AuditLogReport> nestedReports = new ArrayList<AuditLogReport>();
            for (AuditLog auditLog : this.childAuditLogs) {
                if (auditLog == null) continue;
                nestedReports.add(auditLog.getReport());
            }
            if (!nestedReports.isEmpty()) {
                report.setChildAuditLogReports(nestedReports);
            }
        }
        report.setSeverityIdentification(this.auditLogActivity.getSeverityIdentificationMap());
        report.setSeverityCount(this.auditLogActivity.getSeverityCountMap());
        return report;
    }

    public static class AuditLogActivity {
        private volatile Map<Integer, List<String>> severityIdentificationMap = new HashMap<Integer, List<String>>();
        private volatile Map<Integer, Integer> severityCountMap = new HashMap<Integer, Integer>();

        public synchronized void countRecord(int severityCode, String severityName) {
            List<Object> severityNames;
            if (this.severityIdentificationMap.containsKey(severityCode)) {
                severityNames = this.severityIdentificationMap.get(severityCode);
                if (!severityNames.contains(severityName)) {
                    severityNames.add(severityName);
                    this.severityIdentificationMap.put(severityCode, severityNames);
                }
            } else {
                severityNames = new ArrayList<String>();
                severityNames.add(severityName);
                this.severityIdentificationMap.put(severityCode, severityNames);
            }
            int severityCount = 0;
            if (this.severityCountMap.containsKey(severityCode)) {
                severityCount = this.severityCountMap.get(severityCode);
            }
            this.severityCountMap.put(severityCode, ++severityCount);
        }

        synchronized Map<Integer, List<String>> getSeverityIdentificationMap() {
            if (!this.severityIdentificationMap.isEmpty()) {
                HashMap<Integer, List<String>> result = new HashMap<Integer, List<String>>();
                for (Integer severityCode : this.severityIdentificationMap.keySet()) {
                    List<String> severityNames = this.severityIdentificationMap.get(severityCode);
                    if (severityNames == null || severityNames.isEmpty()) continue;
                    result.put(severityCode, new ArrayList<String>(severityNames));
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return null;
        }

        synchronized Map<Integer, Integer> getSeverityCountMap() {
            if (!this.severityCountMap.isEmpty()) {
                HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
                for (Integer severityCode : this.severityCountMap.keySet()) {
                    Integer severityCount = this.severityCountMap.get(severityCode);
                    result.put(severityCode, severityCount);
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return null;
        }
    }
}

