/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

public enum ComponentDevelopmentStatus {
    IN_DEVELOPMENT(0, "In Development", "This component is still being built.  Some features may work but it is still subject to change."),
    TECHNICAL_PREVIEW(1, "Technical Preview", "This component is complete and can be used.  However some features may change based on the feedback from early adopters."),
    STABLE(2, "Stable", "This component is complete and can be used.  Any updates will be added in a backward compatible manner."),
    SAMPLE(3, "Sample", "This component is supplied as a sample.  It can be used 'as is' or may be modified as desired."),
    DEPRECATED(99, "Deprecated", "This component is deprecated an may be removed in a later release.");

    private final int ordinal;
    private final String name;
    private final String description;
    private static final long serialVersionUID = 1L;

    private ComponentDevelopmentStatus(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ComponentDevelopmentStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

