/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.jdbc.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum JDBCAuditLogErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "JDBC-AUDIT-LOG-400-001", "Audit log destination connector {0} has been configured without the URL to the database", "The connector does not emit audit log events.", "The database connection URL is configured in the audit log destination connector's connection endpoint in the address property."),
    NULL_USER(400, "JDBC-AUDIT-LOG-400-002", "Audit log destination connector {0} has been configured with either a null userId or password for connecting to Apache Atlas", "The connector is moved to FAILED status and will no longer be called to synchronize metadata.", "Update the connection information for the connector from the server's configuration document."),
    UNEXPECTED_EXCEPTION(500, "JDBC-AUDIT-LOG-500-001", "The {0} audit log destination connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to store audit log records.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private final ExceptionMessageDefinition messageDefinition;

    private JDBCAuditLogErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "JDBCAuditLogErrorCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

