/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLColumn;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLForeignKey;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLTable;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.schema.AuditLogColumn;

public enum AuditLogTable implements PostgreSQLTable
{
    API_CALLS("al_api_calls", "Details of API calls made.", null, new AuditLogColumn[]{AuditLogColumn.THREAD_ID, AuditLogColumn.SERVER_NAME, AuditLogColumn.USER_NAME, AuditLogColumn.OPERATION_NAME, AuditLogColumn.SERVICE_NAME, AuditLogColumn.CALL_TIME}),
    ASSET_ACTIVITY("al_asset_activity", "Details to the activity around assets.", null, new AuditLogColumn[]{AuditLogColumn.THREAD_ID, AuditLogColumn.SERVER_NAME, AuditLogColumn.CALL_TIME, AuditLogColumn.ASSET_OPERATION, AuditLogColumn.ASSET_GUID, AuditLogColumn.ASSET_TYPE, AuditLogColumn.OPERATION_NAME, AuditLogColumn.SERVICE_NAME, AuditLogColumn.USER_NAME}),
    AUDIT_EVENTS("al_audit_events", "All of the captured audit events.", new AuditLogColumn[]{AuditLogColumn.LOG_RECORD_ID, AuditLogColumn.MESSAGE_TIMESTAMP}, new AuditLogColumn[]{AuditLogColumn.SERVER_NAME, AuditLogColumn.ACTION_DESCRIPTION, AuditLogColumn.SEVERITY_CODE, AuditLogColumn.SEVERITY, AuditLogColumn.MESSAGE_ID, AuditLogColumn.MESSAGE_TEXT, AuditLogColumn.MESSAGE_PARAMETERS, AuditLogColumn.SYSTEM_ACTION, AuditLogColumn.USER_ACTION, AuditLogColumn.EXCEPTION_CLASS_NAME, AuditLogColumn.EXCEPTION_MESSAGE, AuditLogColumn.EXCEPTION_STACK_TRACE, AuditLogColumn.ORGANIZATION, AuditLogColumn.COMPONENT_NAME, AuditLogColumn.ADDITIONAL_INFO, AuditLogColumn.THREAD_ID}),
    EGERIA_COMPONENTS("al_egeria_components", "The components producing audit log events.", new AuditLogColumn[]{AuditLogColumn.COMPONENT_ID}, new AuditLogColumn[]{AuditLogColumn.DEVELOPMENT_STATUS, AuditLogColumn.COMPONENT_NAME, AuditLogColumn.COMPONENT_DESCRIPTION, AuditLogColumn.COMPONENT_WIKI_URL}),
    EGERIA_EXCEPTIONS("al_egeria_exceptions", "The exceptions caught in the audit log events.", new AuditLogColumn[]{AuditLogColumn.LOG_RECORD_ID}, new AuditLogColumn[]{AuditLogColumn.EXCEPTION_CLASS_NAME, AuditLogColumn.EXCEPTION_MESSAGE, AuditLogColumn.EXCEPTION_STACK_TRACE, AuditLogColumn.SYSTEM_ACTION, AuditLogColumn.USER_ACTION, AuditLogColumn.MESSAGE_TIMESTAMP}),
    OMAG_SERVERS("al_omag_servers", "The servers producing audit log records.", new AuditLogColumn[]{AuditLogColumn.SERVER_NAME}, new AuditLogColumn[]{AuditLogColumn.SERVER_TYPE, AuditLogColumn.ORGANIZATION, AuditLogColumn.METADATA_COLLECTION_ID});

    private final String tableName;
    private final String tableDescription;
    private final AuditLogColumn[] primaryKeys;
    private final AuditLogColumn[] dataColumns;

    private AuditLogTable(String tableName, String tableDescription, AuditLogColumn[] primaryKeys, AuditLogColumn[] dataColumns) {
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.primaryKeys = primaryKeys;
        this.dataColumns = dataColumns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableName(String schemaName) {
        return schemaName + "." + this.tableName;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public List<PostgreSQLColumn> getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return Arrays.asList(this.primaryKeys);
        }
        return null;
    }

    public List<PostgreSQLColumn> getDataColumns() {
        if (this.dataColumns != null) {
            return Arrays.asList(this.dataColumns);
        }
        return null;
    }

    public Map<String, Integer> getColumnNameTypeMap() {
        HashMap<String, Integer> columnNameTypeMap = new HashMap<String, Integer>();
        if (this.primaryKeys != null) {
            for (AuditLogColumn column : this.primaryKeys) {
                columnNameTypeMap.put(column.getColumnName(), column.getColumnType().getJdbcType());
            }
        }
        if (this.dataColumns != null) {
            for (AuditLogColumn column : this.dataColumns) {
                columnNameTypeMap.put(column.getColumnName(), column.getColumnType().getJdbcType());
            }
        }
        return columnNameTypeMap;
    }

    public List<PostgreSQLForeignKey> getForeignKeys() {
        return null;
    }

    public static List<PostgreSQLTable> getTables() {
        return new ArrayList<PostgreSQLTable>(Arrays.asList(AuditLogTable.values()));
    }

    public String toString() {
        return "AuditLogTable{" + this.tableName + "}";
    }
}

