/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.controls.JDBCConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLSchemaDDL;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.ffdc.PostgreSQLAuditLogErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.schema.AuditLogColumn;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.schema.AuditLogTable;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.metadataobservability.ffdc.OpenMetadataObservabilityAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLAuditLogDestinationConnector
extends OMRSAuditLogStoreConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLAuditLogDestinationConnector.class);
    private static final String ASSET_ACTIVITY_CREATE = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_CREATE.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_READ = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_READ.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_READ_ATTACHMENT = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_READ_ATTACHMENT.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_UPDATE_ATTACHMENT = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE_ATTACHMENT.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_UPDATE_FEEDBACK = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE_FEEDBACK.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_UPDATE = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_DELETE = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_DELETE.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_SEARCH = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_SEARCH.getMessageDefinition().getMessageId();
    private static final String ASSET_ACTIVITY_SEARCH_ATTACHMENT = OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_SEARCH_ATTACHMENT.getMessageDefinition().getMessageId();
    private static final String USER_REQUEST_ACTIVITY = OpenMetadataObservabilityAuditCode.USER_REQUEST_ACTIVITY.getMessageDefinition().getMessageId();
    private String connectorName = null;
    private JDBCResourceConnector databaseClient = null;

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        this.connectorName = this.connectionDetails.getConnectionName();
        if (this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof JDBCResourceConnector)) continue;
                JDBCResourceConnector jdbcResourceConnector = (JDBCResourceConnector)embeddedConnector;
                try {
                    if (!jdbcResourceConnector.isActive()) {
                        jdbcResourceConnector.start();
                    }
                    this.databaseClient = jdbcResourceConnector;
                    String schemaName = super.getStringConfigurationProperty(JDBCConfigurationProperty.DATABASE_SCHEMA.getName(), this.connectionDetails.getConfigurationProperties());
                    this.loadDDL(this.databaseClient, schemaName);
                    break;
                }
                catch (Exception exception) {
                    throw new OMRSRuntimeException(PostgreSQLAuditLogErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "start", exception.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", exception);
                }
            }
        }
    }

    private void loadDDL(JDBCResourceConnector jdbcResourceConnector, String schemaName) throws RepositoryErrorException {
        String methodName = "loadDDL";
        Connection databaseConnection = null;
        try {
            databaseConnection = jdbcResourceConnector.getDataSource().getConnection();
            PostgreSQLSchemaDDL postgreSQLSchemaDDL = new PostgreSQLSchemaDDL(schemaName, "Audit log records for one or more OMAG Servers.", AuditLogTable.getTables());
            jdbcResourceConnector.addDatabaseDefinitions(databaseConnection, postgreSQLSchemaDDL.getDDLStatements());
            databaseConnection.commit();
        }
        catch (Exception error) {
            if (databaseConnection != null) {
                try {
                    databaseConnection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RepositoryErrorException(PostgreSQLAuditLogErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(schemaName, error.getClass().getName(), "loadDDL", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "loadDDL", error);
        }
    }

    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        if (super.isSupportedSeverity(logRecord)) {
            Connection databaseConnection = null;
            try {
                databaseConnection = this.databaseClient.getDataSource().getConnection();
                String messageParameters = "";
                String additionalInformation = "";
                if (logRecord.getMessageParameters() != null) {
                    messageParameters = Arrays.toString(logRecord.getMessageParameters());
                }
                if (logRecord.getAdditionalInformation() != null) {
                    additionalInformation = logRecord.getAdditionalInformation().toString();
                }
                this.syncEgeriaComponent(databaseConnection, logRecord.getOriginatorComponent());
                this.syncOMAGServer(databaseConnection, (String)logRecord.getOriginatorProperties().get("serverName"), (String)logRecord.getOriginatorProperties().get("serverType"), (String)logRecord.getOriginatorProperties().get("organizationName"), (String)logRecord.getOriginatorProperties().get("metadataCollectionId"));
                if (logRecord.getSeverityCode() == OMRSAuditLogRecordSeverity.ACTIVITY.getOrdinal()) {
                    if (ASSET_ACTIVITY_CREATE.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Create", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_READ.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Read", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_READ_ATTACHMENT.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Read Attachment", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_UPDATE_ATTACHMENT.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Update Attachment", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_UPDATE_FEEDBACK.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Feedback", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_UPDATE.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Update", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_DELETE.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Delete", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_SEARCH.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Search", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (ASSET_ACTIVITY_SEARCH_ATTACHMENT.equals(logRecord.getMessageId())) {
                        this.syncAssetActivity(databaseConnection, logRecord.getThreadId(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getTimeStamp(), "Asset Search Attachment", logRecord.getMessageParameters()[2], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[4], logRecord.getMessageParameters()[0]);
                    } else if (USER_REQUEST_ACTIVITY.equals(logRecord.getMessageId())) {
                        this.syncAPICall(databaseConnection, logRecord.getThreadId(), logRecord.getMessageParameters()[3], logRecord.getMessageParameters()[0], logRecord.getMessageParameters()[1], logRecord.getMessageParameters()[2], logRecord.getTimeStamp());
                    }
                } else {
                    this.syncAuditEvent(databaseConnection, logRecord.getTimeStamp(), (String)logRecord.getOriginatorProperties().get("serverName"), logRecord.getActionDescription(), Integer.toString(logRecord.getSeverityCode()), logRecord.getSeverity(), logRecord.getMessageId(), logRecord.getMessageText(), messageParameters, logRecord.getSystemAction(), logRecord.getUserAction(), logRecord.getExceptionClassName(), logRecord.getExceptionMessage(), logRecord.getExceptionStackTrace(), (String)logRecord.getOriginatorProperties().get("organizationName"), logRecord.getOriginatorComponent().getComponentName(), additionalInformation, logRecord.getGUID(), logRecord.getThreadId());
                    if (logRecord.getSeverityCode() == OMRSAuditLogRecordSeverity.EXCEPTION.getOrdinal()) {
                        this.syncEgeriaException(databaseConnection, logRecord.getGUID(), logRecord.getTimeStamp(), logRecord.getExceptionClassName(), logRecord.getExceptionMessage(), logRecord.getExceptionStackTrace(), logRecord.getSystemAction(), logRecord.getUserAction());
                    }
                }
                databaseConnection.commit();
            }
            catch (Exception error) {
                log.error("Unusable JDBC Audit Log Store: " + this.connectorName, (Throwable)error);
            }
        }
        return logRecord.getGUID();
    }

    private void syncAPICall(Connection databaseConnection, long threadId, String serverName, String userName, String operationName, String serviceName, Date callTime) {
        String methodName = "syncAPICall";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getAPICallDataValues(threadId, serverName, userName, operationName, serviceName, callTime);
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.API_CALLS.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncAPICall", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getAPICallDataValues(long threadId, String serverName, String userName, String operationName, String serviceName, Date callTime) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.THREAD_ID.getColumnName(), new JDBCDataValue((Object)threadId, AuditLogColumn.THREAD_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVER_NAME.getColumnName(), new JDBCDataValue((Object)serverName, AuditLogColumn.SERVER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.USER_NAME.getColumnName(), new JDBCDataValue((Object)userName, AuditLogColumn.USER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.OPERATION_NAME.getColumnName(), new JDBCDataValue((Object)operationName, AuditLogColumn.OPERATION_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVICE_NAME.getColumnName(), new JDBCDataValue((Object)serviceName, AuditLogColumn.SERVICE_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.CALL_TIME.getColumnName(), new JDBCDataValue((Object)new Timestamp(callTime.getTime()), AuditLogColumn.CALL_TIME.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    private void syncAssetActivity(Connection databaseConnection, long threadId, String serverName, Date callTime, String assetOperation, String assetGUID, String assetType, String operationName, String serviceName, String userName) {
        String methodName = "syncAssetActivity";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getAssetActivityDataValues(threadId, serverName, callTime, assetOperation, assetGUID, assetType, operationName, serviceName, userName);
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.ASSET_ACTIVITY.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncAssetActivity", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getAssetActivityDataValues(long threadId, String serverName, Date callTime, String assetOperation, String assetGUID, String assetType, String operationName, String serviceName, String userName) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.THREAD_ID.getColumnName(), new JDBCDataValue((Object)threadId, AuditLogColumn.THREAD_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVER_NAME.getColumnName(), new JDBCDataValue((Object)serverName, AuditLogColumn.SERVER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.USER_NAME.getColumnName(), new JDBCDataValue((Object)userName, AuditLogColumn.USER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ASSET_OPERATION.getColumnName(), new JDBCDataValue((Object)assetOperation, AuditLogColumn.ASSET_OPERATION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ASSET_GUID.getColumnName(), new JDBCDataValue((Object)assetGUID, AuditLogColumn.ASSET_GUID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ASSET_TYPE.getColumnName(), new JDBCDataValue((Object)assetType, AuditLogColumn.ASSET_TYPE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.OPERATION_NAME.getColumnName(), new JDBCDataValue((Object)operationName, AuditLogColumn.OPERATION_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVICE_NAME.getColumnName(), new JDBCDataValue((Object)serviceName, AuditLogColumn.SERVICE_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.CALL_TIME.getColumnName(), new JDBCDataValue((Object)new Timestamp(callTime.getTime()), AuditLogColumn.CALL_TIME.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    private void syncAuditEvent(Connection databaseConnection, Date messageTimestamp, String serverName, String actionDescription, String severityCode, String severity, String messageId, String messageText, String messageParameters, String systemAction, String userAction, String exceptionClassName, String exceptionMessage, String exceptionStacktrace, String organization, String componentName, String additionalInfo, String logRecordId, long threadId) {
        String methodName = "syncAuditEvent";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getAuditEventDataValues(messageTimestamp, serverName, actionDescription, severityCode, severity, messageId, messageText, messageParameters, systemAction, userAction, exceptionClassName, exceptionMessage, exceptionStacktrace, organization, componentName, additionalInfo, logRecordId, threadId);
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.AUDIT_EVENTS.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncAuditEvent", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getAuditEventDataValues(Date messageTimestamp, String serverName, String actionDescription, String severityCode, String severity, String messageId, String messageText, String messageParameters, String systemAction, String userAction, String exceptionClassName, String exceptionMessage, String exceptionStacktrace, String organization, String componentName, String additionalInfo, String logRecordId, long threadId) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.MESSAGE_TIMESTAMP.getColumnName(), new JDBCDataValue((Object)new Timestamp(messageTimestamp.getTime()), AuditLogColumn.MESSAGE_TIMESTAMP.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ACTION_DESCRIPTION.getColumnName(), new JDBCDataValue((Object)actionDescription, AuditLogColumn.ACTION_DESCRIPTION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVER_NAME.getColumnName(), new JDBCDataValue((Object)serverName, AuditLogColumn.SERVER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SEVERITY_CODE.getColumnName(), new JDBCDataValue((Object)severityCode, AuditLogColumn.SEVERITY_CODE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SEVERITY.getColumnName(), new JDBCDataValue((Object)severity, AuditLogColumn.SEVERITY.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.MESSAGE_ID.getColumnName(), new JDBCDataValue((Object)messageId, AuditLogColumn.MESSAGE_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.MESSAGE_TEXT.getColumnName(), new JDBCDataValue((Object)messageText, AuditLogColumn.MESSAGE_TEXT.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.MESSAGE_PARAMETERS.getColumnName(), new JDBCDataValue((Object)messageParameters, AuditLogColumn.MESSAGE_PARAMETERS.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SYSTEM_ACTION.getColumnName(), new JDBCDataValue((Object)systemAction, AuditLogColumn.SYSTEM_ACTION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.USER_ACTION.getColumnName(), new JDBCDataValue((Object)userAction, AuditLogColumn.USER_ACTION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_CLASS_NAME.getColumnName(), new JDBCDataValue((Object)exceptionClassName, AuditLogColumn.EXCEPTION_CLASS_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_MESSAGE.getColumnName(), new JDBCDataValue((Object)exceptionMessage, AuditLogColumn.EXCEPTION_MESSAGE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_STACK_TRACE.getColumnName(), new JDBCDataValue((Object)exceptionStacktrace, AuditLogColumn.EXCEPTION_STACK_TRACE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ORGANIZATION.getColumnName(), new JDBCDataValue((Object)organization, AuditLogColumn.ORGANIZATION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.COMPONENT_NAME.getColumnName(), new JDBCDataValue((Object)componentName, AuditLogColumn.COMPONENT_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ADDITIONAL_INFO.getColumnName(), new JDBCDataValue((Object)additionalInfo, AuditLogColumn.ADDITIONAL_INFO.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.LOG_RECORD_ID.getColumnName(), new JDBCDataValue((Object)logRecordId, AuditLogColumn.LOG_RECORD_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.THREAD_ID.getColumnName(), new JDBCDataValue((Object)threadId, AuditLogColumn.THREAD_ID.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    private void syncEgeriaComponent(Connection databaseConnection, AuditLogReportingComponent component) {
        String methodName = "syncEgeriaComponent";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getEgeriaComponentDataValues(component.getComponentId(), component.getComponentDevelopmentStatus().getName(), component.getComponentName(), component.getComponentDescription(), component.getComponentWikiURL());
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.EGERIA_COMPONENTS.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncEgeriaComponent", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getEgeriaComponentDataValues(int componentId, String developmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.COMPONENT_ID.getColumnName(), new JDBCDataValue((Object)componentId, AuditLogColumn.COMPONENT_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.DEVELOPMENT_STATUS.getColumnName(), new JDBCDataValue((Object)developmentStatus, AuditLogColumn.DEVELOPMENT_STATUS.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.COMPONENT_NAME.getColumnName(), new JDBCDataValue((Object)componentName, AuditLogColumn.COMPONENT_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.COMPONENT_DESCRIPTION.getColumnName(), new JDBCDataValue((Object)componentDescription, AuditLogColumn.COMPONENT_DESCRIPTION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.COMPONENT_WIKI_URL.getColumnName(), new JDBCDataValue((Object)componentWikiURL, AuditLogColumn.COMPONENT_WIKI_URL.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    private void syncEgeriaException(Connection databaseConnection, String logRecordId, Date messageTimestamp, String exceptionClassName, String exceptionMessage, String exceptionStacktrace, String systemAction, String userAction) {
        String methodName = "syncEgeriaException";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getEgeriaExceptionDataValues(logRecordId, messageTimestamp, exceptionClassName, exceptionMessage, exceptionStacktrace, systemAction, userAction);
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.EGERIA_EXCEPTIONS.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncEgeriaException", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getEgeriaExceptionDataValues(String logRecordId, Date messageTimestamp, String exceptionClassName, String exceptionMessage, String exceptionStackTrace, String systemAction, String userAction) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.LOG_RECORD_ID.getColumnName(), new JDBCDataValue((Object)logRecordId, AuditLogColumn.LOG_RECORD_ID.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.MESSAGE_TIMESTAMP.getColumnName(), new JDBCDataValue((Object)new Timestamp(messageTimestamp.getTime()), AuditLogColumn.MESSAGE_TIMESTAMP.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_CLASS_NAME.getColumnName(), new JDBCDataValue((Object)exceptionClassName, AuditLogColumn.EXCEPTION_CLASS_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_MESSAGE.getColumnName(), new JDBCDataValue((Object)exceptionMessage, AuditLogColumn.EXCEPTION_MESSAGE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.EXCEPTION_STACK_TRACE.getColumnName(), new JDBCDataValue((Object)exceptionStackTrace, AuditLogColumn.EXCEPTION_STACK_TRACE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SYSTEM_ACTION.getColumnName(), new JDBCDataValue((Object)systemAction, AuditLogColumn.SYSTEM_ACTION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.USER_ACTION.getColumnName(), new JDBCDataValue((Object)userAction, AuditLogColumn.USER_ACTION.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    private void syncOMAGServer(Connection databaseConnection, String serverName, String serverType, String organization, String metadataCollectionId) {
        String methodName = "syncOMAGServer";
        try {
            Map<String, JDBCDataValue> openMetadataRecord = this.getOMAGServerDataValues(serverName, serverType, organization, metadataCollectionId);
            this.databaseClient.insertRowIntoTable(databaseConnection, AuditLogTable.OMAG_SERVERS.getTableName(), openMetadataRecord);
        }
        catch (Exception error) {
            log.error("syncOMAGServer", (Throwable)error);
        }
    }

    private Map<String, JDBCDataValue> getOMAGServerDataValues(String serverName, String serverType, String organization, String metadataCollectionId) {
        HashMap<String, JDBCDataValue> openMetadataRecord = new HashMap<String, JDBCDataValue>();
        openMetadataRecord.put(AuditLogColumn.SERVER_NAME.getColumnName(), new JDBCDataValue((Object)serverName, AuditLogColumn.SERVER_NAME.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.SERVER_TYPE.getColumnName(), new JDBCDataValue((Object)serverType, AuditLogColumn.SERVER_TYPE.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.ORGANIZATION.getColumnName(), new JDBCDataValue((Object)organization, AuditLogColumn.ORGANIZATION.getColumnType().getJdbcType()));
        openMetadataRecord.put(AuditLogColumn.METADATA_COLLECTION_ID.getColumnName(), new JDBCDataValue((Object)metadataCollectionId, AuditLogColumn.METADATA_COLLECTION_ID.getColumnType().getJdbcType()));
        return openMetadataRecord;
    }

    public OMRSAuditLogRecord getAuditLogRecord(String logRecordId) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "getAuditLogRecord";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsByTimeStamp(Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByTimeStamp";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsBySeverity(String severity, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsBySeverity";
        return null;
    }

    public List<OMRSAuditLogRecord> getAuditLogRecordsByComponent(String component, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByComponent";
        return null;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.databaseClient != null) {
            this.databaseClient.disconnect();
        }
        super.disconnect();
    }
}

