/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JAuditLogStoreConnector
extends OMRSAuditLogStoreConnectorBase {
    private Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        String loggerName = logRecord.getOriginator().getServerName() + "." + logRecord.getReportingComponent().getComponentName();
        Logger log = this.loggerMap.get(loggerName);
        if (log == null) {
            log = LoggerFactory.getLogger((String)loggerName);
            this.loggerMap.put(loggerName, log);
        }
        if (super.isSupportedSeverity(logRecord)) {
            if (OMRSAuditLogRecordSeverity.ERROR.getName().equals(logRecord.getSeverity()) || OMRSAuditLogRecordSeverity.EXCEPTION.getName().equals(logRecord.getSeverity())) {
                log.error(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getMessageId() + " " + logRecord.getMessageText());
                if (logRecord.getExceptionClassName() != null) {
                    log.error(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getExceptionClassName() + " returned message of " + logRecord.getExceptionMessage() + " and stacktrace of " + logRecord.getExceptionStackTrace());
                }
            } else {
                log.info(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getMessageId() + " " + logRecord.getMessageText());
            }
        }
        return logRecord.getGUID();
    }
}

