/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.slf4j;

import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JAuditLogStoreConnector
extends OMRSAuditLogStoreConnectorBase {
    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        String loggerName = logRecord.getOriginator().getServerName() + "." + logRecord.getOriginatorComponent().getComponentName();
        Logger log = LoggerFactory.getLogger((String)loggerName);
        if (super.isSupportedSeverity(logRecord)) {
            if (OMRSAuditLogRecordSeverity.ERROR.getName().equals(logRecord.getSeverity()) || OMRSAuditLogRecordSeverity.EXCEPTION.getName().equals(logRecord.getSeverity())) {
                log.error(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getMessageId() + " " + logRecord.getMessageText());
                if (logRecord.getExceptionClassName() != null) {
                    log.error(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getExceptionClassName() + " returned message of " + logRecord.getExceptionMessage() + " and stacktrace of " + logRecord.getExceptionStackTrace());
                }
            } else {
                log.info(logRecord.getOriginator().getServerName() + logRecord.getGUID() + " " + logRecord.getMessageId() + " " + logRecord.getMessageText());
            }
        }
        return logRecord.getGUID();
    }
}

