/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.server;

import org.odpi.openmetadata.accessservices.assetowner.client.AssetCertificationManager;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetLicenseManager;
import org.odpi.openmetadata.accessservices.assetowner.client.AvroFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetowner.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.assetowner.client.FileSystemAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetowner.client.ValidValuesAssetOwner;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class AutomatedCurationInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.AUTOMATED_CURATION;
    private final AssetCertificationManager assetCertificationManager;
    private final AssetLicenseManager assetLicenseManager;
    private final ExternalReferenceManager externalReferenceManager;
    private final ValidValuesAssetOwner validValuesAssetOwner;
    private final FileSystemAssetOwner fileSystemAssetOwner;
    private final CSVFileAssetOwner csvFileAssetOwner;
    private final AvroFileAssetOwner avroFileAssetOwner;
    private final OpenMetadataStoreClient openMetadataStoreClient;
    private final OpenGovernanceClient openGovernanceClient;
    private final OpenIntegrationServiceClient openIntegrationServiceClient;
    private final ConnectedAssetClient connectedAssetClient;

    public AutomatedCurationInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.assetCertificationManager = new AssetCertificationManager(remoteServerName, remoteServerURL);
        this.assetLicenseManager = new AssetLicenseManager(remoteServerName, remoteServerURL);
        this.externalReferenceManager = new ExternalReferenceManager(remoteServerName, remoteServerURL);
        this.validValuesAssetOwner = new ValidValuesAssetOwner(remoteServerName, remoteServerURL);
        this.fileSystemAssetOwner = new FileSystemAssetOwner(remoteServerName, remoteServerURL, auditLog);
        this.csvFileAssetOwner = new CSVFileAssetOwner(remoteServerName, remoteServerURL, auditLog);
        this.avroFileAssetOwner = new AvroFileAssetOwner(remoteServerName, remoteServerURL, auditLog);
        this.connectedAssetClient = new ConnectedAssetClient(remoteServerName, remoteServerURL);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openGovernanceClient = new OpenGovernanceClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openIntegrationServiceClient = new OpenIntegrationServiceClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public AssetCertificationManager getAssetCertificationManager() {
        return this.assetCertificationManager;
    }

    public AssetLicenseManager getAssetLicenseManager() {
        return this.assetLicenseManager;
    }

    public ExternalReferenceManager getExternalReferenceManager() {
        return this.externalReferenceManager;
    }

    public ValidValuesAssetOwner getValidValuesAssetOwner() {
        return this.validValuesAssetOwner;
    }

    public FileSystemAssetOwner getFileSystemAssetOwner() {
        return this.fileSystemAssetOwner;
    }

    public CSVFileAssetOwner getCSVFileAssetOwner() {
        return this.csvFileAssetOwner;
    }

    public AvroFileAssetOwner getAvroFileAssetOwner() {
        return this.avroFileAssetOwner;
    }

    public ConnectedAssetClient getConnectedAssetClient() {
        return this.connectedAssetClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }

    public OpenGovernanceClient getOpenGovernanceClient() {
        return this.openGovernanceClient;
    }

    public OpenIntegrationServiceClient getOpenIntegrationServiceClient() {
        return this.openIntegrationServiceClient;
    }
}

